/*
 * Decompiled with CFR 0.152.
 */
package kamon.play.instrumentation;

import kamon.Kamon$;
import kamon.context.Context;
import kamon.play.Play$;
import kamon.play.instrumentation.package$;
import kamon.play.instrumentation.package$StatusCodes$;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanCustomizer;
import kamon.trace.SpanCustomizer$;
import kamon.trace.Tracer;
import kamon.util.CallingThreadExecutionContext$;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import play.api.libs.ws.WSRequest;
import play.api.libs.ws.WSResponse;
import scala.Function1;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Aspect
@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u0013\t\trkU%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011aD5ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001\u00029mCfT\u0011aB\u0001\u0006W\u0006lwN\\\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAQA\u0006\u0001\u0005\u0002]\t\u0001c\u001c8Fq\u0016\u001cW\u000f^3SKF,Xm\u001d;\u0015\u0005aY\u0002CA\u0006\u001a\u0013\tQBB\u0001\u0003V]&$\b\"\u0002\u000f\u0016\u0001\u0004i\u0012a\u0002:fcV,7\u000f\u001e\t\u0003=\u0019j\u0011a\b\u0006\u0003A\u0005\n!a^:\u000b\u0005\t\u001a\u0013\u0001\u00027jENT!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0013\t9sDA\u0005X'J+\u0017/^3ti\"\"Q#K\u001b7!\tQ3'D\u0001,\u0015\taS&\u0001\u0006b]:|G/\u0019;j_:T!AL\u0018\u0002\t1\fgn\u001a\u0006\u0003aE\nq!Y:qK\u000e$(NC\u00013\u0003\ry'oZ\u0005\u0003i-\u0012\u0001\u0002U8j]R\u001cW\u000f^\u0001\u0006m\u0006dW/Z\u0011\u0002o\u0005YU\r_3dkRLwN\u001c\u0015+AAd\u0017-\u001f\u0018ba&tC.\u001b2t]]\u001chF\\5oO:r\u0015N\\4X'J+\u0017/^3ti:*\u00070Z2vi\u0016D\u0013&\u000b\u0011'M\u0001\"\b.[:)e\u0016\fX/Z:uS!)\u0011\b\u0001C\u0001u\u0005!\u0012M]8v]\u0012,\u00050Z2vi\u0016\u0014V-];fgR$2a\u000f E!\tYA(\u0003\u0002>\u0019\t\u0019\u0011I\\=\t\u000b}B\u0004\u0019\u0001!\u0002\u0007AT\u0007\u000f\u0005\u0002B\u00056\tQ&\u0003\u0002D[\t\u0019\u0002K]8dK\u0016$\u0017N\\4K_&t\u0007k\\5oi\")A\u0004\u000fa\u0001;!\"\u0001HR\u001bJ!\tQs)\u0003\u0002IW\t1\u0011I]8v]\u0012\f\u0013AS\u0001\u001a_:,\u00050Z2vi\u0016\u0014V-];fgRD#/Z9vKN$\u0018\u0006\u000b\u0002\u0001\u0019B\u0011!&T\u0005\u0003\u001d.\u0012a!Q:qK\u000e$\b")
public class WSInstrumentation {
    @Pointcut(value="execution(* play.api.libs.ws.ning.NingWSRequest.execute()) && this(request)")
    public void onExecuteRequest(WSRequest request) {
    }

    @Around(value="onExecuteRequest(request)")
    public Object aroundExecuteRequest(ProceedingJoinPoint pjp, WSRequest request) {
        Object object;
        Context currentContext = Kamon$.MODULE$.currentContext();
        Span clientSpan = (Span)currentContext.get(Span$.MODULE$.ContextKey());
        if (clientSpan.isEmpty()) {
            object = pjp.proceed();
        } else {
            Tracer.SpanBuilder clientSpanBuilder = Kamon$.MODULE$.buildSpan(Play$.MODULE$.generateHttpClientOperationName(request)).asChildOf(clientSpan).withTag("span.kind", "client").withTag("component", "play.client.ws").withTag("http.method", request.method()).withTag("http.url", request.uri().toString());
            Span clientRequestSpan = ((SpanCustomizer)currentContext.get(SpanCustomizer$.MODULE$.ContextKey())).customize(clientSpanBuilder).start();
            Context newContext = currentContext.withKey(Span$.MODULE$.ContextKey(), (Object)clientRequestSpan);
            Future responseFuture = (Future)pjp.proceed(new Object[]{package$.MODULE$.encodeContext(newContext, request)});
            object = responseFuture.transform((Function1)new Serializable(this, clientRequestSpan){
                public static final long serialVersionUID = 0L;
                private final Span clientRequestSpan$1;

                public final WSResponse apply(WSResponse response) {
                    this.clientRequestSpan$1.tag("http.status_code", (long)response.status());
                    Object object = package$.MODULE$.isError(response.status()) ? this.clientRequestSpan$1.addError("error") : BoxedUnit.UNIT;
                    Object object2 = response.status() == package$StatusCodes$.MODULE$.NotFound() ? this.clientRequestSpan$1.setOperationName("not-found") : BoxedUnit.UNIT;
                    this.clientRequestSpan$1.finish();
                    return response;
                }
                {
                    this.clientRequestSpan$1 = clientRequestSpan$1;
                }
            }, (Function1)new Serializable(this, clientRequestSpan){
                public static final long serialVersionUID = 0L;
                private final Span clientRequestSpan$1;

                public final Throwable apply(Throwable error) {
                    this.clientRequestSpan$1.addError("error.object", error);
                    this.clientRequestSpan$1.finish();
                    return error;
                }
                {
                    this.clientRequestSpan$1 = clientRequestSpan$1;
                }
            }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
        }
        return object;
    }
}

