/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import java.io.Serializable;
import kamon.instrumentation.system.host.HostMetrics$;
import kamon.instrumentation.system.host.HostMetrics$DiffCounter$;
import kamon.instrumentation.system.host.HostMetrics$NetworkActivityInstruments$InterfaceInstruments$;
import kamon.instrumentation.system.host.HostMetrics$StorageDeviceInstruments$DeviceInstruments$;
import kamon.instrumentation.system.host.HostMetrics$StorageMountInstruments$MountInstruments$;
import kamon.metric.Counter;
import kamon.metric.Gauge;
import kamon.metric.Histogram;
import kamon.metric.InstrumentGroup;
import kamon.metric.Metric;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Product;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HostMetrics {
    public static Metric.Histogram CpuUsage() {
        return HostMetrics$.MODULE$.CpuUsage();
    }

    public static Metric.Gauge FileSystemMountSpaceFree() {
        return HostMetrics$.MODULE$.FileSystemMountSpaceFree();
    }

    public static Metric.Gauge FileSystemMountSpaceTotal() {
        return HostMetrics$.MODULE$.FileSystemMountSpaceTotal();
    }

    public static Metric.Gauge FileSystemMountSpaceUsage() {
        return HostMetrics$.MODULE$.FileSystemMountSpaceUsage();
    }

    public static Metric.Gauge FileSystemMountSpaceUsed() {
        return HostMetrics$.MODULE$.FileSystemMountSpaceUsed();
    }

    public static Metric.Gauge LoadAverage() {
        return HostMetrics$.MODULE$.LoadAverage();
    }

    public static Metric.Gauge MemoryFree() {
        return HostMetrics$.MODULE$.MemoryFree();
    }

    public static Metric.Gauge MemoryTotal() {
        return HostMetrics$.MODULE$.MemoryTotal();
    }

    public static Metric.Gauge MemoryUsage() {
        return HostMetrics$.MODULE$.MemoryUsage();
    }

    public static Metric.Gauge MemoryUsed() {
        return HostMetrics$.MODULE$.MemoryUsed();
    }

    public static Metric.Counter NetworkDataRead() {
        return HostMetrics$.MODULE$.NetworkDataRead();
    }

    public static Metric.Counter NetworkDataWrite() {
        return HostMetrics$.MODULE$.NetworkDataWrite();
    }

    public static Metric.Counter NetworkPacketsRead() {
        return HostMetrics$.MODULE$.NetworkPacketsRead();
    }

    public static Metric.Counter NetworkPacketsReadFailed() {
        return HostMetrics$.MODULE$.NetworkPacketsReadFailed();
    }

    public static Metric.Counter NetworkPacketsWrite() {
        return HostMetrics$.MODULE$.NetworkPacketsWrite();
    }

    public static Metric.Counter NetworkPacketsWriteFailed() {
        return HostMetrics$.MODULE$.NetworkPacketsWriteFailed();
    }

    public static Metric.Counter StorageDeviceRead() {
        return HostMetrics$.MODULE$.StorageDeviceRead();
    }

    public static Metric.Counter StorageDeviceReadOps() {
        return HostMetrics$.MODULE$.StorageDeviceReadOps();
    }

    public static Metric.Counter StorageDeviceWrite() {
        return HostMetrics$.MODULE$.StorageDeviceWrite();
    }

    public static Metric.Counter StorageDeviceWriteOps() {
        return HostMetrics$.MODULE$.StorageDeviceWriteOps();
    }

    public static Metric.Gauge SwapFree() {
        return HostMetrics$.MODULE$.SwapFree();
    }

    public static Metric.Gauge SwapTotal() {
        return HostMetrics$.MODULE$.SwapTotal();
    }

    public static Metric.Gauge SwapUsage() {
        return HostMetrics$.MODULE$.SwapUsage();
    }

    public static Metric.Gauge SwapUsed() {
        return HostMetrics$.MODULE$.SwapUsed();
    }

    public static class CpuInstruments
    extends InstrumentGroup {
        private final Histogram user = (Histogram)this.register((Metric)HostMetrics$.MODULE$.CpuUsage(), "mode", "user");
        private final Histogram system = (Histogram)this.register((Metric)HostMetrics$.MODULE$.CpuUsage(), "mode", "system");
        private final Histogram iowait = (Histogram)this.register((Metric)HostMetrics$.MODULE$.CpuUsage(), "mode", "wait");
        private final Histogram idle = (Histogram)this.register((Metric)HostMetrics$.MODULE$.CpuUsage(), "mode", "idle");
        private final Histogram stolen = (Histogram)this.register((Metric)HostMetrics$.MODULE$.CpuUsage(), "mode", "stolen");
        private final Histogram combined = (Histogram)this.register((Metric)HostMetrics$.MODULE$.CpuUsage(), "mode", "combined");

        public CpuInstruments(TagSet tags) {
            super(tags);
        }

        public Histogram user() {
            return this.user;
        }

        public Histogram system() {
            return this.system;
        }

        public Histogram iowait() {
            return this.iowait;
        }

        public Histogram idle() {
            return this.idle;
        }

        public Histogram stolen() {
            return this.stolen;
        }

        public Histogram combined() {
            return this.combined;
        }
    }

    public static class DiffCounter
    implements Product,
    Serializable {
        private final Counter counter;
        private long _previous;

        public static DiffCounter apply(Counter counter) {
            return HostMetrics$DiffCounter$.MODULE$.apply(counter);
        }

        public static DiffCounter fromProduct(Product product) {
            return HostMetrics$DiffCounter$.MODULE$.fromProduct(product);
        }

        public static DiffCounter unapply(DiffCounter diffCounter) {
            return HostMetrics$DiffCounter$.MODULE$.unapply(diffCounter);
        }

        public DiffCounter(Counter counter) {
            this.counter = counter;
            this._previous = 0L;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DiffCounter)) return false;
            DiffCounter diffCounter = (DiffCounter)object;
            Counter counter = this.counter();
            Counter counter2 = diffCounter.counter();
            if (counter == null) {
                if (counter2 != null) {
                    return false;
                }
            } else if (!counter.equals(counter2)) return false;
            if (!diffCounter.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DiffCounter;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DiffCounter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "counter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Counter counter() {
            return this.counter;
        }

        public void diff(long current) {
            long delta;
            if (this._previous > 0L && (delta = current - this._previous) > 0L) {
                this.counter().increment(delta);
            }
            this._previous = current;
        }

        public DiffCounter copy(Counter counter) {
            return new DiffCounter(counter);
        }

        public Counter copy$default$1() {
            return this.counter();
        }

        public Counter _1() {
            return this.counter();
        }
    }

    public static class LoadAverageInstruments
    extends InstrumentGroup {
        private final Gauge oneMinute = (Gauge)this.register((Metric)HostMetrics$.MODULE$.LoadAverage(), "period", "1m");
        private final Gauge fiveMinutes = (Gauge)this.register((Metric)HostMetrics$.MODULE$.LoadAverage(), "period", "5m");
        private final Gauge fifteenMinutes = (Gauge)this.register((Metric)HostMetrics$.MODULE$.LoadAverage(), "period", "15m");

        public LoadAverageInstruments(TagSet tags) {
            super(tags);
        }

        public Gauge oneMinute() {
            return this.oneMinute;
        }

        public Gauge fiveMinutes() {
            return this.fiveMinutes;
        }

        public Gauge fifteenMinutes() {
            return this.fifteenMinutes;
        }
    }

    public static class MemoryInstruments
    extends InstrumentGroup {
        private final Gauge used = (Gauge)this.register((Metric)HostMetrics$.MODULE$.MemoryUsed());
        private final Gauge free = (Gauge)this.register((Metric)HostMetrics$.MODULE$.MemoryFree());
        private final Gauge usage = (Gauge)this.register((Metric)HostMetrics$.MODULE$.MemoryUsage());
        private final Gauge total = (Gauge)this.register((Metric)HostMetrics$.MODULE$.MemoryTotal());

        public MemoryInstruments(TagSet tags) {
            super(tags);
        }

        public Gauge used() {
            return this.used;
        }

        public Gauge free() {
            return this.free;
        }

        public Gauge usage() {
            return this.usage;
        }

        public Gauge total() {
            return this.total;
        }
    }

    public static class NetworkActivityInstruments
    extends InstrumentGroup {
        private final Map<String, InterfaceInstruments> _interfaceCache = (Map)Map$.MODULE$.empty();

        public NetworkActivityInstruments(TagSet tags) {
            super(tags);
        }

        public InterfaceInstruments interfaceInstruments(String interfaceName) {
            return (InterfaceInstruments)this._interfaceCache.getOrElseUpdate((Object)interfaceName, () -> this.interfaceInstruments$$anonfun$1(interfaceName));
        }

        private final InterfaceInstruments interfaceInstruments$$anonfun$1(String interfaceName$1) {
            TagSet tagSet = TagSet$.MODULE$.of("interface", interfaceName$1);
            return HostMetrics$NetworkActivityInstruments$InterfaceInstruments$.MODULE$.apply(HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.NetworkDataRead(), tagSet)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.NetworkPacketsRead(), tagSet)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.NetworkPacketsReadFailed(), tagSet)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.NetworkDataWrite(), tagSet)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.NetworkPacketsWrite(), tagSet)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.NetworkPacketsWriteFailed(), tagSet)));
        }

        public static class InterfaceInstruments
        implements Product,
        Serializable {
            private final DiffCounter receivedBytes;
            private final DiffCounter receivedPackets;
            private final DiffCounter receiveErrorPackets;
            private final DiffCounter sentBytes;
            private final DiffCounter sentPackets;
            private final DiffCounter sendErrorPackets;

            public static InterfaceInstruments apply(DiffCounter diffCounter, DiffCounter diffCounter2, DiffCounter diffCounter3, DiffCounter diffCounter4, DiffCounter diffCounter5, DiffCounter diffCounter6) {
                return HostMetrics$NetworkActivityInstruments$InterfaceInstruments$.MODULE$.apply(diffCounter, diffCounter2, diffCounter3, diffCounter4, diffCounter5, diffCounter6);
            }

            public static InterfaceInstruments fromProduct(Product product) {
                return HostMetrics$NetworkActivityInstruments$InterfaceInstruments$.MODULE$.fromProduct(product);
            }

            public static InterfaceInstruments unapply(InterfaceInstruments interfaceInstruments) {
                return HostMetrics$NetworkActivityInstruments$InterfaceInstruments$.MODULE$.unapply(interfaceInstruments);
            }

            public InterfaceInstruments(DiffCounter receivedBytes, DiffCounter receivedPackets, DiffCounter receiveErrorPackets, DiffCounter sentBytes, DiffCounter sentPackets, DiffCounter sendErrorPackets) {
                this.receivedBytes = receivedBytes;
                this.receivedPackets = receivedPackets;
                this.receiveErrorPackets = receiveErrorPackets;
                this.sentBytes = sentBytes;
                this.sentPackets = sentPackets;
                this.sendErrorPackets = sendErrorPackets;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof InterfaceInstruments)) return false;
                InterfaceInstruments interfaceInstruments = (InterfaceInstruments)object;
                DiffCounter diffCounter = this.receivedBytes();
                DiffCounter diffCounter2 = interfaceInstruments.receivedBytes();
                if (diffCounter == null) {
                    if (diffCounter2 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter).equals(diffCounter2)) return false;
                DiffCounter diffCounter3 = this.receivedPackets();
                DiffCounter diffCounter4 = interfaceInstruments.receivedPackets();
                if (diffCounter3 == null) {
                    if (diffCounter4 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter3).equals(diffCounter4)) return false;
                DiffCounter diffCounter5 = this.receiveErrorPackets();
                DiffCounter diffCounter6 = interfaceInstruments.receiveErrorPackets();
                if (diffCounter5 == null) {
                    if (diffCounter6 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter5).equals(diffCounter6)) return false;
                DiffCounter diffCounter7 = this.sentBytes();
                DiffCounter diffCounter8 = interfaceInstruments.sentBytes();
                if (diffCounter7 == null) {
                    if (diffCounter8 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter7).equals(diffCounter8)) return false;
                DiffCounter diffCounter9 = this.sentPackets();
                DiffCounter diffCounter10 = interfaceInstruments.sentPackets();
                if (diffCounter9 == null) {
                    if (diffCounter10 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter9).equals(diffCounter10)) return false;
                DiffCounter diffCounter11 = this.sendErrorPackets();
                DiffCounter diffCounter12 = interfaceInstruments.sendErrorPackets();
                if (diffCounter11 == null) {
                    if (diffCounter12 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter11).equals(diffCounter12)) return false;
                if (!interfaceInstruments.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof InterfaceInstruments;
            }

            public int productArity() {
                return 6;
            }

            public String productPrefix() {
                return "InterfaceInstruments";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return this._4();
                    }
                    case 4: {
                        return this._5();
                    }
                    case 5: {
                        return this._6();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "receivedBytes";
                    }
                    case 1: {
                        return "receivedPackets";
                    }
                    case 2: {
                        return "receiveErrorPackets";
                    }
                    case 3: {
                        return "sentBytes";
                    }
                    case 4: {
                        return "sentPackets";
                    }
                    case 5: {
                        return "sendErrorPackets";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public DiffCounter receivedBytes() {
                return this.receivedBytes;
            }

            public DiffCounter receivedPackets() {
                return this.receivedPackets;
            }

            public DiffCounter receiveErrorPackets() {
                return this.receiveErrorPackets;
            }

            public DiffCounter sentBytes() {
                return this.sentBytes;
            }

            public DiffCounter sentPackets() {
                return this.sentPackets;
            }

            public DiffCounter sendErrorPackets() {
                return this.sendErrorPackets;
            }

            public InterfaceInstruments copy(DiffCounter receivedBytes, DiffCounter receivedPackets, DiffCounter receiveErrorPackets, DiffCounter sentBytes, DiffCounter sentPackets, DiffCounter sendErrorPackets) {
                return new InterfaceInstruments(receivedBytes, receivedPackets, receiveErrorPackets, sentBytes, sentPackets, sendErrorPackets);
            }

            public DiffCounter copy$default$1() {
                return this.receivedBytes();
            }

            public DiffCounter copy$default$2() {
                return this.receivedPackets();
            }

            public DiffCounter copy$default$3() {
                return this.receiveErrorPackets();
            }

            public DiffCounter copy$default$4() {
                return this.sentBytes();
            }

            public DiffCounter copy$default$5() {
                return this.sentPackets();
            }

            public DiffCounter copy$default$6() {
                return this.sendErrorPackets();
            }

            public DiffCounter _1() {
                return this.receivedBytes();
            }

            public DiffCounter _2() {
                return this.receivedPackets();
            }

            public DiffCounter _3() {
                return this.receiveErrorPackets();
            }

            public DiffCounter _4() {
                return this.sentBytes();
            }

            public DiffCounter _5() {
                return this.sentPackets();
            }

            public DiffCounter _6() {
                return this.sendErrorPackets();
            }
        }
    }

    public static class StorageDeviceInstruments
    extends InstrumentGroup {
        private final Map<String, DeviceInstruments> _deviceInstrumentsCache = (Map)Map$.MODULE$.empty();

        public StorageDeviceInstruments(TagSet tags) {
            super(tags);
        }

        public DeviceInstruments deviceInstruments(String deviceName) {
            return (DeviceInstruments)this._deviceInstrumentsCache.getOrElseUpdate((Object)deviceName, () -> this.deviceInstruments$$anonfun$1(deviceName));
        }

        private final DeviceInstruments deviceInstruments$$anonfun$1(String deviceName$1) {
            TagSet device = TagSet$.MODULE$.of("device", deviceName$1);
            return HostMetrics$StorageDeviceInstruments$DeviceInstruments$.MODULE$.apply(HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.StorageDeviceReadOps(), device)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.StorageDeviceRead(), device)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.StorageDeviceWriteOps(), device)), HostMetrics$DiffCounter$.MODULE$.apply((Counter)this.register((Metric)HostMetrics$.MODULE$.StorageDeviceWrite(), device)));
        }

        public static class DeviceInstruments
        implements Product,
        Serializable {
            private final DiffCounter reads;
            private final DiffCounter readBytes;
            private final DiffCounter writes;
            private final DiffCounter writeBytes;

            public static DeviceInstruments apply(DiffCounter diffCounter, DiffCounter diffCounter2, DiffCounter diffCounter3, DiffCounter diffCounter4) {
                return HostMetrics$StorageDeviceInstruments$DeviceInstruments$.MODULE$.apply(diffCounter, diffCounter2, diffCounter3, diffCounter4);
            }

            public static DeviceInstruments fromProduct(Product product) {
                return HostMetrics$StorageDeviceInstruments$DeviceInstruments$.MODULE$.fromProduct(product);
            }

            public static DeviceInstruments unapply(DeviceInstruments deviceInstruments) {
                return HostMetrics$StorageDeviceInstruments$DeviceInstruments$.MODULE$.unapply(deviceInstruments);
            }

            public DeviceInstruments(DiffCounter reads, DiffCounter readBytes, DiffCounter writes, DiffCounter writeBytes) {
                this.reads = reads;
                this.readBytes = readBytes;
                this.writes = writes;
                this.writeBytes = writeBytes;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof DeviceInstruments)) return false;
                DeviceInstruments deviceInstruments = (DeviceInstruments)object;
                DiffCounter diffCounter = this.reads();
                DiffCounter diffCounter2 = deviceInstruments.reads();
                if (diffCounter == null) {
                    if (diffCounter2 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter).equals(diffCounter2)) return false;
                DiffCounter diffCounter3 = this.readBytes();
                DiffCounter diffCounter4 = deviceInstruments.readBytes();
                if (diffCounter3 == null) {
                    if (diffCounter4 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter3).equals(diffCounter4)) return false;
                DiffCounter diffCounter5 = this.writes();
                DiffCounter diffCounter6 = deviceInstruments.writes();
                if (diffCounter5 == null) {
                    if (diffCounter6 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter5).equals(diffCounter6)) return false;
                DiffCounter diffCounter7 = this.writeBytes();
                DiffCounter diffCounter8 = deviceInstruments.writeBytes();
                if (diffCounter7 == null) {
                    if (diffCounter8 != null) {
                        return false;
                    }
                } else if (!((Object)diffCounter7).equals(diffCounter8)) return false;
                if (!deviceInstruments.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof DeviceInstruments;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "DeviceInstruments";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return this._4();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "reads";
                    }
                    case 1: {
                        return "readBytes";
                    }
                    case 2: {
                        return "writes";
                    }
                    case 3: {
                        return "writeBytes";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public DiffCounter reads() {
                return this.reads;
            }

            public DiffCounter readBytes() {
                return this.readBytes;
            }

            public DiffCounter writes() {
                return this.writes;
            }

            public DiffCounter writeBytes() {
                return this.writeBytes;
            }

            public DeviceInstruments copy(DiffCounter reads, DiffCounter readBytes, DiffCounter writes, DiffCounter writeBytes) {
                return new DeviceInstruments(reads, readBytes, writes, writeBytes);
            }

            public DiffCounter copy$default$1() {
                return this.reads();
            }

            public DiffCounter copy$default$2() {
                return this.readBytes();
            }

            public DiffCounter copy$default$3() {
                return this.writes();
            }

            public DiffCounter copy$default$4() {
                return this.writeBytes();
            }

            public DiffCounter _1() {
                return this.reads();
            }

            public DiffCounter _2() {
                return this.readBytes();
            }

            public DiffCounter _3() {
                return this.writes();
            }

            public DiffCounter _4() {
                return this.writeBytes();
            }
        }
    }

    public static class StorageMountInstruments
    extends InstrumentGroup {
        private final Map<String, MountInstruments> _mountsCache = (Map)Map$.MODULE$.empty();

        public StorageMountInstruments(TagSet tags) {
            super(tags);
        }

        public MountInstruments mountInstruments(String mountName) {
            return (MountInstruments)this._mountsCache.getOrElseUpdate((Object)mountName, () -> this.mountInstruments$$anonfun$1(mountName));
        }

        private final MountInstruments mountInstruments$$anonfun$1(String mountName$1) {
            TagSet mount = TagSet$.MODULE$.of("mount", mountName$1);
            return HostMetrics$StorageMountInstruments$MountInstruments$.MODULE$.apply((Gauge)this.register((Metric)HostMetrics$.MODULE$.FileSystemMountSpaceUsed(), mount), (Gauge)this.register((Metric)HostMetrics$.MODULE$.FileSystemMountSpaceUsage(), mount), (Gauge)this.register((Metric)HostMetrics$.MODULE$.FileSystemMountSpaceFree(), mount), (Gauge)this.register((Metric)HostMetrics$.MODULE$.FileSystemMountSpaceTotal(), mount));
        }

        public static class MountInstruments
        implements Product,
        Serializable {
            private final Gauge used;
            private final Gauge usage;
            private final Gauge free;
            private final Gauge total;

            public static MountInstruments apply(Gauge gauge, Gauge gauge2, Gauge gauge3, Gauge gauge4) {
                return HostMetrics$StorageMountInstruments$MountInstruments$.MODULE$.apply(gauge, gauge2, gauge3, gauge4);
            }

            public static MountInstruments fromProduct(Product product) {
                return HostMetrics$StorageMountInstruments$MountInstruments$.MODULE$.fromProduct(product);
            }

            public static MountInstruments unapply(MountInstruments mountInstruments) {
                return HostMetrics$StorageMountInstruments$MountInstruments$.MODULE$.unapply(mountInstruments);
            }

            public MountInstruments(Gauge used, Gauge usage, Gauge free, Gauge total) {
                this.used = used;
                this.usage = usage;
                this.free = free;
                this.total = total;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof MountInstruments)) return false;
                MountInstruments mountInstruments = (MountInstruments)object;
                Gauge gauge = this.used();
                Gauge gauge2 = mountInstruments.used();
                if (gauge == null) {
                    if (gauge2 != null) {
                        return false;
                    }
                } else if (!gauge.equals(gauge2)) return false;
                Gauge gauge3 = this.usage();
                Gauge gauge4 = mountInstruments.usage();
                if (gauge3 == null) {
                    if (gauge4 != null) {
                        return false;
                    }
                } else if (!gauge3.equals(gauge4)) return false;
                Gauge gauge5 = this.free();
                Gauge gauge6 = mountInstruments.free();
                if (gauge5 == null) {
                    if (gauge6 != null) {
                        return false;
                    }
                } else if (!gauge5.equals(gauge6)) return false;
                Gauge gauge7 = this.total();
                Gauge gauge8 = mountInstruments.total();
                if (gauge7 == null) {
                    if (gauge8 != null) {
                        return false;
                    }
                } else if (!gauge7.equals(gauge8)) return false;
                if (!mountInstruments.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof MountInstruments;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "MountInstruments";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return this._4();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "used";
                    }
                    case 1: {
                        return "usage";
                    }
                    case 2: {
                        return "free";
                    }
                    case 3: {
                        return "total";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Gauge used() {
                return this.used;
            }

            public Gauge usage() {
                return this.usage;
            }

            public Gauge free() {
                return this.free;
            }

            public Gauge total() {
                return this.total;
            }

            public MountInstruments copy(Gauge used, Gauge usage, Gauge free, Gauge total) {
                return new MountInstruments(used, usage, free, total);
            }

            public Gauge copy$default$1() {
                return this.used();
            }

            public Gauge copy$default$2() {
                return this.usage();
            }

            public Gauge copy$default$3() {
                return this.free();
            }

            public Gauge copy$default$4() {
                return this.total();
            }

            public Gauge _1() {
                return this.used();
            }

            public Gauge _2() {
                return this.usage();
            }

            public Gauge _3() {
                return this.free();
            }

            public Gauge _4() {
                return this.total();
            }
        }
    }

    public static class SwapInstruments
    extends InstrumentGroup {
        private final Gauge used = (Gauge)this.register((Metric)HostMetrics$.MODULE$.SwapUsed());
        private final Gauge usage = (Gauge)this.register((Metric)HostMetrics$.MODULE$.SwapUsage());
        private final Gauge free = (Gauge)this.register((Metric)HostMetrics$.MODULE$.SwapFree());
        private final Gauge total = (Gauge)this.register((Metric)HostMetrics$.MODULE$.SwapTotal());

        public SwapInstruments(TagSet tags) {
            super(tags);
        }

        public Gauge used() {
            return this.used;
        }

        public Gauge usage() {
            return this.usage;
        }

        public Gauge free() {
            return this.free;
        }

        public Gauge total() {
            return this.total;
        }
    }
}

