/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.instrumentation.system.host.HostMetricsCollector$Settings$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import scala.Function1;
import scala.Long$;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class HostMetricsCollector
implements ScheduledAction {
    private final String _configPath;
    private Instant _lastInfrequentTick = Instant.now();
    public volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
    private final FrequentCollectionTask _frequentCollector = new FrequentCollectionTask();
    private final InfrequentCollectionTask _infrequentCollector = new InfrequentCollectionTask();

    public HostMetricsCollector(ExecutionContext ec) {
        this._configPath = "kamon.instrumentation.system.host";
    }

    public void run() {
        this._frequentCollector.run();
        if (Duration.between(this._lastInfrequentTick, Instant.now()).getSeconds() >= 10L) {
            this._infrequentCollector.run();
            this._lastInfrequentTick = Instant.now();
            return;
        }
    }

    public void stop() {
        this._frequentCollector.cleanup();
        this._infrequentCollector.cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(newConfig);
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath);
        return HostMetricsCollector$Settings$.MODULE$.apply(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    public static final long kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(long total$1, long value) {
        return (long)(100.0 * (double)value / (double)total$1);
    }

    public interface CollectionTask {
        public void run();

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        public FrequentCollectionTask() {
            TagSet _defaultTags = TagSet$.MODULE$.of("component", "host");
            SystemInfo _systemInfo = new SystemInfo();
            this._hal = _systemInfo.getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(_defaultTags);
            this._prevCpuLoadTicks = new long[0];
        }

        @Override
        public void run() {
            this.recordCpuUsage();
        }

        @Override
        public void cleanup() {
            this._cpuInstruments.remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks.length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks;
                long[] currentTicks = this._hal.getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments.user().record(HostMetricsCollector.kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(total, user));
                this._cpuInstruments.system().record(HostMetricsCollector.kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(total, system));
                this._cpuInstruments.iowait().record(HostMetricsCollector.kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(total, iowait));
                this._cpuInstruments.idle().record(HostMetricsCollector.kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(total, idle));
                this._cpuInstruments.stolen().record(HostMetricsCollector.kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(total, steal));
                this._cpuInstruments.combined().record(HostMetricsCollector.kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$_$toPercent$1(total, user + system + nice + iowait));
                this._prevCpuLoadTicks = currentTicks;
                return;
            }
            this._prevCpuLoadTicks = this._hal.getProcessor().getSystemCpuLoadTicks();
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw new NullPointerException();
            }
            TagSet _defaultTags = TagSet$.MODULE$.of("component", "host");
            SystemInfo _systemInfo = new SystemInfo();
            this._hal = _systemInfo.getHardware();
            this._os = _systemInfo.getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(_defaultTags);
            this._swapInstruments = new HostMetrics.SwapInstruments(_defaultTags);
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(_defaultTags);
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(_defaultTags);
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(_defaultTags);
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(_defaultTags);
        }

        @Override
        public void run() {
            this.recordMemoryUsage();
            this.recordLoadAverage();
            this.recordStorageUsage();
            this.recordStorageActivity();
            this.recordNetworkActivity();
        }

        @Override
        public void cleanup() {
            this._memoryInstruments.remove();
            this._swapInstruments.remove();
            this._loadAverageInstruments.remove();
            this._fileSystemUsageInstruments.remove();
            this._fileSystemActivityInstruments.remove();
            this._networkActivityInstruments.remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal.getMemory();
            long totalMemory = memory.getTotal();
            long availableMemory = memory.getAvailable();
            long usedMemory = totalMemory - availableMemory;
            this._memoryInstruments.total().update(Long$.MODULE$.long2double(totalMemory));
            this._memoryInstruments.free().update(Long$.MODULE$.long2double(availableMemory));
            this._memoryInstruments.used().update(Long$.MODULE$.long2double(usedMemory));
            this._memoryInstruments.usage().update(Long$.MODULE$.long2double(this.toPercent(usedMemory, totalMemory)));
            long usedSwap = memory.getVirtualMemory().getSwapUsed();
            long totalSwap = memory.getVirtualMemory().getSwapTotal();
            this._swapInstruments.total().update(Long$.MODULE$.long2double(totalSwap));
            this._swapInstruments.used().update(Long$.MODULE$.long2double(usedSwap));
            this._swapInstruments.usage().update(Long$.MODULE$.long2double(this.toPercent(usedSwap, totalSwap)));
            this._swapInstruments.free().update(Long$.MODULE$.long2double(totalSwap - usedSwap));
        }

        private void recordLoadAverage() {
            double[] loadAverage = this._hal.getProcessor().getSystemLoadAverage(3);
            if (loadAverage[0] >= 0.0) {
                this._loadAverageInstruments.oneMinute().update(loadAverage[0]);
            }
            if (loadAverage[1] >= 0.0) {
                this._loadAverageInstruments.fiveMinutes().update(loadAverage[1]);
            }
            if (loadAverage[2] >= 0.0) {
                this._loadAverageInstruments.fifteenMinutes().update(loadAverage[2]);
                return;
            }
        }

        private void recordStorageUsage() {
            List fileStores = this._os.getFileSystem().getFileStores();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileStores).asScala()).foreach((Function1)(JProcedure1 & Serializable)fs -> {
                if (HostMetricsCollector.this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings.trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments.mountInstruments(fs.getMount());
                    long totalSpace = fs.getTotalSpace();
                    long usedSpace = totalSpace - fs.getUsableSpace();
                    mountInstruments.free().update(Long$.MODULE$.long2double(fs.getUsableSpace()));
                    mountInstruments.total().update(Long$.MODULE$.long2double(totalSpace));
                    mountInstruments.used().update(Long$.MODULE$.long2double(usedSpace));
                    mountInstruments.usage().update(Long$.MODULE$.long2double(this.toPercent(usedSpace, totalSpace)));
                    return;
                }
            });
        }

        private long toPercent(long value, long total) {
            return (long)(100.0 * (double)value / (double)total);
        }

        private void recordStorageActivity() {
            List devices = this._hal.getDiskStores();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(devices).asScala()).foreach((Function1)(JProcedure1 & Serializable)device -> {
                if (!device.getPartitions().isEmpty()) {
                    HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = this._fileSystemActivityInstruments.deviceInstruments(device.getName());
                    deviceInstruments.reads().diff(device.getReads());
                    deviceInstruments.writes().diff(device.getWrites());
                    deviceInstruments.readBytes().diff(device.getReadBytes());
                    deviceInstruments.writeBytes().diff(device.getWriteBytes());
                    return;
                }
            });
        }

        private void recordNetworkActivity() {
            List interfaces = this._hal.getNetworkIFs();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(interfaces).asScala()).foreach((Function1)(JProcedure1 & Serializable)networkIF -> {
                if (HostMetricsCollector.this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings.trackedInterfaces().accept(networkIF.getName())) {
                    networkIF.updateAttributes();
                    HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = this._networkActivityInstruments.interfaceInstruments(networkIF.getName());
                    interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                    interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                    interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                    interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                    interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                    interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
                    return;
                }
            });
        }

        public final /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }
    }

    public static class Settings
    implements Product,
    Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public static Settings apply(Filter filter, Filter filter2) {
            return HostMetricsCollector$Settings$.MODULE$.apply(filter, filter2);
        }

        public static Settings fromProduct(Product product) {
            return HostMetricsCollector$Settings$.MODULE$.fromProduct(product);
        }

        public static Settings unapply(Settings settings) {
            return HostMetricsCollector$Settings$.MODULE$.unapply(settings);
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Settings)) return false;
            Settings settings = (Settings)object;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Settings;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Settings";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "trackedInterfaces";
            }
            if (1 == n2) {
                return "trackedMounts";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public Filter _1() {
            return this.trackedInterfaces();
        }

        public Filter _2() {
            return this.trackedMounts();
        }
    }
}

