/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.jvm;

import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.system.jvm.JvmMetrics$MemoryUsageInstruments$;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import scala.runtime.ModuleSerializationProxy;

public final class JvmMetrics$
implements Serializable {
    private static final Metric.Histogram GC;
    private static final Metric.Histogram GcPromotion;
    private static final Metric.Histogram MemoryUsed;
    private static final Metric.Histogram MemoryUtilization;
    private static final Metric.Histogram MemoryFree;
    private static final Metric.Gauge MemoryCommitted;
    private static final Metric.Gauge MemoryMax;
    private static final Metric.Histogram MemoryPoolUsed;
    private static final Metric.Histogram MemoryPoolFree;
    private static final Metric.Gauge MemoryPoolCommitted;
    private static final Metric.Gauge MemoryPoolMax;
    private static final Metric.Counter MemoryAllocation;
    private static final Metric.Gauge ThreadsTotal;
    private static final Metric.Gauge ThreadsPeak;
    private static final Metric.Gauge ThreadsDaemon;
    private static final Metric.Gauge ThreadsStates;
    private static final Metric.Gauge ClassesLoaded;
    private static final Metric.Gauge ClassesUnloaded;
    private static final Metric.Gauge ClassesCurrentlyLoaded;
    private static final Metric.Gauge BufferPoolCount;
    private static final Metric.Gauge BufferPoolUsed;
    private static final Metric.Gauge BufferPoolCapacity;
    public static final JvmMetrics$MemoryUsageInstruments$ MemoryUsageInstruments;
    public static final JvmMetrics$ MODULE$;

    private JvmMetrics$() {
    }

    static {
        MODULE$ = new JvmMetrics$();
        GC = Kamon$.MODULE$.histogram("jvm.gc", "Tracks the distribution of GC events duration", MeasurementUnit$.MODULE$.time().milliseconds());
        GcPromotion = Kamon$.MODULE$.histogram("jvm.gc.promotion", "Tracks the distribution of promoted bytes to the old generation regions after a GC", MeasurementUnit$.MODULE$.information().bytes());
        MemoryUsed = Kamon$.MODULE$.histogram("jvm.memory.used", "Samples the used space in a memory region", MeasurementUnit$.MODULE$.information().bytes());
        MemoryUtilization = Kamon$.MODULE$.histogram("jvm.memory.utilization", "Tracks the percentage of heap used across old/tenured/single memory regions after GC events", MeasurementUnit$.MODULE$.percentage());
        MemoryFree = Kamon$.MODULE$.histogram("jvm.memory.free", "Samples the free space in a memory region", MeasurementUnit$.MODULE$.information().bytes());
        MemoryCommitted = Kamon$.MODULE$.gauge("jvm.memory.committed", "Tracks the committed space in a memory region", MeasurementUnit$.MODULE$.information().bytes());
        MemoryMax = Kamon$.MODULE$.gauge("jvm.memory.max", "Tracks the max space in a memory region", MeasurementUnit$.MODULE$.information().bytes());
        MemoryPoolUsed = Kamon$.MODULE$.histogram("jvm.memory.pool.used", "Samples the used space in a memory pool", MeasurementUnit$.MODULE$.information().bytes());
        MemoryPoolFree = Kamon$.MODULE$.histogram("jvm.memory.pool.free", "Samples the free space in a memory pool", MeasurementUnit$.MODULE$.information().bytes());
        MemoryPoolCommitted = Kamon$.MODULE$.gauge("jvm.memory.pool.committed", "Tracks the committed space in a memory pool", MeasurementUnit$.MODULE$.information().bytes());
        MemoryPoolMax = Kamon$.MODULE$.gauge("jvm.memory.pool.max", "Tracks the max space in a memory pool", MeasurementUnit$.MODULE$.information().bytes());
        MemoryAllocation = Kamon$.MODULE$.counter("jvm.memory.allocation", "Tracks the number amount of bytes allocated", MeasurementUnit$.MODULE$.information().bytes());
        ThreadsTotal = Kamon$.MODULE$.gauge("jvm.threads.total", "Tracks the current number of live threads on the JVM");
        ThreadsPeak = Kamon$.MODULE$.gauge("jvm.threads.peak", "Tracks the peak live thread count since the JVM started");
        ThreadsDaemon = Kamon$.MODULE$.gauge("jvm.threads.daemon", "Tracks the current number of daemon threads on the JVM");
        ThreadsStates = Kamon$.MODULE$.gauge("jvm.threads.states", "Tracks the current number of threads on each possible state");
        ClassesLoaded = Kamon$.MODULE$.gauge("jvm.class-loading.loaded", "Total number of classes loaded");
        ClassesUnloaded = Kamon$.MODULE$.gauge("jvm.class-loading.unloaded", "Total number of classes unloaded");
        ClassesCurrentlyLoaded = Kamon$.MODULE$.gauge("jvm.class-loading.currently-loaded", "Total number of classes currently loaded");
        BufferPoolCount = Kamon$.MODULE$.gauge("jvm.memory.buffer-pool.count", "Estimated number of buffers in the pool");
        BufferPoolUsed = Kamon$.MODULE$.gauge("jvm.memory.buffer-pool.used", "Estimate of memory used by the JVM for this buffer pool in bytes", MeasurementUnit$.MODULE$.information().bytes());
        BufferPoolCapacity = Kamon$.MODULE$.gauge("jvm.memory.buffer-pool.capacity", "Estimate of the total capacity of this pool in bytes", MeasurementUnit$.MODULE$.information().bytes());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JvmMetrics$.class);
    }

    public Metric.Histogram GC() {
        return GC;
    }

    public Metric.Histogram GcPromotion() {
        return GcPromotion;
    }

    public Metric.Histogram MemoryUsed() {
        return MemoryUsed;
    }

    public Metric.Histogram MemoryUtilization() {
        return MemoryUtilization;
    }

    public Metric.Histogram MemoryFree() {
        return MemoryFree;
    }

    public Metric.Gauge MemoryCommitted() {
        return MemoryCommitted;
    }

    public Metric.Gauge MemoryMax() {
        return MemoryMax;
    }

    public Metric.Histogram MemoryPoolUsed() {
        return MemoryPoolUsed;
    }

    public Metric.Histogram MemoryPoolFree() {
        return MemoryPoolFree;
    }

    public Metric.Gauge MemoryPoolCommitted() {
        return MemoryPoolCommitted;
    }

    public Metric.Gauge MemoryPoolMax() {
        return MemoryPoolMax;
    }

    public Metric.Counter MemoryAllocation() {
        return MemoryAllocation;
    }

    public Metric.Gauge ThreadsTotal() {
        return ThreadsTotal;
    }

    public Metric.Gauge ThreadsPeak() {
        return ThreadsPeak;
    }

    public Metric.Gauge ThreadsDaemon() {
        return ThreadsDaemon;
    }

    public Metric.Gauge ThreadsStates() {
        return ThreadsStates;
    }

    public Metric.Gauge ClassesLoaded() {
        return ClassesLoaded;
    }

    public Metric.Gauge ClassesUnloaded() {
        return ClassesUnloaded;
    }

    public Metric.Gauge ClassesCurrentlyLoaded() {
        return ClassesCurrentlyLoaded;
    }

    public Metric.Gauge BufferPoolCount() {
        return BufferPoolCount;
    }

    public Metric.Gauge BufferPoolUsed() {
        return BufferPoolUsed;
    }

    public Metric.Gauge BufferPoolCapacity() {
        return BufferPoolCapacity;
    }
}

