/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.jvm;

import java.io.Serializable;
import kamon.instrumentation.system.jvm.JvmMetrics$;
import kamon.instrumentation.system.jvm.JvmMetrics$MemoryUsageInstruments$BufferPoolInstruments$;
import kamon.instrumentation.system.jvm.JvmMetrics$MemoryUsageInstruments$MemoryRegionInstruments$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector;
import kamon.metric.Counter;
import kamon.metric.Gauge;
import kamon.metric.Histogram;
import kamon.metric.InstrumentGroup;
import kamon.metric.Metric;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Product;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class JvmMetrics {
    public static Metric.Gauge BufferPoolCapacity() {
        return JvmMetrics$.MODULE$.BufferPoolCapacity();
    }

    public static Metric.Gauge BufferPoolCount() {
        return JvmMetrics$.MODULE$.BufferPoolCount();
    }

    public static Metric.Gauge BufferPoolUsed() {
        return JvmMetrics$.MODULE$.BufferPoolUsed();
    }

    public static Metric.Gauge ClassesCurrentlyLoaded() {
        return JvmMetrics$.MODULE$.ClassesCurrentlyLoaded();
    }

    public static Metric.Gauge ClassesLoaded() {
        return JvmMetrics$.MODULE$.ClassesLoaded();
    }

    public static Metric.Gauge ClassesUnloaded() {
        return JvmMetrics$.MODULE$.ClassesUnloaded();
    }

    public static Metric.Histogram GC() {
        return JvmMetrics$.MODULE$.GC();
    }

    public static Metric.Histogram GcPromotion() {
        return JvmMetrics$.MODULE$.GcPromotion();
    }

    public static Metric.Counter MemoryAllocation() {
        return JvmMetrics$.MODULE$.MemoryAllocation();
    }

    public static Metric.Gauge MemoryCommitted() {
        return JvmMetrics$.MODULE$.MemoryCommitted();
    }

    public static Metric.Histogram MemoryFree() {
        return JvmMetrics$.MODULE$.MemoryFree();
    }

    public static Metric.Gauge MemoryMax() {
        return JvmMetrics$.MODULE$.MemoryMax();
    }

    public static Metric.Gauge MemoryPoolCommitted() {
        return JvmMetrics$.MODULE$.MemoryPoolCommitted();
    }

    public static Metric.Histogram MemoryPoolFree() {
        return JvmMetrics$.MODULE$.MemoryPoolFree();
    }

    public static Metric.Gauge MemoryPoolMax() {
        return JvmMetrics$.MODULE$.MemoryPoolMax();
    }

    public static Metric.Histogram MemoryPoolUsed() {
        return JvmMetrics$.MODULE$.MemoryPoolUsed();
    }

    public static Metric.Histogram MemoryUsed() {
        return JvmMetrics$.MODULE$.MemoryUsed();
    }

    public static Metric.Histogram MemoryUtilization() {
        return JvmMetrics$.MODULE$.MemoryUtilization();
    }

    public static Metric.Gauge ThreadsDaemon() {
        return JvmMetrics$.MODULE$.ThreadsDaemon();
    }

    public static Metric.Gauge ThreadsPeak() {
        return JvmMetrics$.MODULE$.ThreadsPeak();
    }

    public static Metric.Gauge ThreadsStates() {
        return JvmMetrics$.MODULE$.ThreadsStates();
    }

    public static Metric.Gauge ThreadsTotal() {
        return JvmMetrics$.MODULE$.ThreadsTotal();
    }

    public static class ClassLoadingInstruments
    extends InstrumentGroup {
        private final Gauge loaded = (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ClassesLoaded());
        private final Gauge unloaded = (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ClassesUnloaded());
        private final Gauge currentlyLoaded = (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ClassesCurrentlyLoaded());

        public ClassLoadingInstruments(TagSet tags) {
            super(tags);
        }

        public Gauge loaded() {
            return this.loaded;
        }

        public Gauge unloaded() {
            return this.unloaded;
        }

        public Gauge currentlyLoaded() {
            return this.currentlyLoaded;
        }
    }

    public static class GarbageCollectionInstruments
    extends InstrumentGroup {
        private final Map<String, Histogram> _collectorCache = (Map)Map$.MODULE$.empty();
        private final Histogram memoryUtilization = (Histogram)this.register((Metric)JvmMetrics$.MODULE$.MemoryUtilization());
        private final Histogram promotionToOld = (Histogram)this.register((Metric)JvmMetrics$.MODULE$.GcPromotion(), "space", "old");

        public GarbageCollectionInstruments(TagSet tags) {
            super(tags);
        }

        public Histogram memoryUtilization() {
            return this.memoryUtilization;
        }

        public Histogram promotionToOld() {
            return this.promotionToOld;
        }

        public Histogram garbageCollectionTime(JvmMetricsCollector.Collector collector) {
            return (Histogram)this._collectorCache.getOrElseUpdate((Object)collector.alias(), () -> this.garbageCollectionTime$$anonfun$1(collector));
        }

        private final Histogram garbageCollectionTime$$anonfun$1(JvmMetricsCollector.Collector collector$1) {
            TagSet collectorTags = TagSet$.MODULE$.builder().add("collector", collector$1.alias()).add("generation", collector$1.generation().toString()).build();
            return (Histogram)this.register((Metric)JvmMetrics$.MODULE$.GC(), collectorTags);
        }
    }

    public static class MemoryUsageInstruments
    extends InstrumentGroup {
        private final TagSet tags;
        private final Counter allocation;
        private final Map<String, MemoryRegionInstruments> _memoryRegionsCache;
        private final Map<String, MemoryRegionInstruments> _memoryPoolsCache;
        private final Map<String, BufferPoolInstruments> _memoryBuffersCache;

        public MemoryUsageInstruments(TagSet tags) {
            this.tags = tags;
            super(tags);
            this.allocation = (Counter)this.register((Metric)JvmMetrics$.MODULE$.MemoryAllocation());
            this._memoryRegionsCache = (Map)Map$.MODULE$.empty();
            this._memoryPoolsCache = (Map)Map$.MODULE$.empty();
            this._memoryBuffersCache = (Map)Map$.MODULE$.empty();
        }

        public Counter allocation() {
            return this.allocation;
        }

        public MemoryRegionInstruments regionInstruments(String regionName) {
            return (MemoryRegionInstruments)this._memoryRegionsCache.getOrElseUpdate((Object)regionName, () -> this.regionInstruments$$anonfun$1(regionName));
        }

        public MemoryRegionInstruments poolInstruments(JvmMetricsCollector.MemoryPool pool) {
            return (MemoryRegionInstruments)this._memoryPoolsCache.getOrElseUpdate((Object)pool.alias(), () -> this.poolInstruments$$anonfun$1(pool));
        }

        public BufferPoolInstruments bufferPoolInstruments(String poolName) {
            return (BufferPoolInstruments)this._memoryBuffersCache.getOrElseUpdate((Object)poolName, () -> this.bufferPoolInstruments$$anonfun$1(poolName));
        }

        private final MemoryRegionInstruments regionInstruments$$anonfun$1(String regionName$1) {
            TagSet region = TagSet$.MODULE$.of("region", regionName$1);
            return JvmMetrics$MemoryUsageInstruments$MemoryRegionInstruments$.MODULE$.apply((Histogram)this.register((Metric)JvmMetrics$.MODULE$.MemoryUsed(), region), (Histogram)this.register((Metric)JvmMetrics$.MODULE$.MemoryFree(), region), (Gauge)this.register((Metric)JvmMetrics$.MODULE$.MemoryCommitted(), region), (Gauge)this.register((Metric)JvmMetrics$.MODULE$.MemoryMax(), region));
        }

        private final MemoryRegionInstruments poolInstruments$$anonfun$1(JvmMetricsCollector.MemoryPool pool$1) {
            TagSet region = TagSet$.MODULE$.of("pool", pool$1.alias());
            return JvmMetrics$MemoryUsageInstruments$MemoryRegionInstruments$.MODULE$.apply((Histogram)this.register((Metric)JvmMetrics$.MODULE$.MemoryPoolUsed(), region), (Histogram)this.register((Metric)JvmMetrics$.MODULE$.MemoryPoolFree(), region), (Gauge)this.register((Metric)JvmMetrics$.MODULE$.MemoryPoolCommitted(), region), (Gauge)this.register((Metric)JvmMetrics$.MODULE$.MemoryPoolMax(), region));
        }

        private final BufferPoolInstruments bufferPoolInstruments$$anonfun$1(String poolName$1) {
            TagSet bufferTags = this.tags.withTag("pool", poolName$1);
            return JvmMetrics$MemoryUsageInstruments$BufferPoolInstruments$.MODULE$.apply((Gauge)this.register((Metric)JvmMetrics$.MODULE$.BufferPoolCount(), bufferTags), (Gauge)this.register((Metric)JvmMetrics$.MODULE$.BufferPoolUsed(), bufferTags), (Gauge)this.register((Metric)JvmMetrics$.MODULE$.BufferPoolCapacity(), bufferTags));
        }

        public static class BufferPoolInstruments
        implements Product,
        Serializable {
            private final Gauge count;
            private final Gauge used;
            private final Gauge capacity;

            public static BufferPoolInstruments apply(Gauge gauge, Gauge gauge2, Gauge gauge3) {
                return JvmMetrics$MemoryUsageInstruments$BufferPoolInstruments$.MODULE$.apply(gauge, gauge2, gauge3);
            }

            public static BufferPoolInstruments fromProduct(Product product) {
                return JvmMetrics$MemoryUsageInstruments$BufferPoolInstruments$.MODULE$.fromProduct(product);
            }

            public static BufferPoolInstruments unapply(BufferPoolInstruments bufferPoolInstruments) {
                return JvmMetrics$MemoryUsageInstruments$BufferPoolInstruments$.MODULE$.unapply(bufferPoolInstruments);
            }

            public BufferPoolInstruments(Gauge count, Gauge used, Gauge capacity) {
                this.count = count;
                this.used = used;
                this.capacity = capacity;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof BufferPoolInstruments)) return false;
                BufferPoolInstruments bufferPoolInstruments = (BufferPoolInstruments)object;
                Gauge gauge = this.count();
                Gauge gauge2 = bufferPoolInstruments.count();
                if (gauge == null) {
                    if (gauge2 != null) {
                        return false;
                    }
                } else if (!gauge.equals(gauge2)) return false;
                Gauge gauge3 = this.used();
                Gauge gauge4 = bufferPoolInstruments.used();
                if (gauge3 == null) {
                    if (gauge4 != null) {
                        return false;
                    }
                } else if (!gauge3.equals(gauge4)) return false;
                Gauge gauge5 = this.capacity();
                Gauge gauge6 = bufferPoolInstruments.capacity();
                if (gauge5 == null) {
                    if (gauge6 != null) {
                        return false;
                    }
                } else if (!gauge5.equals(gauge6)) return false;
                if (!bufferPoolInstruments.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof BufferPoolInstruments;
            }

            public int productArity() {
                return 3;
            }

            public String productPrefix() {
                return "BufferPoolInstruments";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "count";
                    }
                    case 1: {
                        return "used";
                    }
                    case 2: {
                        return "capacity";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Gauge count() {
                return this.count;
            }

            public Gauge used() {
                return this.used;
            }

            public Gauge capacity() {
                return this.capacity;
            }

            public BufferPoolInstruments copy(Gauge count, Gauge used, Gauge capacity) {
                return new BufferPoolInstruments(count, used, capacity);
            }

            public Gauge copy$default$1() {
                return this.count();
            }

            public Gauge copy$default$2() {
                return this.used();
            }

            public Gauge copy$default$3() {
                return this.capacity();
            }

            public Gauge _1() {
                return this.count();
            }

            public Gauge _2() {
                return this.used();
            }

            public Gauge _3() {
                return this.capacity();
            }
        }

        public static class MemoryRegionInstruments
        implements Product,
        Serializable {
            private final Histogram used;
            private final Histogram free;
            private final Gauge committed;
            private final Gauge max;

            public static MemoryRegionInstruments apply(Histogram histogram, Histogram histogram2, Gauge gauge, Gauge gauge2) {
                return JvmMetrics$MemoryUsageInstruments$MemoryRegionInstruments$.MODULE$.apply(histogram, histogram2, gauge, gauge2);
            }

            public static MemoryRegionInstruments fromProduct(Product product) {
                return JvmMetrics$MemoryUsageInstruments$MemoryRegionInstruments$.MODULE$.fromProduct(product);
            }

            public static MemoryRegionInstruments unapply(MemoryRegionInstruments memoryRegionInstruments) {
                return JvmMetrics$MemoryUsageInstruments$MemoryRegionInstruments$.MODULE$.unapply(memoryRegionInstruments);
            }

            public MemoryRegionInstruments(Histogram used, Histogram free, Gauge committed, Gauge max) {
                this.used = used;
                this.free = free;
                this.committed = committed;
                this.max = max;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof MemoryRegionInstruments)) return false;
                MemoryRegionInstruments memoryRegionInstruments = (MemoryRegionInstruments)object;
                Histogram histogram = this.used();
                Histogram histogram2 = memoryRegionInstruments.used();
                if (histogram == null) {
                    if (histogram2 != null) {
                        return false;
                    }
                } else if (!histogram.equals(histogram2)) return false;
                Histogram histogram3 = this.free();
                Histogram histogram4 = memoryRegionInstruments.free();
                if (histogram3 == null) {
                    if (histogram4 != null) {
                        return false;
                    }
                } else if (!histogram3.equals(histogram4)) return false;
                Gauge gauge = this.committed();
                Gauge gauge2 = memoryRegionInstruments.committed();
                if (gauge == null) {
                    if (gauge2 != null) {
                        return false;
                    }
                } else if (!gauge.equals(gauge2)) return false;
                Gauge gauge3 = this.max();
                Gauge gauge4 = memoryRegionInstruments.max();
                if (gauge3 == null) {
                    if (gauge4 != null) {
                        return false;
                    }
                } else if (!gauge3.equals(gauge4)) return false;
                if (!memoryRegionInstruments.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof MemoryRegionInstruments;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "MemoryRegionInstruments";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return this._4();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "used";
                    }
                    case 1: {
                        return "free";
                    }
                    case 2: {
                        return "committed";
                    }
                    case 3: {
                        return "max";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Histogram used() {
                return this.used;
            }

            public Histogram free() {
                return this.free;
            }

            public Gauge committed() {
                return this.committed;
            }

            public Gauge max() {
                return this.max;
            }

            public MemoryRegionInstruments copy(Histogram used, Histogram free, Gauge committed, Gauge max) {
                return new MemoryRegionInstruments(used, free, committed, max);
            }

            public Histogram copy$default$1() {
                return this.used();
            }

            public Histogram copy$default$2() {
                return this.free();
            }

            public Gauge copy$default$3() {
                return this.committed();
            }

            public Gauge copy$default$4() {
                return this.max();
            }

            public Histogram _1() {
                return this.used();
            }

            public Histogram _2() {
                return this.free();
            }

            public Gauge _3() {
                return this.committed();
            }

            public Gauge _4() {
                return this.max();
            }
        }
    }

    public static class ThreadsInstruments
    extends InstrumentGroup {
        private final Map<JvmMetricsCollector.ThreadState, Gauge> _threadsStatesCache = (Map)Map$.MODULE$.empty();
        private final Gauge total = (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ThreadsTotal());
        private final Gauge peak = (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ThreadsPeak());
        private final Gauge daemon = (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ThreadsDaemon());

        public ThreadsInstruments() {
            super(TagSet$.MODULE$.Empty());
        }

        public Gauge total() {
            return this.total;
        }

        public Gauge peak() {
            return this.peak;
        }

        public Gauge daemon() {
            return this.daemon;
        }

        public Gauge threadState(JvmMetricsCollector.ThreadState threadState) {
            return (Gauge)this._threadsStatesCache.getOrElseUpdate((Object)threadState, () -> this.threadState$$anonfun$1(threadState));
        }

        private final Gauge threadState$$anonfun$1(JvmMetricsCollector.ThreadState threadState$1) {
            TagSet stateTag = TagSet$.MODULE$.of("state", threadState$1.toString());
            return (Gauge)this.register((Metric)JvmMetrics$.MODULE$.ThreadsStates(), stateTag);
        }
    }
}

