/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.ThreadMXBean;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import kamon.instrumentation.system.jvm.JvmMetrics;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$Collector$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$Collector$Generation$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$MemoryPool$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$MemoryPool$Usage$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$MemoryPool$Usage$OldGeneration$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$MemoryPool$Usage$SingleGeneration$;
import kamon.instrumentation.system.jvm.JvmMetricsCollector$ThreadState$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Function1;
import scala.Int$;
import scala.Long$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Map;
import scala.concurrent.ExecutionContext;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class JvmMetricsCollector
implements ScheduledAction {
    private final NotificationListener _gcListener;
    private final JmxMetricsCollectorTask _jmxCollectorTask;

    public JvmMetricsCollector(ExecutionContext ec) {
        TagSet _defaultTags = TagSet$.MODULE$.of("component", "jvm");
        this._gcListener = this.registerGcListener(_defaultTags);
        JvmMetrics.MemoryUsageInstruments _memoryUsageInstruments = new JvmMetrics.MemoryUsageInstruments(_defaultTags);
        JvmMetrics.ThreadsInstruments _threadsUsageInstruments = new JvmMetrics.ThreadsInstruments();
        JvmMetrics.ClassLoadingInstruments _classLoadingInstruments = new JvmMetrics.ClassLoadingInstruments(_defaultTags);
        this._jmxCollectorTask = new JmxMetricsCollectorTask(this, _memoryUsageInstruments, _threadsUsageInstruments, _classLoadingInstruments);
    }

    public void run() {
        this._jmxCollectorTask.run();
    }

    public void stop() {
        this.deregisterGcListener();
    }

    public void reconfigure(Config newConfig) {
    }

    private NotificationListener registerGcListener(TagSet defaultTags) {
        JvmMetrics.GarbageCollectionInstruments gcInstruments = new JvmMetrics.GarbageCollectionInstruments(defaultTags);
        GcNotificationListener gcListener = new GcNotificationListener(this, gcInstruments);
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).foreach((Function1)(JProcedure1 & Serializable)gcBean -> {
            if (gcBean instanceof NotificationEmitter) {
                ((NotificationEmitter)((Object)gcBean)).addNotificationListener(gcListener, null, null);
                return;
            }
        });
        return gcListener;
    }

    private void deregisterGcListener() {
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).foreach((Function1)(JProcedure1 & Serializable)gcBean -> {
            if (gcBean instanceof NotificationEmitter) {
                ((NotificationEmitter)((Object)gcBean)).removeNotificationListener(this._gcListener);
                return;
            }
        });
    }

    public static final /* synthetic */ void kamon$instrumentation$system$jvm$JvmMetricsCollector$GcNotificationListener$$_$handleNotification$$anonfun$2(LongRef totalMemory$1, LongRef usedMemory$1, Tuple2 x$1) {
        Tuple2 tuple2;
        block2: {
            block3: {
                long l;
                long l2;
                MemoryUsage regionUsageAfterGC;
                block4: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String regionName = (String)tuple2._1();
                    regionUsageAfterGC = (MemoryUsage)tuple2._2();
                    MemoryPool region = JvmMetricsCollector$MemoryPool$.MODULE$.find(regionName);
                    if (regionUsageAfterGC.getMax() == -1L) break block3;
                    MemoryPool.Usage usage = region.usage();
                    JvmMetricsCollector$MemoryPool$Usage$OldGeneration$ jvmMetricsCollector$MemoryPool$Usage$OldGeneration$ = JvmMetricsCollector$MemoryPool$Usage$OldGeneration$.MODULE$;
                    if (!(usage == null ? jvmMetricsCollector$MemoryPool$Usage$OldGeneration$ != null : !usage.equals(jvmMetricsCollector$MemoryPool$Usage$OldGeneration$))) break block4;
                    MemoryPool.Usage usage2 = region.usage();
                    JvmMetricsCollector$MemoryPool$Usage$SingleGeneration$ jvmMetricsCollector$MemoryPool$Usage$SingleGeneration$ = JvmMetricsCollector$MemoryPool$Usage$SingleGeneration$.MODULE$;
                    if (usage2 != null ? !usage2.equals(jvmMetricsCollector$MemoryPool$Usage$SingleGeneration$) : jvmMetricsCollector$MemoryPool$Usage$SingleGeneration$ != null) break block3;
                }
                totalMemory$1.elem = l2 = totalMemory$1.elem + regionUsageAfterGC.getMax();
                usedMemory$1.elem = l = usedMemory$1.elem + regionUsageAfterGC.getUsed();
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* bridge */ /* synthetic */ ThreadInfo kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$_$_$$anonfun$adapted$1(ThreadMXBean threadsMxBean$2, Object _$1) {
        return threadsMxBean$2.getThreadInfo(BoxesRunTime.unboxToLong((Object)_$1), 0);
    }

    public static final /* synthetic */ Thread.State kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$_$run$$anonfun$2(ThreadInfo _$2) {
        return _$2.getThreadState();
    }

    public static final /* synthetic */ int kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$_$run$$anonfun$3(ThreadInfo[] _$3) {
        return _$3.length;
    }

    public static class Collector
    implements Product,
    Serializable {
        private final String name;
        private final String alias;
        private final Generation generation;
        private final boolean pausesTheJVM;

        public static Collector apply(String string, String string2, Generation generation, boolean bl) {
            return JvmMetricsCollector$Collector$.MODULE$.apply(string, string2, generation, bl);
        }

        public static Collector find(String string) {
            return JvmMetricsCollector$Collector$.MODULE$.find(string);
        }

        public static Collector fromProduct(Product product) {
            return JvmMetricsCollector$Collector$.MODULE$.fromProduct(product);
        }

        public static Collector unapply(Collector collector) {
            return JvmMetricsCollector$Collector$.MODULE$.unapply(collector);
        }

        public static boolean $lessinit$greater$default$4() {
            return JvmMetricsCollector$Collector$.MODULE$.$lessinit$greater$default$4();
        }

        public Collector(String name, String alias, Generation generation, boolean pausesTheJVM) {
            this.name = name;
            this.alias = alias;
            this.generation = generation;
            this.pausesTheJVM = pausesTheJVM;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.alias()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.generation()));
            n = Statics.mix((int)n, (int)(this.pausesTheJVM() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Collector)) return false;
            Collector collector = (Collector)object;
            if (this.pausesTheJVM() != collector.pausesTheJVM()) return false;
            String string = this.name();
            String string2 = collector.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.alias();
            String string4 = collector.alias();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Generation generation = this.generation();
            Generation generation2 = collector.generation();
            if (generation == null) {
                if (generation2 != null) {
                    return false;
                }
            } else if (!generation.equals(generation2)) return false;
            if (!collector.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Collector;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Collector";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "alias";
                }
                case 2: {
                    return "generation";
                }
                case 3: {
                    return "pausesTheJVM";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String alias() {
            return this.alias;
        }

        public Generation generation() {
            return this.generation;
        }

        public boolean pausesTheJVM() {
            return this.pausesTheJVM;
        }

        public Collector copy(String name, String alias, Generation generation, boolean pausesTheJVM) {
            return new Collector(name, alias, generation, pausesTheJVM);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.alias();
        }

        public Generation copy$default$3() {
            return this.generation();
        }

        public boolean copy$default$4() {
            return this.pausesTheJVM();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.alias();
        }

        public Generation _3() {
            return this.generation();
        }

        public boolean _4() {
            return this.pausesTheJVM();
        }

        public static interface Generation {
            public static int ordinal(Generation generation) {
                return JvmMetricsCollector$Collector$Generation$.MODULE$.ordinal(generation);
            }
        }
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new JvmMetricsCollector(settings.executionContext());
        }
    }

    public class GcNotificationListener
    implements NotificationListener {
        private final JvmMetrics.GarbageCollectionInstruments gcInstruments;
        private final /* synthetic */ JvmMetricsCollector $outer;

        public GcNotificationListener(JvmMetricsCollector $outer, JvmMetrics.GarbageCollectionInstruments gcInstruments) {
            this.gcInstruments = gcInstruments;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public JvmMetrics.GarbageCollectionInstruments gcInstruments() {
            return this.gcInstruments;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            String string = notification.getType();
            String string2 = "com.sun.management.gc.notification";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                CompositeData compositeData = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(compositeData);
                Collector collector = JvmMetricsCollector$Collector$.MODULE$.find(info.getGcName());
                if (collector.pausesTheJVM()) {
                    this.gcInstruments().garbageCollectionTime(collector).record(info.getGcInfo().getDuration());
                }
                Map usageBeforeGc = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(info.getGcInfo().getMemoryUsageBeforeGc()).asScala();
                Map usageAfterGc = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(info.getGcInfo().getMemoryUsageAfterGc()).asScala();
                usageBeforeGc.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String regionName = (String)tuple2._1();
                        MemoryUsage regionUsageBeforeGc = (MemoryUsage)tuple2._2();
                        MemoryPool region = JvmMetricsCollector$MemoryPool$.MODULE$.find(regionName);
                        MemoryPool.Usage usage = region.usage();
                        JvmMetricsCollector$MemoryPool$Usage$OldGeneration$ jvmMetricsCollector$MemoryPool$Usage$OldGeneration$ = JvmMetricsCollector$MemoryPool$Usage$OldGeneration$.MODULE$;
                        if (!(usage != null ? !usage.equals(jvmMetricsCollector$MemoryPool$Usage$OldGeneration$) : jvmMetricsCollector$MemoryPool$Usage$OldGeneration$ != null)) {
                            MemoryUsage regionUsageAfterGc = (MemoryUsage)usageAfterGc.apply((Object)regionName);
                            long diff = regionUsageAfterGc.getUsed() - regionUsageBeforeGc.getUsed();
                            if (diff > 0L) {
                                this.gcInstruments().promotionToOld().record(diff);
                                return;
                            }
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                LongRef totalMemory = LongRef.create((long)0L);
                LongRef usedMemory = LongRef.create((long)0L);
                usageAfterGc.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> JvmMetricsCollector.kamon$instrumentation$system$jvm$JvmMetricsCollector$GcNotificationListener$$_$handleNotification$$anonfun$2(totalMemory, usedMemory, arg_0)));
                if (totalMemory.elem > 0L) {
                    long utilizationPercentage = (long)Math.min(100.0, (double)usedMemory.elem * 100.0 / (double)totalMemory.elem);
                    this.gcInstruments().memoryUtilization().record(utilizationPercentage);
                    return;
                }
                return;
            }
        }

        public final /* synthetic */ JvmMetricsCollector kamon$instrumentation$system$jvm$JvmMetricsCollector$GcNotificationListener$$$outer() {
            return this.$outer;
        }
    }

    public class JmxMetricsCollectorTask
    implements Runnable {
        private final JvmMetrics.MemoryUsageInstruments memoryUsageInstruments;
        private final JvmMetrics.ThreadsInstruments threadsInstruments;
        private final JvmMetrics.MemoryUsageInstruments.MemoryRegionInstruments _heapUsage;
        private final JvmMetrics.MemoryUsageInstruments.MemoryRegionInstruments _nonHeapUsage;
        private final JvmMetrics.ClassLoadingInstruments _classLoading;
        private long _lastSeenAllocatedBytes;
        private final /* synthetic */ JvmMetricsCollector $outer;

        public JmxMetricsCollectorTask(JvmMetricsCollector $outer, JvmMetrics.MemoryUsageInstruments memoryUsageInstruments, JvmMetrics.ThreadsInstruments threadsInstruments, JvmMetrics.ClassLoadingInstruments classLoadingInstruments) {
            this.memoryUsageInstruments = memoryUsageInstruments;
            this.threadsInstruments = threadsInstruments;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this._heapUsage = memoryUsageInstruments.regionInstruments("heap");
            this._nonHeapUsage = memoryUsageInstruments.regionInstruments("non-heap");
            this._classLoading = classLoadingInstruments;
            this._lastSeenAllocatedBytes = 0L;
        }

        @Override
        public void run() {
            ThreadMXBean threadsMxBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
            this.threadsInstruments.total().update(Int$.MODULE$.int2double(threadsMxBean.getThreadCount()));
            this.threadsInstruments.peak().update(Int$.MODULE$.int2double(threadsMxBean.getPeakThreadCount()));
            this.threadsInstruments.daemon().update(Int$.MODULE$.int2double(threadsMxBean.getDaemonThreadCount()));
            long[] allThreadIds = threadsMxBean.getAllThreadIds();
            Object object = Predef$.MODULE$.longArrayOps(allThreadIds);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, arg_0 -> JvmMetricsCollector.kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$_$_$$anonfun$adapted$1(threadsMxBean, arg_0), ClassTag$.MODULE$.apply(ThreadInfo.class)));
            ArrayOps$.MODULE$.groupBy$extension(object2, JvmMetricsCollector::kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$_$run$$anonfun$2).mapValues(JvmMetricsCollector::kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$_$run$$anonfun$3).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Thread.State state = (Thread.State)((Object)((Object)tuple2._1()));
                    int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    ThreadState threadState = JvmMetricsCollector$ThreadState$.MODULE$.find(state.toString());
                    return this.threadsInstruments.threadState(threadState).update(Int$.MODULE$.int2double(count));
                }
                throw new MatchError((Object)tuple2);
            });
            long totalAllocatedBytes = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(threadsMxBean.getThreadAllocatedBytes(allThreadIds)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long bytesAllocatedSinceLastCheck = totalAllocatedBytes - this._lastSeenAllocatedBytes;
            if (bytesAllocatedSinceLastCheck > 0L) {
                this.memoryUsageInstruments.allocation().increment(bytesAllocatedSinceLastCheck);
            }
            this._lastSeenAllocatedBytes = totalAllocatedBytes;
            MemoryUsage currentHeapUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            long freeHeap = Math.max(0L, currentHeapUsage.getMax() - currentHeapUsage.getUsed());
            this._heapUsage.free().record(freeHeap);
            this._heapUsage.used().record(currentHeapUsage.getUsed());
            this._heapUsage.max().update(Long$.MODULE$.long2double(currentHeapUsage.getMax()));
            this._heapUsage.committed().update(Long$.MODULE$.long2double(currentHeapUsage.getCommitted()));
            MemoryUsage currentNonHeapUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
            long freeNonHeap = Math.max(0L, currentNonHeapUsage.getMax() - currentNonHeapUsage.getUsed());
            this._nonHeapUsage.free().record(freeNonHeap);
            this._nonHeapUsage.used().record(currentNonHeapUsage.getUsed());
            this._nonHeapUsage.max().update(Long$.MODULE$.long2double(currentNonHeapUsage.getMax()));
            this._nonHeapUsage.committed().update(Long$.MODULE$.long2double(currentNonHeapUsage.getCommitted()));
            ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
            this._classLoading.loaded().update(Long$.MODULE$.long2double(classLoadingBean.getTotalLoadedClassCount()));
            this._classLoading.unloaded().update(Long$.MODULE$.long2double(classLoadingBean.getUnloadedClassCount()));
            this._classLoading.currentlyLoaded().update(Int$.MODULE$.int2double(classLoadingBean.getLoadedClassCount()));
            ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ManagementFactory.getMemoryPoolMXBeans()).asScala()).foreach((Function1 & Serializable)memoryBean -> {
                JvmMetrics.MemoryUsageInstruments.MemoryRegionInstruments poolInstruments = this.memoryUsageInstruments.poolInstruments(JvmMetricsCollector$MemoryPool$.MODULE$.find(memoryBean.getName()));
                MemoryUsage memoryUsage = memoryBean.getUsage();
                long freeMemory = Math.max(0L, memoryUsage.getMax() - memoryUsage.getUsed());
                poolInstruments.free().record(freeMemory);
                poolInstruments.used().record(memoryUsage.getUsed());
                poolInstruments.max().update(Long$.MODULE$.long2double(memoryUsage.getMax()));
                return poolInstruments.committed().update(Long$.MODULE$.long2double(memoryUsage.getCommitted()));
            });
            ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)).asScala()).toList().map((Function1 & Serializable)bean -> {
                JvmMetrics.MemoryUsageInstruments.BufferPoolInstruments bufferPoolInstruments = this.memoryUsageInstruments.bufferPoolInstruments(JvmMetricsCollector$MemoryPool$.MODULE$.sanitize(bean.getName()));
                bufferPoolInstruments.count().update(Long$.MODULE$.long2double(bean.getCount()));
                bufferPoolInstruments.used().update(Long$.MODULE$.long2double(bean.getMemoryUsed()));
                return bufferPoolInstruments.capacity().update(Long$.MODULE$.long2double(bean.getTotalCapacity()));
            });
        }

        public final /* synthetic */ JvmMetricsCollector kamon$instrumentation$system$jvm$JvmMetricsCollector$JmxMetricsCollectorTask$$$outer() {
            return this.$outer;
        }
    }

    public static class MemoryPool
    implements Product,
    Serializable {
        private final String name;
        private final String alias;
        private final Usage usage;

        public static MemoryPool apply(String string, String string2, Usage usage) {
            return JvmMetricsCollector$MemoryPool$.MODULE$.apply(string, string2, usage);
        }

        public static MemoryPool find(String string) {
            return JvmMetricsCollector$MemoryPool$.MODULE$.find(string);
        }

        public static MemoryPool fromProduct(Product product) {
            return JvmMetricsCollector$MemoryPool$.MODULE$.fromProduct(product);
        }

        public static String sanitize(String string) {
            return JvmMetricsCollector$MemoryPool$.MODULE$.sanitize(string);
        }

        public static MemoryPool unapply(MemoryPool memoryPool) {
            return JvmMetricsCollector$MemoryPool$.MODULE$.unapply(memoryPool);
        }

        public MemoryPool(String name, String alias, Usage usage) {
            this.name = name;
            this.alias = alias;
            this.usage = usage;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemoryPool)) return false;
            MemoryPool memoryPool = (MemoryPool)object;
            String string = this.name();
            String string2 = memoryPool.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.alias();
            String string4 = memoryPool.alias();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Usage usage = this.usage();
            Usage usage2 = memoryPool.usage();
            if (usage == null) {
                if (usage2 != null) {
                    return false;
                }
            } else if (!usage.equals(usage2)) return false;
            if (!memoryPool.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemoryPool;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MemoryPool";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "alias";
                }
                case 2: {
                    return "usage";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String alias() {
            return this.alias;
        }

        public Usage usage() {
            return this.usage;
        }

        public MemoryPool copy(String name, String alias, Usage usage) {
            return new MemoryPool(name, alias, usage);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.alias();
        }

        public Usage copy$default$3() {
            return this.usage();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.alias();
        }

        public Usage _3() {
            return this.usage();
        }

        public static interface Usage {
            public static int ordinal(Usage usage) {
                return JvmMetricsCollector$MemoryPool$Usage$.MODULE$.ordinal(usage);
            }
        }
    }

    public static interface ThreadState {
        public static ThreadState find(String string) {
            return JvmMetricsCollector$ThreadState$.MODULE$.find(string);
        }

        public static int ordinal(ThreadState threadState) {
            return JvmMetricsCollector$ThreadState$.MODULE$.ordinal(threadState);
        }
    }
}

