/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.process;

import com.sun.jna.Platform;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.process.ProcessMetrics;
import kamon.metric.Timer;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Long$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.util.Try$;

public class ProcessMetricsCollector
implements ScheduledAction {
    private final String _hiccupIntervalPath;
    public final ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments;
    private final MetricsCollectionTask _collectionTask;
    private final HiccupMonitor _hiccupMonitor;

    public ProcessMetricsCollector(ExecutionContext ec) {
        this._hiccupIntervalPath = "kamon.instrumentation.system.process.hiccup-monitor-interval";
        TagSet _defaultTags = TagSet$.MODULE$.of("component", "process");
        this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments = new ProcessMetrics.ProcessInstruments(_defaultTags);
        this._collectionTask = new MetricsCollectionTask();
        this._hiccupMonitor = this.startHiccupMonitor();
    }

    public void run() {
        this._collectionTask.run();
    }

    public void stop() {
        this._hiccupMonitor.terminate();
        this._collectionTask.cleanup();
    }

    public void reconfigure(Config newConfig) {
        this._hiccupMonitor.updateInterval(newConfig.getDuration(this._hiccupIntervalPath));
    }

    private HiccupMonitor startHiccupMonitor() {
        Duration interval = Kamon$.MODULE$.config().getDuration(this._hiccupIntervalPath);
        HiccupMonitor monitorThread = new HiccupMonitor(this, this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.hiccups(), interval);
        monitorThread.setDaemon(true);
        monitorThread.setName("hiccup-monitor");
        monitorThread.start();
        return monitorThread;
    }

    public static final /* synthetic */ boolean kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_$recordProcessULimits$$anonfun$1$$anonfun$1(String _$1) {
        return _$1.toLowerCase().startsWith("max open files");
    }

    public static final long kamon$instrumentation$system$process$ProcessMetricsCollector$HiccupMonitor$$_$hic$1(LongRef shortestObservedDelta$1, long resolution) {
        long start = System.nanoTime();
        TimeUnit.NANOSECONDS.sleep(resolution);
        long delta = System.nanoTime() - start;
        if (delta < shortestObservedDelta$1.elem) {
            long l;
            shortestObservedDelta$1.elem = l = delta;
        }
        return delta - shortestObservedDelta$1.elem;
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new ProcessMetricsCollector(settings.executionContext());
        }
    }

    public final class HiccupMonitor
    extends Thread {
        private final Timer hiccupTimeMetric;
        private volatile long _hiccupNanos;
        private volatile boolean _doRun;
        private final /* synthetic */ ProcessMetricsCollector $outer;

        public HiccupMonitor(ProcessMetricsCollector $outer, Timer hiccupTimeMetric, Duration duration) {
            this.hiccupTimeMetric = hiccupTimeMetric;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this._hiccupNanos = duration.toNanos();
            this._doRun = true;
        }

        @Override
        public void run() {
            LongRef shortestObservedDelta = LongRef.create((long)Long.MAX_VALUE);
            while (this._doRun) {
                long hiccupTime = ProcessMetricsCollector.kamon$instrumentation$system$process$ProcessMetricsCollector$HiccupMonitor$$_$hic$1(shortestObservedDelta, this._hiccupNanos);
                this.record(hiccupTime, this._hiccupNanos);
            }
        }

        public void record(long value, long expectedIntervalBetweenValueSamples) {
            this.hiccupTimeMetric.record(value);
            if (expectedIntervalBetweenValueSamples > 0L) {
                for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
                    this.hiccupTimeMetric.record(missingValue);
                }
                return;
            }
        }

        public void terminate() {
            this._doRun = false;
        }

        public void updateInterval(Duration duration) {
            this._hiccupNanos = duration.toNanos();
        }

        public final /* synthetic */ ProcessMetricsCollector kamon$instrumentation$system$process$ProcessMetricsCollector$HiccupMonitor$$$outer() {
            return this.$outer;
        }
    }

    public class MetricsCollectionTask {
        private final OperatingSystem _os;
        private final int _pid;
        private final double _processorCount;
        private long[] _previousProcessCpuTime;

        public MetricsCollectionTask() {
            if (ProcessMetricsCollector.this == null) {
                throw new NullPointerException();
            }
            SystemInfo _systemInfo = new SystemInfo();
            HardwareAbstractionLayer _hal = _systemInfo.getHardware();
            this._os = _systemInfo.getOperatingSystem();
            this._pid = this._os.getProcessId();
            this._processorCount = _hal.getProcessor().getLogicalProcessorCount();
            this._previousProcessCpuTime = (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE));
        }

        public void run() {
            this.recordProcessCpu();
            this.recordProcessULimits();
        }

        public void cleanup() {
            ProcessMetricsCollector.this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.remove();
        }

        private void recordProcessCpu() {
            OSProcess process = this._os.getProcess(this._pid);
            long[] previous = this._previousProcessCpuTime;
            long[] current = new long[]{process.getKernelTime(), process.getUserTime(), process.getUpTime()};
            Object object = Predef$.MODULE$.longArrayOps(previous);
            if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
                long kernelTime = package$.MODULE$.max(0L, current[0] - previous[0]);
                long userTime = package$.MODULE$.max(0L, current[1] - previous[1]);
                long totalTime = package$.MODULE$.max(0L, current[2] - previous[2]);
                ProcessMetricsCollector.this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.user().record(this.toPercent$1(totalTime, userTime));
                ProcessMetricsCollector.this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.system().record(this.toPercent$1(totalTime, kernelTime));
                ProcessMetricsCollector.this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.combined().record(this.toPercent$1(totalTime, userTime + kernelTime));
            }
            this._previousProcessCpuTime = current;
        }

        private void recordProcessULimits() {
            OSProcess process = this._os.getProcess(this._pid);
            ProcessMetricsCollector.this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.openFilesCurrent().update(Long$.MODULE$.long2double(Math.max(process.getOpenFiles(), 0L)));
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.recordProcessULimits$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public final /* synthetic */ ProcessMetricsCollector kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer() {
            return ProcessMetricsCollector.this;
        }

        private final long toPercent$1(long totalTime$1, long value) {
            if (totalTime$1 > 0L) {
                return (long)(100.0 * (double)value / (double)totalTime$1 / this._processorCount);
            }
            return 0L;
        }

        private final void recordProcessULimits$$anonfun$1() {
            if (Platform.isLinux()) {
                List allLimits = FileUtil.readFile((String)String.format(new StringBuilder(13).append("/proc/").append(this._pid).append("/limits").toString(), new Object[0]));
                ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)allLimits).asScala()).find(ProcessMetricsCollector::kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_$recordProcessULimits$$anonfun$1$$anonfun$1).map((Function1 & Serializable)openFilesLimitLine -> {
                    int openFilesLimit = ParseUtil.getNthIntValue((String)openFilesLimitLine, (int)1);
                    return ProcessMetricsCollector.this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments.openFilesLimit().update(Int$.MODULE$.int2double(openFilesLimit));
                });
                return;
            }
        }
    }
}

