/*
 * Decompiled with CFR 0.152.
 */
package kamon.zipkin;

import com.typesafe.config.Config;
import java.net.InetAddress;
import java.time.Instant;
import kamon.Kamon$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.SpanReporter;
import kamon.status.Environment;
import kamon.tag.Lookups$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import kamon.trace.Span;
import kamon.util.Clock$;
import kamon.zipkin.ZipkinReporter$PeerKeys$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001\u001d\u0011aBW5qW&t'+\u001a9peR,'O\u0003\u0002\u0004\t\u00051!0\u001b9lS:T\u0011!B\u0001\u0006W\u0006lwN\\\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011AB7pIVdW-\u0003\u0002\u0014!\ta1\u000b]1o%\u0016\u0004xN\u001d;fe\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0006d_:4\u0017n\u001a)bi\"\u0004\"a\u0006\u000e\u000f\u0005%A\u0012BA\r\u000b\u0003\u0019\u0001&/\u001a3fM&\u00111\u0004\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eQ\u0001\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\b\u0006\u0002!EA\u0011\u0011\u0005A\u0007\u0002\u0005!)Q#\ba\u0001-!9A\u0005\u0001b\u0001\n\u0013)\u0013aB0m_\u001e<WM]\u000b\u0002MA\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0006g24GG\u001b\u0006\u0002W\u0005\u0019qN]4\n\u00055B#A\u0002'pO\u001e,'\u000f\u0003\u00040\u0001\u0001\u0006IAJ\u0001\t?2|wmZ3sA!9\u0011\u0007\u0001a\u0001\n\u0013\u0011\u0014AD0m_\u000e\fG.\u00128ea>Lg\u000e^\u000b\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0004{SB\\\u0017N\u001c\u001a\n\u0005a*$\u0001C#oIB|\u0017N\u001c;\t\u000fi\u0002\u0001\u0019!C\u0005w\u0005\u0011r\f\\8dC2,e\u000e\u001a9pS:$x\fJ3r)\tat\b\u0005\u0002\n{%\u0011aH\u0003\u0002\u0005+:LG\u000fC\u0004As\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013\u0007\u0003\u0004C\u0001\u0001\u0006KaM\u0001\u0010?2|7-\u00197F]\u0012\u0004x.\u001b8uA!9A\t\u0001a\u0001\n\u0013)\u0015!C0sKB|'\u000f^3s+\u00051\u0005cA$K\u00196\t\u0001J\u0003\u0002Jk\u0005A!/\u001a9peR,'/\u0003\u0002L\u0011\ni\u0011i]=oGJ+\u0007o\u001c:uKJ\u0004\"\u0001N'\n\u00059+$\u0001B*qC:Dq\u0001\u0015\u0001A\u0002\u0013%\u0011+A\u0007`e\u0016\u0004xN\u001d;fe~#S-\u001d\u000b\u0003yICq\u0001Q(\u0002\u0002\u0003\u0007a\t\u0003\u0004U\u0001\u0001\u0006KAR\u0001\u000b?J,\u0007o\u001c:uKJ\u0004\u0003\"\u0002\u0010\u0001\t\u00031F#\u0001\u0011\t\u000ba\u0003A\u0011A-\u0002%\rDWmY6K_&t\u0007+\u0019:b[\u0016$XM\u001d\u000b\u0002y!)1\f\u0001C!9\u0006Y!/\u001a9peR\u001c\u0006/\u00198t)\taT\fC\u0003_5\u0002\u0007q,A\u0003ta\u0006t7\u000fE\u0002aQ.t!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u00114\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t9'\"A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'aA*fc*\u0011qM\u0003\t\u0003YJt!!\u001c9\u000e\u00039T!a\u001c\u0003\u0002\u000bQ\u0014\u0018mY3\n\u0005Et\u0017\u0001B*qC:L!a\u001d;\u0003\u0011\u0019Kg.[:iK\u0012T!!\u001d8\t\rY\u0004A\u0011\u0001\u0002x\u0003-\u0019wN\u001c<feR\u001c\u0006/\u00198\u0015\u00051C\b\"B=v\u0001\u0004Y\u0017!C6b[>t7\u000b]1o\u0011\u0015Y\b\u0001\"\u0003}\u0003!\u0019\b/\u00198LS:$GcA?\u0002\bA\u0019a0!\u0001\u000f\u0005Qz\u0018BA96\u0013\u0011\t\u0019!!\u0002\u0003\t-Kg\u000e\u001a\u0006\u0003cVBa!!\u0003{\u0001\u0004Y\u0017\u0001B:qC:Dq!!\u0004\u0001\t\u0013\ty!A\u0004bI\u0012$\u0016mZ:\u0015\u000bq\n\t\"!\t\t\u0011\u0005M\u00111\u0002a\u0001\u0003+\tA\u0001^1hgB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0011\t1\u0001^1h\u0013\u0011\ty\"!\u0007\u0003\rQ\u000bwmU3u\u0011!\t\u0019#a\u0003A\u0002\u0005\u0015\u0012a\u00022vS2$WM\u001d\t\u0004}\u0006\u001d\u0012\u0002BA\u0015\u0003\u000b\u0011qAQ;jY\u0012,'\u000fC\u0004\u0002.\u0001!I!a\f\u0002\u0019\u001d,Go\u0015;sS:<G+Y4\u0015\u000bY\t\t$a\r\t\u000f\u0005%\u00111\u0006a\u0001W\"9\u0011QGA\u0016\u0001\u00041\u0012a\u0002;bO:\u000bW.\u001a\u0005\b\u0003s\u0001A\u0011BA\u001e\u0003)9W\r\u001e'p]\u001e$\u0016m\u001a\u000b\u0007\u0003{\t\u0019%!\u0012\u0011\u0007%\ty$C\u0002\u0002B)\u0011A\u0001T8oO\"9\u0011\u0011BA\u001c\u0001\u0004Y\u0007bBA\u001b\u0003o\u0001\rA\u0006\u0005\b\u0003\u0013\u0002A\u0011BA&\u0003)A\u0017m]!os\u0012\u000bG/\u0019\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002\n\u0003\u001fJ1!!\u0015\u000b\u0005\u001d\u0011un\u001c7fC:Dq!!\u0016\u0002H\u0001\u00071'\u0001\u0005f]\u0012\u0004x.\u001b8u\u0011\u001d\tI\u0006\u0001C!\u00037\n1B]3d_:4\u0017nZ;sKR\u0019A(!\u0018\t\u0011\u0005}\u0013q\u000ba\u0001\u0003C\n\u0011B\\3x\u0007>tg-[4\u0011\t\u0005\r\u0014\u0011O\u0007\u0003\u0003KRA!a\u001a\u0002j\u000511m\u001c8gS\u001eTA!a\u001b\u0002n\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002p\u0005\u00191m\\7\n\t\u0005M\u0014Q\r\u0002\u0007\u0007>tg-[4\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\u0005i!-^5mI\u0016sG\r]8j]R$\u0012a\r\u0005\b\u0003{\u0002A\u0011BA@\u00035\u0011W/\u001b7e%\u0016\u0004xN\u001d;feR\u0019a)!!\t\u0011\u0005\u001d\u00141\u0010a\u0001\u0003CBa!!\"\u0001\t\u0003J\u0016\u0001B:u_B<q!!#\u0003\u0011\u0003\tY)\u0001\b[SB\\\u0017N\u001c*fa>\u0014H/\u001a:\u0011\u0007\u0005\niI\u0002\u0004\u0002\u0005!\u0005\u0011qR\n\u0004\u0003\u001bC\u0001b\u0002\u0010\u0002\u000e\u0012\u0005\u00111\u0013\u000b\u0003\u0003\u00173q!a&\u0002\u000e\u0002\tIJA\u0004GC\u000e$xN]=\u0014\u000b\u0005U\u0005\"a'\u0011\u0007=\ti*C\u0002\u0002 B\u0011Q\"T8ek2,g)Y2u_JL\bb\u0002\u0010\u0002\u0016\u0012\u0005\u00111\u0015\u000b\u0003\u0003K\u0003B!a*\u0002\u00166\u0011\u0011Q\u0012\u0005\t\u0003W\u000b)\n\"\u0011\u0002.\u000611M]3bi\u0016$B!a,\u00026B\u0019q\"!-\n\u0007\u0005M\u0006C\u0001\u0004N_\u0012,H.\u001a\u0005\t\u0003o\u000bI\u000b1\u0001\u0002:\u0006A1/\u001a;uS:<7\u000f\u0005\u0003\u0002<\u0006\u0005gbA\b\u0002>&\u0019\u0011q\u0018\t\u0002\u001b5{G-\u001e7f\r\u0006\u001cGo\u001c:z\u0013\u0011\t\u0019-!2\u0003\u0011M+G\u000f^5oONT1!a0\u0011\u000f!\tI-!$\t\n\u0005-\u0017\u0001\u0003)fKJ\\U-_:\u0011\t\u0005\u001d\u0016Q\u001a\u0004\t\u0003\u001f\fi\t#\u0003\u0002R\nA\u0001+Z3s\u0017\u0016L8oE\u0002\u0002N\"AqAHAg\t\u0003\t)\u000e\u0006\u0002\u0002L\"Q\u0011\u0011\\Ag\u0005\u0004%\t!a7\u0002\t!{7\u000f^\u000b\u0003\u0003;\u0004B!a8\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0003mC:<'BAAt\u0003\u0011Q\u0017M^1\n\u0007m\t\t\u000fC\u0005\u0002n\u00065\u0007\u0015!\u0003\u0002^\u0006)\u0001j\\:uA!Q\u0011\u0011_Ag\u0005\u0004%\t!a7\u0002\tA{'\u000f\u001e\u0005\n\u0003k\fi\r)A\u0005\u0003;\fQ\u0001U8si\u0002B!\"!?\u0002N\n\u0007I\u0011AAn\u0003\u0011I\u0005K\u001e\u001b\t\u0013\u0005u\u0018Q\u001aQ\u0001\n\u0005u\u0017!B%QmR\u0002\u0003B\u0003B\u0001\u0003\u001b\u0014\r\u0011\"\u0001\u0002\\\u0006!\u0011\n\u0015<7\u0011%\u0011)!!4!\u0002\u0013\ti.A\u0003J!Z4\u0004\u0005")
public class ZipkinReporter
implements SpanReporter {
    private final String configPath;
    private final Logger _logger;
    private Endpoint _localEndpoint;
    private AsyncReporter<Span> _reporter;

    private Logger _logger() {
        return this._logger;
    }

    private Endpoint _localEndpoint() {
        return this._localEndpoint;
    }

    private void _localEndpoint_$eq(Endpoint x$1) {
        this._localEndpoint = x$1;
    }

    private AsyncReporter<Span> _reporter() {
        return this._reporter;
    }

    private void _reporter_$eq(AsyncReporter<Span> x$1) {
        this._reporter = x$1;
    }

    public void checkJoinParameter() {
        boolean joinRemoteParentsWithSameID = Kamon$.MODULE$.config().getBoolean("kamon.trace.join-remote-parents-with-same-span-id");
        if (!joinRemoteParentsWithSameID) {
            this._logger().warn("For full Zipkin compatibility enable `kamon.trace.join-remote-parents-with-same-span-id` to preserve span id across client/server sides of a Span.");
        }
    }

    public void reportSpans(Seq<Span.Finished> spans) {
        AsyncReporter<Span> asyncReporter = this._reporter();
        ((IterableLike)spans.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZipkinReporter $outer;

            public final Span apply(Span.Finished kamonSpan) {
                return this.$outer.convertSpan(kamonSpan);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, asyncReporter){
            public static final long serialVersionUID = 0L;
            private final AsyncReporter eta$0$1$1;

            public final void apply(Span x$1) {
                this.eta$0$1$1.report((Object)x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public Span convertSpan(Span.Finished kamonSpan) {
        Endpoint remoteEndpoint;
        long duration = Math.floorDiv(Clock$.MODULE$.nanosBetween(kamonSpan.from(), kamonSpan.to()), 1000L);
        String parentId = kamonSpan.parentId().isEmpty() ? null : kamonSpan.parentId().string();
        Span.Builder builder = Span.newBuilder().localEndpoint(this._localEndpoint()).traceId(kamonSpan.trace().id().string()).id(kamonSpan.id().string()).parentId(parentId).name(kamonSpan.operationName()).timestamp(Clock$.MODULE$.toEpochMicros(kamonSpan.from())).duration(duration);
        Span.Kind kind = this.spanKind(kamonSpan);
        builder.kind(kind);
        Span.Kind kind2 = kind;
        Span.Kind kind3 = Span.Kind.CLIENT;
        Object object = !(kind2 != null ? !kind2.equals(kind3) : kind3 != null) ? (this.hasAnyData(remoteEndpoint = Endpoint.newBuilder().ip(this.getStringTag(kamonSpan, ZipkinReporter$PeerKeys$.MODULE$.IPv4())).ip(this.getStringTag(kamonSpan, ZipkinReporter$PeerKeys$.MODULE$.IPv6())).port((int)this.getLongTag(kamonSpan, ZipkinReporter$PeerKeys$.MODULE$.Port())).build()) ? builder.remoteEndpoint(remoteEndpoint) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        kamonSpan.marks().foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final Span.Builder builder$1;

            public final Span.Builder apply(Span.Mark x0$1) {
                Span.Mark mark = x0$1;
                if (mark != null) {
                    Instant instant = mark.instant();
                    String key = mark.key();
                    Span.Builder builder = this.builder$1.addAnnotation(Clock$.MODULE$.toEpochMicros(instant), key);
                    return builder;
                }
                throw new MatchError((Object)mark);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        this.addTags(kamonSpan.tags(), builder);
        this.addTags(kamonSpan.metricTags(), builder);
        return builder.build();
    }

    private Span.Kind spanKind(Span.Finished span) {
        Span.Kind kind = span.kind();
        Object object = Span.Kind$.Client$.MODULE$.equals(kind) ? Span.Kind.CLIENT : (Span.Kind$.Server$.MODULE$.equals(kind) ? Span.Kind.SERVER : (Span.Kind$.Producer$.MODULE$.equals(kind) ? Span.Kind.PRODUCER : (Span.Kind$.Consumer$.MODULE$.equals(kind) ? Span.Kind.CONSUMER : null)));
        return object;
    }

    private void addTags(TagSet tags, Span.Builder builder) {
        tags.iterator((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x$1) {
                return x$1.toString();
            }
        }).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tag.Pair<String> pair) {
                String string = pair.key();
                String string2 = Span.TagKeys$.MODULE$.Error();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Object object = pair.value();
                String string3 = "false";
                if (object == null) {
                    if (string3 == null) return true;
                    return false;
                } else {
                    if (!object.equals(string3)) return false;
                    return true;
                }
            }
        }).foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final Span.Builder builder$2;

            public final Span.Builder apply(Tag.Pair<String> pair) {
                return this.builder$2.putTag(pair.key(), (String)pair.value());
            }
            {
                this.builder$2 = builder$2;
            }
        });
    }

    private String getStringTag(Span.Finished span, String tagName) {
        return (String)((Option)span.tags().get(Lookups$.MODULE$.option(tagName))).orElse((Function0)new Serializable(this, span, tagName){
            public static final long serialVersionUID = 0L;
            private final Span.Finished span$1;
            private final String tagName$1;

            public final Option<String> apply() {
                return (Option)this.span$1.metricTags().get(Lookups$.MODULE$.option(this.tagName$1));
            }
            {
                this.span$1 = span$1;
                this.tagName$1 = tagName$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    private long getLongTag(Span.Finished span, String tagName) {
        return BoxesRunTime.unboxToLong((Object)((Option)span.tags().get(Lookups$.MODULE$.longOption(tagName))).orElse((Function0)new Serializable(this, span, tagName){
            public static final long serialVersionUID = 0L;
            private final Span.Finished span$2;
            private final String tagName$2;

            public final Option<Object> apply() {
                return (Option)this.span$2.metricTags().get(Lookups$.MODULE$.longOption(this.tagName$2));
            }
            {
                this.span$2 = span$2;
                this.tagName$2 = tagName$2;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    private boolean hasAnyData(Endpoint endpoint) {
        return endpoint.ipv4() != null || endpoint.ipv6() != null || endpoint.port() != null || endpoint.serviceName() != null;
    }

    public void reconfigure(Config newConfig) {
        this._localEndpoint_$eq(this.buildEndpoint());
        this._reporter_$eq(this.buildReporter(newConfig));
        this.checkJoinParameter();
    }

    private Endpoint buildEndpoint() {
        Environment env = Kamon$.MODULE$.environment();
        InetAddress localAddress = (InetAddress)Try$.MODULE$.apply((Function0)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final Environment env$1;

            public final InetAddress apply() {
                return InetAddress.getByName(this.env$1.host());
            }
            {
                this.env$1 = env$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InetAddress apply() {
                return InetAddress.getLocalHost();
            }
        });
        return Endpoint.newBuilder().ip(localAddress).serviceName(env.service()).build();
    }

    private AsyncReporter<Span> buildReporter(Config config) {
        Config zipkinConfig = config.getConfig(this.configPath);
        String fullServerUrl = zipkinConfig.getString("url");
        return AsyncReporter.create((Sender)OkHttpSender.create((String)fullServerUrl));
    }

    public void stop() {
        this._logger().info("Stopped the Zipkin reporter");
    }

    public ZipkinReporter(String configPath) {
        this.configPath = configPath;
        this._logger = LoggerFactory.getLogger(ZipkinReporter.class);
        this._localEndpoint = this.buildEndpoint();
        this._reporter = this.buildReporter(Kamon$.MODULE$.config());
        this.checkJoinParameter();
        this._logger().info("Started the Zipkin reporter");
    }

    public ZipkinReporter() {
        this("kamon.zipkin");
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new ZipkinReporter();
        }
    }
}

