/*
 * Decompiled with CFR 0.152.
 */
package kamon.zipkin;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.time.Instant;
import kamon.Kamon$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.SpanReporter;
import kamon.status.Environment;
import kamon.tag.Lookups$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import kamon.trace.Span;
import kamon.util.Clock$;
import kamon.zipkin.ZipkinReporter$PeerKeys$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0015+\u0001=B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0011\u00199\u0006\u0001)A\u0005\u001f\"9\u0001\f\u0001a\u0001\n\u0013I\u0006b\u00021\u0001\u0001\u0004%I!\u0019\u0005\u0007O\u0002\u0001\u000b\u0015\u0002.\t\u000f!\u0004\u0001\u0019!C\u0005S\"91\u000f\u0001a\u0001\n\u0013!\bB\u0002<\u0001A\u0003&!\u000eC\u0003I\u0001\u0011\u0005q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0003{\u0001\u0011\u00053\u0010\u0003\u0005\u0002$\u0001!\tAKA\u0013\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCa!!+\u0001\t\u0003JxaBAVU!\u0005\u0011Q\u0016\u0004\u0007S)B\t!a,\t\r!KB\u0011AAY\r\u0019\t\u0019,\u0007\u0001\u00026\"1\u0001j\u0007C\u0001\u0003{Cq!a1\u001c\t\u0003\n)mB\u0004\u0002`fAI!!9\u0007\u000f\u0005\r\u0018\u0004#\u0003\u0002f\"1\u0001j\bC\u0001\u0003OD\u0011\"!; \u0005\u0004%\t!a;\t\u0011\u0005mx\u0004)A\u0005\u0003[D\u0011\"!@ \u0005\u0004%\t!a;\t\u0011\u0005}x\u0004)A\u0005\u0003[D\u0011B!\u0001 \u0005\u0004%\t!a;\t\u0011\t\rq\u0004)A\u0005\u0003[D\u0011B!\u0002 \u0005\u0004%\t!a;\t\u0011\t\u001dq\u0004)A\u0005\u0003[\u0014aBW5qW&t'+\u001a9peR,'O\u0003\u0002,Y\u00051!0\u001b9lS:T\u0011!L\u0001\u0006W\u0006lwN\\\u0002\u0001'\r\u0001\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0013AB7pIVdW-\u0003\u0002<q\ta1\u000b]1o%\u0016\u0004xN\u001d;fe\u0006Q1m\u001c8gS\u001e\u0004\u0016\r\u001e5\u0011\u0005y*eBA D!\t\u0001%'D\u0001B\u0015\t\u0011e&\u0001\u0004=e>|GOP\u0005\u0003\tJ\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011AIM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)c\u0005CA&\u0001\u001b\u0005Q\u0003\"\u0002\u001f\u0003\u0001\u0004i\u0014aB0m_\u001e<WM]\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0006g24GG\u001b\u0006\u0002)\u0006\u0019qN]4\n\u0005Y\u000b&A\u0002'pO\u001e,'/\u0001\u0005`Y><w-\u001a:!\u00039yFn\\2bY\u0016sG\r]8j]R,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u00069!0\u001b9lS:\u0014\u0014BA0]\u0005!)e\u000e\u001a9pS:$\u0018AE0m_\u000e\fG.\u00128ea>Lg\u000e^0%KF$\"AY3\u0011\u0005E\u001a\u0017B\u000133\u0005\u0011)f.\u001b;\t\u000f\u00194\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u001f}cwnY1m\u000b:$\u0007o\\5oi\u0002\n\u0011b\u0018:fa>\u0014H/\u001a:\u0016\u0003)\u00042a\u001b8q\u001b\u0005a'BA7]\u0003!\u0011X\r]8si\u0016\u0014\u0018BA8m\u00055\t5/\u001f8d%\u0016\u0004xN\u001d;feB\u00111,]\u0005\u0003er\u0013Aa\u00159b]\u0006iqL]3q_J$XM]0%KF$\"AY;\t\u000f\u0019L\u0011\u0011!a\u0001U\u0006QqL]3q_J$XM\u001d\u0011\u0015\u0003)\u000b!c\u00195fG.Tu.\u001b8QCJ\fW.\u001a;feR\t!-A\u0006sKB|'\u000f^*qC:\u001cHC\u00012}\u0011\u0015iX\u00021\u0001\u007f\u0003\u0015\u0019\b/\u00198t!\u0015y\u0018\u0011BA\b\u001d\u0011\t\t!!\u0002\u000f\u0007\u0001\u000b\u0019!C\u00014\u0013\r\t9AM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\u0007M+\u0017OC\u0002\u0002\bI\u0002B!!\u0005\u0002\u001e9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u00181\nQ\u0001\u001e:bG\u0016LA!a\u0007\u0002\u0016\u0005!1\u000b]1o\u0013\u0011\ty\"!\t\u0003\u0011\u0019Kg.[:iK\u0012TA!a\u0007\u0002\u0016\u0005Y1m\u001c8wKJ$8\u000b]1o)\r\u0001\u0018q\u0005\u0005\b\u0003Sq\u0001\u0019AA\b\u0003%Y\u0017-\\8o'B\fg.\u0001\u0005ta\u0006t7*\u001b8e)\u0011\ty#a\u000f\u0011\t\u0005E\u0012Q\u0007\b\u00047\u0006M\u0012bAA\u000e9&!\u0011qGA\u001d\u0005\u0011Y\u0015N\u001c3\u000b\u0007\u0005mA\fC\u0004\u0002>=\u0001\r!a\u0004\u0002\tM\u0004\u0018M\\\u0001\bC\u0012$G+Y4t)\u0015\u0011\u00171IA*\u0011\u001d\t)\u0005\u0005a\u0001\u0003\u000f\nA\u0001^1hgB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N1\n1\u0001^1h\u0013\u0011\t\t&a\u0013\u0003\rQ\u000bwmU3u\u0011\u001d\t)\u0006\u0005a\u0001\u0003/\nqAY;jY\u0012,'\u000f\u0005\u0003\u00022\u0005e\u0013\u0002BA.\u0003s\u0011qAQ;jY\u0012,'/\u0001\u0007hKR\u001cFO]5oOR\u000bw\rF\u0003>\u0003C\n\u0019\u0007C\u0004\u0002>E\u0001\r!a\u0004\t\r\u0005\u0015\u0014\u00031\u0001>\u0003\u001d!\u0018m\u001a(b[\u0016\f!bZ3u\u0019>tw\rV1h)\u0019\tY'!\u001d\u0002tA\u0019\u0011'!\u001c\n\u0007\u0005=$G\u0001\u0003M_:<\u0007bBA\u001f%\u0001\u0007\u0011q\u0002\u0005\u0007\u0003K\u0012\u0002\u0019A\u001f\u0002\u0015!\f7/\u00118z\t\u0006$\u0018\r\u0006\u0003\u0002z\u0005}\u0004cA\u0019\u0002|%\u0019\u0011Q\u0010\u001a\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011Q\nA\u0002i\u000b\u0001\"\u001a8ea>Lg\u000e^\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\rF\u0002c\u0003\u000fCq!!#\u0015\u0001\u0004\tY)A\u0005oK^\u001cuN\u001c4jOB!\u0011QRAN\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015AB2p]\u001aLwM\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005e\u0015aA2p[&!\u0011QTAH\u0005\u0019\u0019uN\u001c4jO\u0006i!-^5mI\u0016sG\r]8j]R$\u0012AW\u0001\u000eEVLG\u000e\u001a*fa>\u0014H/\u001a:\u0015\u0007)\f9\u000bC\u0004\u0002\u0012Z\u0001\r!a#\u0002\tM$x\u000e]\u0001\u000f5&\u00048.\u001b8SKB|'\u000f^3s!\tY\u0015d\u0005\u0002\u001aaQ\u0011\u0011Q\u0016\u0002\b\r\u0006\u001cGo\u001c:z'\u0011Y\u0002'a.\u0011\u0007]\nI,C\u0002\u0002<b\u0012Q\"T8ek2,g)Y2u_JLHCAA`!\r\t\tmG\u0007\u00023\u000511M]3bi\u0016$B!a2\u0002NB\u0019q'!3\n\u0007\u0005-\u0007H\u0001\u0004N_\u0012,H.\u001a\u0005\b\u0003\u001fl\u0002\u0019AAi\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003BAj\u00033t1aNAk\u0013\r\t9\u000eO\u0001\u000e\u001b>$W\u000f\\3GC\u000e$xN]=\n\t\u0005m\u0017Q\u001c\u0002\t'\u0016$H/\u001b8hg*\u0019\u0011q\u001b\u001d\u0002\u0011A+WM]&fsN\u00042!!1 \u0005!\u0001V-\u001a:LKf\u001c8CA\u00101)\t\t\t/\u0001\u0003I_N$XCAAw!\u0011\ty/!?\u000e\u0005\u0005E(\u0002BAz\u0003k\fA\u0001\\1oO*\u0011\u0011q_\u0001\u0005U\u00064\u0018-C\u0002G\u0003c\fQ\u0001S8ti\u0002\nA\u0001U8si\u0006)\u0001k\u001c:uA\u0005!\u0011\n\u0015<5\u0003\u0015I\u0005K\u001e\u001b!\u0003\u0011I\u0005K\u001e\u001c\u0002\u000b%\u0003fO\u000e\u0011")
public class ZipkinReporter
implements SpanReporter {
    private final String configPath;
    private final Logger _logger;
    private Endpoint _localEndpoint;
    private AsyncReporter<Span> _reporter;

    private Logger _logger() {
        return this._logger;
    }

    private Endpoint _localEndpoint() {
        return this._localEndpoint;
    }

    private void _localEndpoint_$eq(Endpoint x$1) {
        this._localEndpoint = x$1;
    }

    private AsyncReporter<Span> _reporter() {
        return this._reporter;
    }

    private void _reporter_$eq(AsyncReporter<Span> x$1) {
        this._reporter = x$1;
    }

    public void checkJoinParameter() {
        if (!Kamon$.MODULE$.config().getBoolean("kamon.trace.join-remote-parents-with-same-span-id")) {
            this._logger().warn("For full Zipkin compatibility enable `kamon.trace.join-remote-parents-with-same-span-id` to preserve span id across client/server sides of a Span.");
        }
    }

    public void reportSpans(Seq<Span.Finished> spans) {
        ((IterableLike)spans.map((Function1 & Serializable & scala.Serializable)kamonSpan -> this.convertSpan((Span.Finished)kamonSpan), Seq$.MODULE$.canBuildFrom())).foreach(arg_0 -> ZipkinReporter.$anonfun$reportSpans$2$adapted(this._reporter(), arg_0));
    }

    public Span convertSpan(Span.Finished kamonSpan) {
        Endpoint remoteEndpoint;
        long duration = Math.floorDiv(Clock$.MODULE$.nanosBetween(kamonSpan.from(), kamonSpan.to()), 1000L);
        String parentId = kamonSpan.parentId().isEmpty() ? null : kamonSpan.parentId().string();
        Span.Builder builder = Span.newBuilder().localEndpoint(this._localEndpoint()).traceId(kamonSpan.trace().id().string()).id(kamonSpan.id().string()).parentId(parentId).name(kamonSpan.operationName()).timestamp(Clock$.MODULE$.toEpochMicros(kamonSpan.from())).duration(duration);
        Span.Kind kind = this.spanKind(kamonSpan);
        builder.kind(kind);
        Span.Kind kind2 = kind;
        Span.Kind kind3 = Span.Kind.CLIENT;
        if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null) && this.hasAnyData(remoteEndpoint = Endpoint.newBuilder().ip(this.getStringTag(kamonSpan, ZipkinReporter$PeerKeys$.MODULE$.IPv4())).ip(this.getStringTag(kamonSpan, ZipkinReporter$PeerKeys$.MODULE$.IPv6())).port((int)this.getLongTag(kamonSpan, ZipkinReporter$PeerKeys$.MODULE$.Port())).build())) {
            builder.remoteEndpoint(remoteEndpoint);
        }
        kamonSpan.marks().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Instant instant = x0$1.instant();
            String key = x0$1.key();
            Span.Builder builder = builder.addAnnotation(Clock$.MODULE$.toEpochMicros(instant), key);
            return builder;
        });
        this.addTags(kamonSpan.tags(), builder);
        this.addTags(kamonSpan.metricTags(), builder);
        return builder.build();
    }

    private Span.Kind spanKind(Span.Finished span) {
        Span.Kind kind = span.kind();
        Object object = Span.Kind$.Client$.MODULE$.equals(kind) ? Span.Kind.CLIENT : (Span.Kind$.Server$.MODULE$.equals(kind) ? Span.Kind.SERVER : (Span.Kind$.Producer$.MODULE$.equals(kind) ? Span.Kind.PRODUCER : (Span.Kind$.Consumer$.MODULE$.equals(kind) ? Span.Kind.CONSUMER : null)));
        return object;
    }

    private void addTags(TagSet tags, Span.Builder builder) {
        tags.iterator((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).filterNot((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZipkinReporter.$anonfun$addTags$2(pair))).foreach((Function1 & Serializable & scala.Serializable)pair -> builder.putTag(pair.key(), (String)pair.value()));
    }

    private String getStringTag(Span.Finished span, String tagName) {
        return (String)((Option)span.tags().get(Lookups$.MODULE$.option(tagName))).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)span.metricTags().get(Lookups$.MODULE$.option(tagName))).orNull(Predef$.MODULE$.$conforms());
    }

    private long getLongTag(Span.Finished span, String tagName) {
        return BoxesRunTime.unboxToLong((Object)((Option)span.tags().get(Lookups$.MODULE$.longOption(tagName))).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)span.metricTags().get(Lookups$.MODULE$.longOption(tagName))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    private boolean hasAnyData(Endpoint endpoint) {
        return endpoint.ipv4() != null || endpoint.ipv6() != null || endpoint.port() != null || endpoint.serviceName() != null;
    }

    public void reconfigure(Config newConfig) {
        this._localEndpoint_$eq(this.buildEndpoint());
        this._reporter_$eq(this.buildReporter(newConfig));
        this.checkJoinParameter();
    }

    private Endpoint buildEndpoint() {
        Environment env = Kamon$.MODULE$.environment();
        InetAddress localAddress = (InetAddress)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> InetAddress.getByName(env.host())).getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost());
        return Endpoint.newBuilder().ip(localAddress).serviceName(env.service()).build();
    }

    private AsyncReporter<Span> buildReporter(Config config) {
        return AsyncReporter.create((Sender)OkHttpSender.create((String)config.getConfig(this.configPath).getString("url")));
    }

    public void stop() {
        this._logger().info("Stopped the Zipkin reporter");
    }

    public static final /* synthetic */ boolean $anonfun$addTags$2(Tag.Pair pair) {
        String string = pair.key();
        String string2 = Span.TagKeys$.MODULE$.Error();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Object object = pair.value();
            String string3 = "false";
            if (object != null && object.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    public ZipkinReporter(String configPath) {
        this.configPath = configPath;
        this._logger = LoggerFactory.getLogger(ZipkinReporter.class);
        this._localEndpoint = this.buildEndpoint();
        this._reporter = this.buildReporter(Kamon$.MODULE$.config());
        this.checkJoinParameter();
        this._logger().info("Started the Zipkin reporter");
    }

    public ZipkinReporter() {
        this("kamon.zipkin");
    }

    public static final /* synthetic */ Object $anonfun$reportSpans$2$adapted(AsyncReporter eta$0$1$1, Span x$1) {
        eta$0$1$1.report((Object)x$1);
        return BoxedUnit.UNIT;
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new ZipkinReporter();
        }
    }
}

