/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.benchmark;

import java.io.File;
import java.io.IOException;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.agrona.collections.IntHashSet;
import org.apache.commons.math3.random.BitsStreamGenerator;
import org.apache.commons.math3.random.MersenneTwister;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.BenchmarkParams;

@State(value=Scope.Benchmark)
public class Common {
    static final byte[] RND_MB = new byte[0x100000];
    static final int STRING_KEY_LENGTH = 16;
    private static final POSIX POSIX = POSIXFactory.getPOSIX();
    private static final BitsStreamGenerator RND = new MersenneTwister();
    private static final int S_BLKSIZE = 512;
    private static final File TMP_BENCH;
    @Param(value={"true"})
    boolean intKey;
    int keySize;
    int[] keys;
    @Param(value={"1000"})
    int num;
    @Param(value={"true"})
    boolean sequential;
    File tmp;
    @Param(value={"false"})
    boolean valRandom;
    @Param(value={"100"})
    int valSize;

    public void setup(BenchmarkParams b) throws IOException {
        this.keySize = this.intKey ? 4 : 16;
        IntHashSet set = new IntHashSet(this.num);
        this.keys = new int[this.num];
        for (int i = 0; i < this.num; ++i) {
            int candidateKey;
            if (this.sequential) {
                this.keys[i] = i;
                continue;
            }
            do {
                if ((candidateKey = RND.nextInt()) >= 0) continue;
                candidateKey *= -1;
            } while (set.contains(candidateKey));
            set.add(candidateKey);
            this.keys[i] = candidateKey;
        }
        this.rmdir(TMP_BENCH);
        this.tmp = this.create(b, "");
    }

    public void reportSpaceBeforeClose() {
        if (this.tmp.getName().contains(".readKey-")) {
            this.reportSpaceUsed(this.tmp, "before-close");
        }
    }

    public void teardown() throws IOException {
        if (this.tmp.getName().contains(".readKey-")) {
            this.reportSpaceUsed(this.tmp, "after-close");
        }
        this.rmdir(TMP_BENCH);
    }

    protected void reportSpaceUsed(File dir, String desc) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        long bytes = 0L;
        for (File f : files) {
            if (f.isDirectory()) {
                throw new UnsupportedOperationException("impl created directory");
            }
            FileStat stat = POSIX.stat(f.getAbsolutePath());
            bytes += stat.blocks() * 512L;
        }
        System.out.println("\nBytes\t" + desc + "\t" + bytes + "\t" + dir.getName());
    }

    final String padKey(int key) {
        String skey = Integer.toString(key);
        return "0000000000000000".substring(0, 16 - skey.length()) + skey;
    }

    private File create(BenchmarkParams b, String suffix) {
        File f = new File(TMP_BENCH, b.id() + suffix);
        if (!f.mkdirs()) {
            throw new IllegalStateException("Cannot mkdir " + f);
        }
        return f;
    }

    private void rmdir(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.rmdir(f);
            }
        }
        if (!file.delete()) {
            throw new IllegalStateException("Cannot delete " + file);
        }
    }

    static {
        RND.nextBytes(RND_MB);
        String tmpParent = System.getProperty("java.io.tmpdir");
        TMP_BENCH = new File(tmpParent, "lmdbjava-benchmark-scratch");
    }
}

