/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.benchmark;

import io.kcache.CacheType;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import io.kcache.bdbje.BdbJECache;
import io.kcache.benchmark.Common;
import io.kcache.lmdb.LmdbCache;
import io.kcache.mapdb.MapDBCache;
import io.kcache.rocksdb.RocksDBCache;
import io.kcache.utils.PersistentCache;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@BenchmarkMode(value={Mode.SampleTime})
public class PersistentCacheBenchmark {
    @Benchmark
    public void readKey(Reader r, Blackhole bh) {
        for (int key : r.keys) {
            if (r.intKey) {
                r.wkb.putInt(0, key);
            } else {
                r.wkb.putStringWithoutLengthUtf8(0, r.padKey(key));
            }
            bh.consume(r.cache.get((Object)r.wkb.byteArray()));
        }
    }

    @Benchmark
    public void readRev(Reader r, Blackhole bh) {
        try (KeyValueIterator iterator = r.cache.descendingCache().all();){
            while (iterator.hasNext()) {
                KeyValue entry = (KeyValue)iterator.next();
                bh.consume(entry.value);
            }
        }
    }

    @Benchmark
    public void readSeq(Reader r, Blackhole bh) {
        try (KeyValueIterator iterator = r.cache.all();){
            while (iterator.hasNext()) {
                KeyValue entry = (KeyValue)iterator.next();
                bh.consume(entry.value);
            }
        }
    }

    @Benchmark
    public void write(Writer w, Blackhole bh) {
        w.write();
    }

    @State(value=Scope.Benchmark)
    public static class Writer
    extends CommonKafkaCache {
        @Override
        @Setup(value=Level.Invocation)
        public void setup(BenchmarkParams b) throws IOException {
            super.setup(b);
        }

        @Override
        @TearDown(value=Level.Invocation)
        public void teardown() throws IOException {
            super.teardown();
        }
    }

    @State(value=Scope.Benchmark)
    public static class Reader
    extends CommonKafkaCache {
        @Override
        @Setup(value=Level.Trial)
        public void setup(BenchmarkParams b) throws IOException {
            super.setup(b);
            super.write();
        }

        @Override
        @TearDown(value=Level.Trial)
        public void teardown() throws IOException {
            super.teardown();
        }
    }

    @State(value=Scope.Benchmark)
    public static class CommonKafkaCache
    extends Common {
        @Param(value={"bdbje", "lmdb", "mapdb", "rocksdb"})
        String cacheType;
        PersistentCache<byte[], byte[]> cache;
        MutableDirectBuffer wkb;
        MutableDirectBuffer wvb;

        @Override
        public void setup(BenchmarkParams b) throws IOException {
            super.setup(b);
            this.wkb = new UnsafeBuffer(new byte[this.keySize]);
            this.wvb = new UnsafeBuffer(new byte[this.valSize]);
            this.cache = this.createCache(this.cacheType);
            this.cache.init();
        }

        @Override
        public void teardown() throws IOException {
            this.reportSpaceBeforeClose();
            this.cache.close();
            super.teardown();
        }

        void write() {
            int rndByteMax = RND_MB.length - this.valSize;
            int rndByteOffset = 0;
            for (int key : this.keys) {
                if (this.intKey) {
                    this.wkb.putInt(0, key, ByteOrder.LITTLE_ENDIAN);
                } else {
                    this.wkb.putStringWithoutLengthUtf8(0, this.padKey(key));
                }
                if (this.valRandom) {
                    this.wvb.putBytes(0, RND_MB, rndByteOffset, this.valSize);
                    if ((rndByteOffset += this.valSize) >= rndByteMax) {
                        rndByteOffset = 0;
                    }
                } else {
                    this.wvb.putInt(0, key);
                }
                this.cache.put((Object)this.wkb.byteArray(), (Object)this.wvb.byteArray());
            }
            this.cache.flush();
        }

        private PersistentCache<byte[], byte[]> createCache(String cacheType) {
            String name = "default";
            String dataDir = new File("/tmp", cacheType + UUID.randomUUID()).getAbsolutePath();
            Serde serde = Serdes.ByteArray();
            switch (CacheType.get((String)cacheType)) {
                case BDBJE: {
                    return new BdbJECache(name, dataDir, serde, serde, null);
                }
                case LMDB: {
                    return new LmdbCache(name, dataDir, serde, serde, null);
                }
                case MAPDB: {
                    return new MapDBCache(name, dataDir, serde, serde, null);
                }
                case ROCKSDB: {
                    return new RocksDBCache(name, dataDir, serde, serde, null);
                }
            }
            return null;
        }
    }
}

