/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import io.kcache.utils.InMemoryCache;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;

public class CaffeineCache<K, V>
extends InMemoryCache<K, V> {
    private final Cache<K, V> cache;

    public CaffeineCache(Long maximumSize, Duration expireAfterWrite) {
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    public CaffeineCache(Comparator<? super K> comparator, Long maximumSize, Duration expireAfterWrite) {
        super(comparator);
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    public CaffeineCache(NavigableMap<K, V> delegate, Long maximumSize, Duration expireAfterWrite) {
        super(delegate);
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    private Cache<K, V> createCache(Long maximumSize, Duration expireAfterWrite) {
        Caffeine caffeine = Caffeine.newBuilder().writer(new CacheWriter<K, V>(){

            public void write(K key, V value) {
                CaffeineCache.this.delegate().put(key, value);
            }

            public void delete(K key, V value, RemovalCause cause) {
                CaffeineCache.this.delegate().remove(key, value);
            }
        });
        if (maximumSize != null) {
            if (maximumSize <= 0L) {
                throw new IllegalArgumentException("Maximum size of cache must be positive");
            }
            caffeine = caffeine.maximumSize(maximumSize.longValue());
        }
        if (expireAfterWrite != null) {
            caffeine = caffeine.scheduler(Scheduler.systemScheduler()).expireAfterWrite(expireAfterWrite);
        }
        return caffeine.build();
    }

    public V put(K key, V value) {
        Object originalValue = this.get(key);
        this.cache.put(key, value);
        return (V)originalValue;
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.cache.putAll(entries);
    }

    public V remove(Object key) {
        Object originalValue = this.get(key);
        this.cache.invalidate(key);
        return (V)originalValue;
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

