/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum MagicBytes {
    EXE(Header.access$000().add("EXE (includes PE32 + DOS)", 77, 90)),
    MACH_O(Header.access$000().add("MACH-O 32bit", 254, 237, 250, 206).add("MACH-O 64bit", 254, 237, 250, 207)),
    SHEBANG(Header.access$000().add("SHEBANG (#!) script", 35, 33)),
    ELF(Header.access$000().add("ELF", 127, 69, 76, 70)),
    COM(Header.access$000().add("COM", 201)),
    DALVIK(Header.access$000().add("DEX", 100, 101, 120, 10, 48, 51, 53, 0)),
    DMG(Header.access$000().add("DMG", 120, 1, 115, 13, 98, 98, 96)),
    SQLITE(Header.access$000().add("SQLITE3", 83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116, 32, 51, 0)),
    TAR_LZW(Header.access$000().add("TAR LZW", 31, 157).add("TAR LZ", 31, 160)),
    BZIP2(Header.access$000().add("BZ2", 66, 90, 104)),
    LZIP(Header.access$000().add("LZIP", 76, 90, 73, 80)),
    ZIP(Header.access$000().add("ZIP", 80, 75, 3, 4).add("ZIP (empty)", 80, 75, 5, 6).add("ZIP (spanned)", 80, 75, 7, 8)),
    RAR(Header.access$000().add("RAR v1.5+", 82, 97, 114, 33, 26, 7, 0).add("RAR v5+", 82, 97, 114, 33, 26, 7, 1, 0)),
    ISO(Header.access$000().add("ISO9660 CD/DVD Image File", 67, 68, 48, 48, 49)),
    VMDK(Header.access$000().add("VMDK", 75, 68, 77)),
    VDI(Header.access$000().add("VDI (VirtualBox)", 60, 60, 60, 32, 79, 114, 97, 99, 108, 101, 32, 86, 77, 32, 86, 105, 114, 116, 117, 97, 108, 66, 111, 120, 32, 68, 105, 115, 107, 32, 73, 109, 97, 103, 101, 32, 62, 62, 62)),
    VHD(Header.access$000().add("VHD (Win)", 99, 111, 110, 110, 101, 99, 116, 105, 120)),
    VHDX(Header.access$000().add("VHDX (Win8)", 118, 104, 100, 120, 102, 105, 108, 101)),
    ISZ(Header.access$000().add("ISZ (compressed ISO)", 73, 115, 90, 33)),
    EVT(Header.access$000().add("Windows Event Viewer", 76, 102, 76, 101)),
    XAR(Header.access$000().add("eXtensible ARchive", 120, 97, 114, 33)),
    TAR(Header.access$000().add("TAR (subpackage)", 117, 115, 116, 97, 114, 0, 48, 48).add("TAR", 117, 115, 116, 97, 114, 32, 32, 0)),
    SEVEN_ZIP(Header.access$000().add("7Z", 55, 122, 188, 175, 39, 28)),
    GZIP(Header.access$000().add("GZ", 31, 139)),
    MATROSKA(Header.access$000().add("MKV/WebM", 26, 69, 223, 163)),
    DICOM(Header.access$000().add("DICOM", 68, 73, 67, 77)),
    ZLIB(Header.access$000().add("ZLIB (No compression - no preset dictionary)", 120, 1).add("ZLIB (Best speed - no preset dictionary)", 120, 94).add("ZLIB (Default compression - no preset dictionary)", 120, 156).add("ZLIB (Best compression - no preset dictionary)", 120, 218).add("ZLIB (No compression - with preset dictionary)", 120, 32).add("ZLIB (Best speed - with preset dictionary)", 120, 125).add("ZLIB (Default compression - with preset dictionary)", 120, 187).add("ZLIB (Best compression - with preset dictionary)", 120, 249)),
    LZFSE(Header.access$000().add("LZFSE (Apple)", 98, 118, 120, 50)),
    PST(Header.access$000().add("Microsoft Outlook", 33, 66, 68, 78)),
    REG(Header.access$000().add("Windows Registry File/DAT", 114, 101, 103, 102)),
    DAT(Header.access$000().add("DAT/USMT 3+", 80, 77, 79, 67, 67, 77, 79, 67)),
    OFFICE_OLD(Header.access$000().add("Compound File Binary Format (MS-Office)", 208, 207, 17, 224, 161, 177, 26, 225)),
    PDF(Header.access$000().add("PDF", 37, 80, 68, 70, 45)),
    XML(Header.access$000().add("XML", 60, 63, 120, 109, 108, 32)),
    RTT(Header.access$000().add("RTT", 123, 92, 114, 116, 102, 49)),
    PNG(Header.access$000().add("PNG", 137, 80, 78, 71, 13, 10, 26, 10)),
    PBM(Header.access$000().add("PBM", 80, 49, 10)),
    PGM(Header.access$000().add("PGM", 80, 50, 10)),
    PPM(Header.access$000().add("PPM", 80, 51, 10)),
    JPG(Header.access$000().add("JPG Raw", 255, 216, 255, 219).add("JPG Raw 2", 255, 216, 255, 238).add("JPG JFIF", 255, 216, 255, 224, 0, 16, 74, 70, 73, 70, 0, 1).add("JPG EXIF", 255, 216, 255, 225, -1, -1, 69, 120, 105, 102, 0, 0)),
    GIF(Header.access$000().add("GIF87a", 71, 73, 70, 56, 55, 97).add("GIF89a", 71, 73, 70, 56, 57, 97)),
    TIFF(Header.access$000().add("TIFF LE", 73, 73, 42, 0).add("TIFF BE", 77, 77, 0, 42)),
    BMP(Header.access$000().add("BMP", 66, 77)),
    WAV(Header.access$000().add("WAV", 82, 73, 70, 70, -1, -1, -1, -1, 87, 65, 86, 69)),
    MP3(Header.access$000().add("MP3", 73, 68, 51)),
    FLAC(Header.access$000().add("FLAC", 102, 76, 97, 67)),
    MIDI(Header.access$000().add("MIDI", 77, 84, 104, 100)),
    AVI(Header.access$000().add("AVI", 82, 73, 70, 70, -1, -1, -1, -1, 65, 86, 73, 32)),
    MP4(Header.access$000().add("MP4", 0, 0, 0, 24, 102, 116, 121, 112, 105, 115, 111, 109)),
    FLV(Header.access$000().add("FLV", 70, 76, 86));

    private static final int ANY = -1;
    private final Header[] headers;

    private MagicBytes(Header.Builder builder) {
        this.headers = builder.build();
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public Header is(byte[] bytes) {
        for (Header header : this.headers) {
            boolean matches = true;
            for (int i = 0; i < header.bytes.length; ++i) {
                if (header.bytes[i] == -1 || header.bytes[i] == Byte.toUnsignedInt(bytes[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return header;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] extract(InputStream is, int length) throws IOException {
        try {
            byte[] buffer = new byte[length];
            is.read(buffer, 0, length);
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static Header matches(byte[] bytes) {
        for (MagicBytes magic : MagicBytes.values()) {
            Header header = magic.is(bytes);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    public static String getContentType(Header ct) {
        String contentType = ct.getName();
        if (contentType.contains("PNG")) {
            return "png";
        }
        if (contentType.contains("JPG")) {
            return "jpg";
        }
        if (contentType.contains("PDF")) {
            return "pdf";
        }
        if (contentType.contains("XML")) {
            return "xml";
        }
        return "";
    }

    public Header is(String name) throws FileNotFoundException, IOException {
        return this.is(new File(name));
    }

    public Header is(File file) throws FileNotFoundException, IOException {
        return this.is(new FileInputStream(file));
    }

    public Header is(InputStream is) throws IOException {
        return this.is(MagicBytes.extract(is, 50));
    }

    public static Header matching(String name) throws FileNotFoundException, IOException {
        return MagicBytes.matching(new File(name));
    }

    public static Header matching(File file) throws FileNotFoundException, IOException {
        return MagicBytes.matching(new FileInputStream(file));
    }

    public static Header matching(InputStream is) throws IOException {
        return MagicBytes.matches(MagicBytes.extract(is, 50));
    }

    public static final class Header {
        private final String name;
        private final int[] bytes;

        public Header(String name, int[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public String getName() {
            return this.name;
        }

        public int[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return String.format("%s: %s", this.name, Arrays.toString(this.bytes));
        }

        private static Builder builder() {
            return new Builder();
        }

        static /* synthetic */ Builder access$000() {
            return Header.builder();
        }

        private static final class Builder {
            private final List<Header> headers = new ArrayList<Header>();

            private Builder() {
            }

            public Builder add(String name, int ... bytes) {
                this.headers.add(new Header(name, bytes));
                return this;
            }

            public Header[] build() {
                return this.headers.toArray(new Header[0]);
            }
        }
    }
}

