/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.models.executions.metrics.MetricAggregation;
import io.kestra.core.queues.QueueService;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.utils.IdUtils;
import io.kestra.jdbc.JdbcMapper;
import io.kestra.jdbc.JdbcTableConfig;
import io.kestra.jdbc.JooqDSLContextWrapper;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcRepository<T> {
    protected static final ObjectMapper MAPPER = JdbcMapper.of();
    protected final QueueService queueService;
    protected final Class<T> cls;
    protected Function<Record, T> deserializer;
    protected final JooqDSLContextWrapper dslContextWrapper;
    protected Table<Record> table;

    public AbstractJdbcRepository(JdbcTableConfig tableConfig, QueueService queueService, JooqDSLContextWrapper dslContextWrapper) {
        this.cls = tableConfig.cls();
        this.queueService = queueService;
        this.dslContextWrapper = dslContextWrapper;
        this.table = DSL.table((String)tableConfig.table());
    }

    public abstract Condition fullTextCondition(List<String> var1, String var2);

    public String key(T entity) {
        String key = this.queueService.key(entity);
        if (key != null) {
            return key;
        }
        return IdUtils.create();
    }

    public Map<Field<Object>, Object> persistFields(T entity) {
        return new HashMap<Field<Object>, Object>((Map<Field<Object>, Object>)ImmutableMap.of(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value"), (Object)JdbcMapper.of().writeValueAsString(entity)));
    }

    public void persist(T entity) {
        this.persist(entity, null);
    }

    public void persist(T entity, Map<Field<Object>, Object> fields) {
        this.dslContextWrapper.transaction(configuration -> this.persist(entity, DSL.using((Configuration)configuration), fields));
    }

    public void persist(T entity, DSLContext dslContext, Map<Field<Object>, Object> fields) {
        Map<Field<Object>, Object> finalFields = fields == null ? this.persistFields(entity) : fields;
        dslContext.insertInto(this.table).set(io.kestra.jdbc.repository.AbstractJdbcRepository.field("key"), (Object)this.key(entity)).set(finalFields).onDuplicateKeyUpdate().set(finalFields).execute();
    }

    public int delete(T entity) {
        return (Integer)this.dslContextWrapper.transactionResult(configuration -> this.delete(DSL.using((Configuration)configuration), entity));
    }

    public int delete(DSLContext dslContext, T entity) {
        DeleteConditionStep key = dslContext.delete(this.table).where(io.kestra.jdbc.repository.AbstractJdbcRepository.field("key").eq((Object)this.key(entity)));
        return key.execute();
    }

    public <R extends Record> T map(R record) {
        if (this.deserializer != null) {
            return this.deserializer.apply(record);
        }
        return this.deserialize((String)record.get("value", String.class));
    }

    public <R extends Record> MetricAggregation mapMetricAggregation(R record, String groupByType) {
        Instant date = this.getDate(record, groupByType);
        return MetricAggregation.builder().name((String)record.get("metric_name", String.class)).value((Double)record.get("metric_value", Double.class)).date(date).build();
    }

    public <R extends Record> Instant getDate(R record, String groupByType) {
        List<String> fields = Arrays.stream(record.fields()).map(Field::getName).toList();
        Integer minute = fields.contains("minute") ? (Integer)record.get("minute", Integer.class) : Integer.valueOf(0);
        Integer hour = fields.contains("hour") ? (Integer)record.get("hour", Integer.class) : Integer.valueOf(0);
        Integer day = fields.contains("day") ? (Integer)record.get("day", Integer.class) : Integer.valueOf(0);
        Integer week = fields.contains("week") ? (Integer)record.get("week", Integer.class) : Integer.valueOf(0);
        Integer month = fields.contains("month") ? (Integer)record.get("month", Integer.class) : Integer.valueOf(0);
        Integer year = fields.contains("year") ? (Integer)record.get("year", Integer.class) : Integer.valueOf(0);
        switch (groupByType) {
            case "minute": {
                return ZonedDateTime.of(year, month, day, hour, minute, 0, 0, TimeZone.getDefault().toZoneId()).toInstant();
            }
            case "hour": {
                return ZonedDateTime.of(year, month, day, hour, 0, 0, 0, TimeZone.getDefault().toZoneId()).toInstant();
            }
            case "day": {
                return ZonedDateTime.of(year, month, day, 0, 0, 0, 0, TimeZone.getDefault().toZoneId()).toInstant();
            }
            case "week": {
                LocalDate weekDate = LocalDate.ofYearDay(year, week * 7);
                return weekDate.atStartOfDay().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).toInstant(ZonedDateTime.now().getOffset());
            }
            case "month": {
                return ZonedDateTime.of(year, month, 1, 0, 0, 0, 0, TimeZone.getDefault().toZoneId()).toInstant();
            }
        }
        throw new IllegalArgumentException("Invalid groupByType: " + groupByType);
    }

    public T deserialize(String record) {
        try {
            return (T)MAPPER.readValue(record, this.cls);
        }
        catch (IOException e) {
            throw new DeserializationException(e, record);
        }
    }

    public <R extends Record> Optional<T> fetchOne(Select<R> select) {
        return Optional.ofNullable(select.fetchAny()).map(this::map);
    }

    public <R extends Record> List<T> fetch(Select<R> select) {
        return select.fetch().map(this::map);
    }

    public List<MetricAggregation> fetchMetricStat(Select<Record> select, String groupByType) {
        return select.fetch().map(e -> this.mapMetricAggregation(e, groupByType));
    }

    public abstract <R extends Record, E> ArrayListTotal<E> fetchPage(DSLContext var1, SelectConditionStep<R> var2, Pageable var3, RecordMapper<R, E> var4);

    public <R extends Record> ArrayListTotal<T> fetchPage(DSLContext context, SelectConditionStep<R> select, Pageable pageable) {
        return this.fetchPage(context, select, pageable, this::map);
    }

    public List<String> fragments(String query, String yaml) {
        List<String> split = Arrays.asList(StringUtils.split((String)yaml, (String)"\n"));
        int first = IntStream.range(0, split.size()).filter(index -> StringUtils.indexOfIgnoreCase((CharSequence)((CharSequence)split.get(index)), (CharSequence)query) >= 0).findFirst().orElse(0);
        int min = Math.max(0, first - 1);
        int max = Math.min(split.size(), min + 4);
        List fragments = split.subList(min, max).stream().map(r -> {
            int i = StringUtils.indexOfIgnoreCase((CharSequence)r, (CharSequence)query);
            if (i < 0) {
                return r;
            }
            return r.substring(0, i) + "[mark]" + r.substring(i, i + query.length()) + "[/mark]" + r.substring(i + query.length());
        }).collect(Collectors.toList());
        return Collections.singletonList(String.join((CharSequence)"\n", fragments));
    }

    protected <R extends Record> SelectConditionStep<R> sort(SelectConditionStep<R> select, Pageable pageable) {
        if (pageable != null && pageable.getSort().isSorted()) {
            pageable.getSort().getOrderBy().forEach(order -> {
                Field<Object> field = io.kestra.jdbc.repository.AbstractJdbcRepository.field(order.getProperty());
                select.orderBy((OrderField)(order.getDirection() == Sort.Order.Direction.ASC ? field.asc() : field.desc()));
            });
        }
        return select;
    }

    protected <R extends Record> Select<R> limit(SelectConditionStep<R> select, Pageable pageable) {
        if (pageable == null || pageable.getSize() == -1) {
            return select;
        }
        return select.limit((Number)pageable.getSize()).offset((Number)(pageable.getOffset() - (long)pageable.getSize()));
    }

    protected <R extends Record> Select<R> pageable(SelectConditionStep<R> select, Pageable pageable) {
        select = this.sort(select, pageable);
        return this.limit(select, pageable);
    }

    public Field<Integer> weekFromTimestamp(Field<Timestamp> timestampField) {
        return DSL.week(timestampField);
    }

    @Generated
    public void setDeserializer(Function<Record, T> deserializer) {
        this.deserializer = deserializer;
    }

    @Generated
    public JooqDSLContextWrapper getDslContextWrapper() {
        return this.dslContextWrapper;
    }

    @Generated
    public Table<Record> getTable() {
        return this.table;
    }
}

