/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc;

import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Random;
import io.kestra.core.utils.RetryUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Predicate;
import org.jooq.DSLContext;
import org.jooq.TransactionalCallable;
import org.jooq.TransactionalRunnable;

@Singleton
public class JooqDSLContextWrapper {
    private final DSLContext dslContext;
    private final RetryUtils retryUtils;

    @Inject
    public JooqDSLContextWrapper(DSLContext dslContext, RetryUtils retryUtils) {
        this.dslContext = dslContext;
        this.retryUtils = retryUtils;
    }

    private <T> RetryUtils.Instance<T, RuntimeException> retryer() {
        return this.retryUtils.of((AbstractRetry)((Random.RandomBuilder)((Random.RandomBuilder)Random.builder().minInterval(Duration.ofMillis(50L)).maxAttempt(Integer.valueOf(-1))).maxDuration(Duration.ofSeconds(60L))).maxInterval(Duration.ofMillis(1000L)).build());
    }

    private static <E extends Throwable> Predicate<E> predicate() {
        return e -> {
            if (!(e.getCause() instanceof SQLException)) {
                return false;
            }
            SQLException cause = (SQLException)e.getCause();
            return cause.getSQLState().equals("40001") || cause.getSQLState().equals("40P01");
        };
    }

    public void transaction(TransactionalRunnable transactional) {
        this.retryer().runRetryIf(JooqDSLContextWrapper.predicate(), () -> {
            this.dslContext.transaction(transactional);
            return null;
        });
    }

    public <T> T transactionResult(TransactionalCallable<T> transactional) {
        return (T)this.retryer().runRetryIf(JooqDSLContextWrapper.predicate(), () -> this.dslContext.transactionResult(transactional));
    }
}

