/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.models.SearchResult;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.FlowService;
import io.kestra.jdbc.JdbcMapper;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.repository.JdbcFlowRepositoryService;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.data.model.Pageable;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcFlowRepository
extends AbstractJdbcRepository
implements FlowRepositoryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcFlowRepository.class);
    private final QueueInterface<Flow> flowQueue;
    private final QueueInterface<Trigger> triggerQueue;
    private final ApplicationEventPublisher<CrudEvent<Flow>> eventPublisher;
    private final ModelValidator modelValidator;
    protected io.kestra.jdbc.AbstractJdbcRepository<Flow> jdbcRepository;

    public AbstractJdbcFlowRepository(io.kestra.jdbc.AbstractJdbcRepository<Flow> jdbcRepository, ApplicationContext applicationContext) {
        this.jdbcRepository = jdbcRepository;
        this.modelValidator = (ModelValidator)applicationContext.getBean(ModelValidator.class);
        this.eventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.triggerQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        this.flowQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"flowQueue"));
        this.jdbcRepository.setDeserializer(record -> {
            String source = (String)record.get("value", String.class);
            try {
                Flow deserialize = this.jdbcRepository.deserialize(source);
                deserialize.allTasksWithChilds();
                return deserialize;
            }
            catch (DeserializationException e) {
                try {
                    JsonNode jsonNode = JdbcMapper.of().readTree(source);
                    return (Flow)FlowWithException.from((JsonNode)jsonNode, (Exception)((Object)e)).orElseThrow(() -> e);
                }
                catch (JsonProcessingException ex) {
                    throw new DeserializationException((IOException)((Object)ex), source);
                }
            }
        });
    }

    public Optional<Flow> findById(String tenantId, String namespace, String id, Optional<Integer> revision, Boolean allowDeleted) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep from = revision.isPresent() ? context.select(AbstractJdbcFlowRepository.field("value", String.class)).from(this.jdbcRepository.getTable()).where(this.revisionDefaultFilter(tenantId)).and(AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).and(AbstractJdbcFlowRepository.field("revision", Integer.class).eq((Object)((Integer)revision.get()))) : context.select(AbstractJdbcFlowRepository.field("value", String.class)).from(this.fromLastRevision(true)).where(allowDeleted != false ? this.revisionDefaultFilter(tenantId) : this.defaultFilter(tenantId)).and(AbstractJdbcFlowRepository.field("namespace", String.class).eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id));
            return this.jdbcRepository.fetchOne(from);
        });
    }

    protected Table<Record> fromLastRevision(boolean asterisk) {
        return JdbcFlowRepositoryService.lastRevision(this.jdbcRepository, asterisk);
    }

    protected Condition revisionDefaultFilter(String tenantId) {
        return this.buildTenantCondition(tenantId);
    }

    public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id, Optional<Integer> revision, Boolean allowDeleted) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Select from = (Select)revision.map(integer -> context.select(AbstractJdbcFlowRepository.field("source_code", String.class), AbstractJdbcFlowRepository.field("value", String.class)).from(this.jdbcRepository.getTable()).where(this.revisionDefaultFilter(tenantId)).and(AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).and(AbstractJdbcFlowRepository.field("revision", Integer.class).eq(integer))).orElseGet(() -> context.select(AbstractJdbcFlowRepository.field("source_code", String.class), AbstractJdbcFlowRepository.field("value", String.class)).from(this.fromLastRevision(true)).where(allowDeleted != false ? this.revisionDefaultFilter(tenantId) : this.defaultFilter(tenantId)).and(AbstractJdbcFlowRepository.field("namespace", String.class).eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)));
            Record2 fetched = (Record2)from.fetchAny();
            if (fetched == null) {
                return Optional.empty();
            }
            Flow flow = this.jdbcRepository.map(fetched);
            String source = (String)fetched.get("source_code", String.class);
            if (flow instanceof FlowWithException) {
                FlowWithException fwe = (FlowWithException)flow;
                return Optional.of(((FlowWithException.FlowWithExceptionBuilder)fwe.toBuilder().source(source)).build());
            }
            return Optional.of(FlowWithSource.of((Flow)flow, (String)source));
        });
    }

    public List<FlowWithSource> findRevisions(String tenantId, String namespace, String id) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectSeekStep1 select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("source_code", String.class), AbstractJdbcFlowRepository.field("value", String.class)).from(this.jdbcRepository.getTable()).where(this.revisionDefaultFilter(tenantId)).and(AbstractJdbcFlowRepository.field("namespace", String.class).eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).orderBy((OrderField)AbstractJdbcFlowRepository.field("revision", Integer.class).asc());
            return select.fetch().map(record -> FlowWithSource.of((Flow)this.jdbcRepository.map(record), (String)((String)record.get("source_code", String.class))));
        });
    }

    public List<Flow> findAll(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value")).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Flow> findAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value")).from(this.fromLastRevision(true)).where(this.defaultFilter());
            ArrayList flows = new ArrayList();
            select.fetch().forEach(item -> {
                try {
                    Flow flow = this.jdbcRepository.map(item);
                    flows.add(flow);
                }
                catch (Exception e) {
                    log.error("Unable to load the following flow:\n{}", item.get("value", String.class), (Object)e);
                }
            });
            return flows;
        });
    }

    public List<Flow> findByNamespace(String tenantId, String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value")).from(this.fromLastRevision(true)).where(AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace)).and(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<FlowWithSource> findByNamespaceWithSource(String tenantId, String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("source_code", String.class), AbstractJdbcFlowRepository.field("value", String.class)).from(this.fromLastRevision(true)).where(AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace)).and(this.defaultFilter(tenantId));
            return select.fetch().map(record -> FlowWithSource.of((Flow)this.jdbcRepository.map(record), (String)((String)record.get("source_code", String.class))));
        });
    }

    private <R extends Record, E> SelectConditionStep<R> fullTextSelect(String tenantId, DSLContext context, List<Field<Object>> field) {
        ArrayList<Field<Object>> fields = new ArrayList<Field<Object>>(Collections.singletonList(AbstractJdbcFlowRepository.field("value")));
        if (field != null) {
            fields.addAll(field);
        }
        return context.select(fields).hint(context.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.fromLastRevision(false)).join((TableLike)this.jdbcRepository.getTable().as("ft")).on(DSL.field((Name)DSL.quotedName((String[])new String[]{"ft", "key"})).eq(DSL.field((SelectField)DSL.field((Name)DSL.quotedName((String[])new String[]{"rev", "key"})))).and(DSL.field((Name)DSL.quotedName((String[])new String[]{"ft", "revision"})).eq(DSL.field((Name)DSL.quotedName((String[])new String[]{"rev", "revision"}))))).where(this.defaultFilter(tenantId));
    }

    protected abstract Condition findCondition(String var1, Map<String, String> var2);

    public ArrayListTotal<Flow> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable Map<String, String> labels) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = this.fullTextSelect(tenantId, context, Collections.emptyList());
            select.and(this.findCondition(query, labels));
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcFlowRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public List<FlowWithSource> findWithSource(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable Map<String, String> labels) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            List<Field<Object>> fields = List.of(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("source_code"));
            SelectConditionStep select = this.fullTextSelect(tenantId, context, fields);
            select.and(this.findCondition(query, labels));
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcFlowRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            return select.fetch().map(record -> FlowWithSource.of((Flow)this.jdbcRepository.map(record), (String)((String)record.get("source_code", String.class))));
        });
    }

    protected abstract Condition findSourceCodeCondition(String var1);

    public ArrayListTotal<SearchResult<Flow>> findSourceCode(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = this.fullTextSelect(tenantId, context, Collections.singletonList(AbstractJdbcFlowRepository.field("source_code")));
            if (query != null) {
                select.and(this.findSourceCodeCondition(query));
            }
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcFlowRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable, record -> new SearchResult((Object)this.jdbcRepository.map(record), this.jdbcRepository.fragments(query, (String)record.getValue("source_code", String.class))));
        });
    }

    public FlowWithSource create(Flow flow, String flowSource, Flow flowWithDefaults) throws ConstraintViolationException {
        if (this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId()).isPresent()) {
            throw new ConstraintViolationException(Collections.singleton(ManualConstraintViolation.of((String)"Flow id already exists", (Object)flow, Flow.class, (String)"flow.id", (Object)flow.getId())));
        }
        this.modelValidator.validate((Object)flowWithDefaults);
        return this.save(flow, CrudEventType.CREATE, flowSource);
    }

    public FlowWithSource update(Flow flow, Flow previous, String flowSource, Flow flowWithDefaults) throws ConstraintViolationException {
        this.modelValidator.validate((Object)flowWithDefaults);
        Optional checkUpdate = previous.validateUpdate(flowWithDefaults);
        if (checkUpdate.isPresent()) {
            throw (ConstraintViolationException)checkUpdate.get();
        }
        FlowService.findRemovedTrigger((Flow)flow, (Flow)previous).forEach(abstractTrigger -> this.triggerQueue.delete((Object)Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger)));
        return this.save(flow, CrudEventType.UPDATE, flowSource);
    }

    private FlowWithSource save(Flow flow, CrudEventType crudEventType, String flowSource) throws ConstraintViolationException {
        Optional exists;
        if (flow instanceof FlowWithSource) {
            flow = ((FlowWithSource)flow).toFlow();
        }
        if ((exists = this.findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId())).isPresent() && ((FlowWithSource)exists.get()).isUpdatable(flow, flowSource)) {
            return (FlowWithSource)exists.get();
        }
        List<FlowWithSource> revisions = this.findRevisions(flow.getTenantId(), flow.getNamespace(), flow.getId());
        flow = !revisions.isEmpty() ? flow.toBuilder().revision(Integer.valueOf(revisions.get(revisions.size() - 1).getRevision() + 1)).build() : flow.toBuilder().revision(Integer.valueOf(1)).build();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(flow);
        fields.put(AbstractJdbcFlowRepository.field("source_code"), flowSource);
        this.jdbcRepository.persist(flow, fields);
        this.flowQueue.emit((Object)flow);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, crudEventType));
        return FlowWithSource.of((Flow)flow, (String)flowSource);
    }

    public Flow delete(Flow flow) {
        Optional revision;
        if (flow instanceof FlowWithSource) {
            flow = ((FlowWithSource)flow).toFlow();
        }
        if ((revision = this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId(), Optional.of(flow.getRevision()))).isEmpty()) {
            throw new IllegalStateException("Flow " + flow.getId() + " doesn't exists");
        }
        Optional last = this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId());
        if (last.isEmpty()) {
            throw new IllegalStateException("Flow " + flow.getId() + " doesn't exists");
        }
        if (!((Flow)last.get()).getRevision().equals(((Flow)revision.get()).getRevision())) {
            throw new IllegalStateException("Trying to deleted old revision, wanted " + ((Flow)revision.get()).getRevision() + ", last revision is " + ((Flow)last.get()).getRevision());
        }
        Flow deleted = flow.toDeleted();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(deleted);
        fields.put(AbstractJdbcFlowRepository.field("source_code"), JacksonMapper.ofYaml().writeValueAsString((Object)deleted));
        this.jdbcRepository.persist(deleted, fields);
        this.flowQueue.emit((Object)deleted);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, CrudEventType.DELETE));
        return deleted;
    }

    public List<String> findDistinctNamespace(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("namespace")).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId)).groupBy(new GroupField[]{AbstractJdbcFlowRepository.field("namespace")}).fetch().map(record -> (String)record.getValue("namespace", String.class)));
    }

    public Integer lastRevision(String tenantId, String namespace, String id) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> (Integer)DSL.using((Configuration)configuration).fetchValue((ResultQuery)DSL.select(AbstractJdbcFlowRepository.field("revision", Integer.class)).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId)).and(AbstractJdbcFlowRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).limit((Number)1)));
    }
}

