/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.statistics.LogStatistics;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.SelectHavingStep;
import org.jooq.SortOrder;
import org.jooq.impl.DSL;
import org.slf4j.event.Level;

@Singleton
public abstract class AbstractJdbcLogRepository
extends AbstractJdbcRepository
implements LogRepositoryInterface,
JdbcIndexerInterface<LogEntry> {
    protected io.kestra.jdbc.AbstractJdbcRepository<LogEntry> jdbcRepository;

    public AbstractJdbcLogRepository(io.kestra.jdbc.AbstractJdbcRepository<LogEntry> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    protected abstract Condition findCondition(String var1);

    public ArrayListTotal<LogEntry> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).hint(configuration.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            this.filter(select, query, namespace, flowId, minLevel, startDate, endDate);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private <T extends Record> SelectConditionStep<T> filter(SelectConditionStep<T> select, @Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        if (namespace != null) {
            select.and(DSL.or((Condition)AbstractJdbcLogRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcLogRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
        }
        if (flowId != null) {
            select.and(AbstractJdbcLogRepository.field("flow_id").eq((Object)flowId));
        }
        if (minLevel != null) {
            select = select.and(this.minLevel(minLevel));
        }
        if (query != null) {
            select = select.and(this.findCondition(query));
        }
        if (startDate != null) {
            select = select.and(AbstractJdbcLogRepository.field("timestamp").greaterOrEqual((Object)startDate.toOffsetDateTime()));
        }
        if (endDate != null) {
            select = select.and(AbstractJdbcLogRepository.field("timestamp").lessOrEqual((Object)endDate.toOffsetDateTime()));
        }
        return select;
    }

    public List<LogStatistics> statistics(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy) {
        ZonedDateTime finalStartDate = startDate == null ? ZonedDateTime.now().minusDays(30L) : startDate;
        ZonedDateTime finalEndDate = endDate == null ? ZonedDateTime.now() : endDate;
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(finalStartDate, finalEndDate));
        List<Field<String>> fields = List.of(AbstractJdbcLogRepository.field("level", String.class));
        ArrayList dateFields = new ArrayList(this.groupByFields(Duration.between(finalStartDate, finalEndDate), "timestamp", groupBy));
        ArrayList<Field<String>> selectFields = new ArrayList<Field<String>>(fields);
        selectFields.addAll(List.of(DSL.count().as("count")));
        selectFields.addAll(dateFields);
        return ((List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select((Collection)selectFields).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            this.filter(select, query, namespace, flowId, minLevel, startDate, endDate);
            ArrayList groupFields = new ArrayList(fields);
            groupFields.addAll(dateFields);
            SelectHavingStep finalQuery = select.groupBy(groupFields);
            List result = finalQuery.fetch().map(record -> {
                Instant date = this.jdbcRepository.getDate(record, groupByType.val());
                LogStatistics base = LogStatistics.builder().timestamp(date).groupBy(groupByType.val()).build();
                HashMap<Level, Long> counts = new HashMap<Level, Long>(base.getCounts());
                counts.put((Level)record.get("level", Level.class), (Long)record.get("count", Long.class));
                return base.toBuilder().counts(counts).build();
            });
            return this.fillDate(result, finalStartDate, finalEndDate);
        })).stream().sorted(Comparator.comparing(LogStatistics::getTimestamp)).toList();
    }

    private List<LogStatistics> fillDate(List<LogStatistics> result, ZonedDateTime startDate, ZonedDateTime endDate) {
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        if (groupByType.equals((Object)DateUtils.GroupType.MONTH)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.MONTHS, "YYYY-MM");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.WEEK)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.WEEKS, "YYYY-ww");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.DAY)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.DAYS, "YYYY-MM-DD");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.HOUR)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.HOURS, "YYYY-MM-DD HH");
        }
        return this.fillDate(result, startDate, endDate, ChronoUnit.MINUTES, "YYYY-MM-DD HH:mm");
    }

    private List<LogStatistics> fillDate(List<LogStatistics> result, ZonedDateTime startDate, ZonedDateTime endDate, ChronoUnit unit, String format) {
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        ArrayList<LogStatistics> filledResult = new ArrayList<LogStatistics>();
        ZonedDateTime currentDate = startDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        while (currentDate.isBefore(endDate)) {
            String finalCurrentDate = currentDate.format(formatter);
            LogStatistics current = result.stream().filter(metric -> formatter.format(metric.getTimestamp()).equals(finalCurrentDate)).collect(Collectors.groupingBy(LogStatistics::getTimestamp)).values().stream().map(logStatistics -> {
                Map<Level, Long> collect = logStatistics.stream().map(LogStatistics::getCounts).flatMap(levelLongMap -> levelLongMap.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingLong(Map.Entry::getValue)));
                return ((LogStatistics)logStatistics.get(0)).toBuilder().counts(collect).build();
            }).findFirst().orElse(LogStatistics.builder().timestamp(currentDate.toInstant()).groupBy(groupByType.val()).build());
            filledResult.add(current);
            currentDate = currentDate.plus(1L, unit);
        }
        return filledResult;
    }

    public List<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)).and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt)), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)).and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt)), minLevel, pageable);
    }

    public LogEntry save(LogEntry log) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(log);
        this.jdbcRepository.persist(log, fields);
        return log;
    }

    public Integer purge(Execution execution) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcLogRepository.field("execution_id", String.class).eq((Object)execution.getId())).execute();
        });
    }

    @Override
    public LogEntry save(DSLContext dslContext, LogEntry logEntry) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(logEntry);
        this.jdbcRepository.persist(logEntry, dslContext, fields);
        return logEntry;
    }

    public void deleteByQuery(String tenantId, String executionId, String taskId, String taskRunId, Level minLevel, Integer attempt) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            DeleteConditionStep delete = context.delete(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId));
            if (taskId != null) {
                delete.and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId));
            }
            if (taskRunId != null) {
                delete.and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId));
            }
            if (minLevel != null) {
                delete.and(this.minLevel(minLevel));
            }
            if (attempt != null) {
                delete.and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt));
            }
            delete.execute();
        });
    }

    private ArrayListTotal<LogEntry> query(String tenantId, Condition condition, Level minLevel, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).hint(configuration.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (minLevel != null) {
                select.and(this.minLevel(minLevel));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private List<LogEntry> query(String tenantId, Condition condition, Level minLevel) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (minLevel != null) {
                select.and(this.minLevel(minLevel));
            }
            return this.jdbcRepository.fetch(select.orderBy((OrderField)AbstractJdbcLogRepository.field("timestamp").sort(SortOrder.ASC)));
        });
    }

    protected Condition minLevel(Level minLevel) {
        return AbstractJdbcLogRepository.field("level").in((Collection)LogEntry.findLevelsByMin((Level)minLevel));
    }
}

