/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ServiceInstanceRepositoryInterface;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceStateTransition;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TransactionalCallable;
import org.jooq.TransactionalRunnable;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class AbstractJdbcServiceInstanceRepository
extends AbstractJdbcRepository
implements ServiceInstanceRepositoryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcServiceInstanceRepository.class);
    private static final Field<Object> STATE = AbstractJdbcServiceInstanceRepository.field("state");
    private static final Field<Object> TYPE = AbstractJdbcServiceInstanceRepository.field("type");
    private static final Field<Object> VALUE = AbstractJdbcServiceInstanceRepository.field("value");
    private static final Field<Instant> UPDATED_AT = AbstractJdbcServiceInstanceRepository.field("updated_at", Instant.class);
    private static final Field<Instant> CREATED_AT = AbstractJdbcServiceInstanceRepository.field("created_at", Instant.class);
    private static final Field<Object> SERVICE_ID = AbstractJdbcServiceInstanceRepository.field("service_id");
    protected io.kestra.jdbc.AbstractJdbcRepository<ServiceInstance> jdbcRepository;

    public AbstractJdbcServiceInstanceRepository(io.kestra.jdbc.AbstractJdbcRepository<ServiceInstance> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<ServiceInstance> findById(String id) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.findById(id, configuration, false));
    }

    public Optional<ServiceInstance> findById(String id, Configuration configuration, boolean isForUpdate) {
        SelectConditionStep query = DSL.using((Configuration)configuration).select(VALUE).from(this.table()).where(SERVICE_ID.eq((Object)id));
        return isForUpdate ? this.jdbcRepository.fetchOne(query.forUpdate()) : this.jdbcRepository.fetchOne(query);
    }

    public List<ServiceInstance> findAllInstancesInState(Service.ServiceState state) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep query = DSL.using((Configuration)configuration).select(VALUE).from(this.table()).where(STATE.eq((Object)state.name()));
            return this.jdbcRepository.fetch(query);
        });
    }

    public List<ServiceInstance> findAllInstancesInStates(Set<Service.ServiceState> states) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.findAllInstancesInStates(configuration, states, false));
    }

    public List<ServiceInstance> findAllInstancesInStates(Configuration configuration, Set<Service.ServiceState> states, boolean isForUpdate) {
        SelectConditionStep query = DSL.using((Configuration)configuration).select(VALUE).from(this.table()).where(STATE.in(states.stream().map(Enum::name).toList()));
        return isForUpdate ? this.jdbcRepository.fetch(query.forUpdate()) : this.jdbcRepository.fetch(query);
    }

    public List<ServiceInstance> findAllNonRunningInstances() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.findAllNonRunningInstances(configuration, false));
    }

    public List<ServiceInstance> findAllNonRunningInstances(Configuration configuration, boolean isForUpdate) {
        SelectConditionStep query = DSL.using((Configuration)configuration).select(VALUE).from(this.table()).where(STATE.notIn(new Object[]{Service.ServiceState.CREATED.name(), Service.ServiceState.RUNNING.name()}));
        return isForUpdate ? this.jdbcRepository.fetch(query.forUpdate()) : this.jdbcRepository.fetch(query);
    }

    public List<ServiceInstance> findAllInstancesInNotRunningState() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.findAllInstancesInNotRunningState(configuration, false));
    }

    public List<ServiceInstance> findAllInstancesInNotRunningState(Configuration configuration, boolean isForUpdate) {
        SelectConditionStep query = DSL.using((Configuration)configuration).select(VALUE).from(this.table()).where(STATE.eq((Object)Service.ServiceState.NOT_RUNNING.name()));
        return isForUpdate ? this.jdbcRepository.fetch(query.forUpdate()) : this.jdbcRepository.fetch(query);
    }

    public void transaction(TransactionalRunnable runnable) {
        this.jdbcRepository.getDslContextWrapper().transaction(runnable);
    }

    public <T> T transactionResult(TransactionalCallable<T> runnable) {
        return this.jdbcRepository.getDslContextWrapper().transactionResult(runnable);
    }

    public void delete(DSLContext context, ServiceInstance instance) {
        this.jdbcRepository.delete(context, instance);
    }

    public void delete(ServiceInstance instance) {
        this.jdbcRepository.delete(instance);
    }

    public ServiceInstance save(ServiceInstance instance) {
        this.jdbcRepository.persist(instance, this.jdbcRepository.persistFields(instance));
        return instance;
    }

    public List<ServiceInstance> findAll() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.jdbcRepository.fetch(DSL.using((Configuration)configuration).select(VALUE).from(this.table())));
    }

    public ArrayListTotal<ServiceInstance> find(Pageable pageable, Set<Service.ServiceState> states, Set<Service.ServiceType> types) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(VALUE).from(this.table()).where("1=1");
            if (states != null && !states.isEmpty()) {
                select = select.and(STATE.in((Collection)states.stream().map(Enum::name).collect(Collectors.toList())));
            }
            if (types != null && !types.isEmpty()) {
                select = select.and(TYPE.in((Collection)types.stream().map(Enum::name).collect(Collectors.toList())));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public ServiceStateTransition.Response mayTransitionServiceTo(ServiceInstance instance, Service.ServiceState newState, String reason) {
        return (ServiceStateTransition.Response)this.transactionResult(configuration -> this.mayTransitServiceTo(configuration, instance, newState, reason));
    }

    public ServiceStateTransition.Response mayTransitServiceTo(Configuration configuration, ServiceInstance instance, Service.ServiceState newState, String reason) {
        ImmutablePair<ServiceInstance, ServiceInstance> result = this.mayUpdateStatusById(configuration, instance, newState, reason);
        return ServiceStateTransition.logTransitionAndGetResponse((ServiceInstance)instance, (Service.ServiceState)newState, result);
    }

    private ImmutablePair<ServiceInstance, ServiceInstance> mayUpdateStatusById(Configuration configuration, ServiceInstance instance, Service.ServiceState newState, String reason) {
        Optional<ServiceInstance> optional = this.findById(instance.id(), configuration, true);
        if (optional.isEmpty()) {
            return null;
        }
        ServiceInstance before = optional.get();
        if (before.state().isValidTransition(newState)) {
            ServiceInstance updated = before.state(newState, Instant.now(), reason).server(instance.server()).metrics(instance.metrics());
            return new ImmutablePair((Object)before, (Object)this.save(updated));
        }
        return new ImmutablePair((Object)before, null);
    }

    private Table<Record> table() {
        return this.jdbcRepository.getTable();
    }

    public Function<String, String> sortMapping() {
        Map<String, String> mapper = Map.of("createdAt", CREATED_AT.getName(), "updatedAt", UPDATED_AT.getName(), "serviceId", SERVICE_ID.getName());
        return mapper::get;
    }

    @Generated
    public io.kestra.jdbc.AbstractJdbcRepository<ServiceInstance> getJdbcRepository() {
        return this.jdbcRepository;
    }
}

