/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.schedulers.ScheduleContextInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.kestra.jdbc.runner.JdbcSchedulerContext;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcTriggerRepository
extends AbstractJdbcRepository
implements TriggerRepositoryInterface,
JdbcIndexerInterface<Trigger> {
    protected io.kestra.jdbc.AbstractJdbcRepository<Trigger> jdbcRepository;

    public AbstractJdbcTriggerRepository(io.kestra.jdbc.AbstractJdbcRepository<Trigger> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<Trigger> findLast(TriggerContext trigger) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)trigger.uid()));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public Optional<Trigger> findByExecution(Execution execution) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("execution_id").eq((Object)execution.getId()));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public List<Trigger> findAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectJoinStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable());
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Trigger> findByNextExecutionDateReadyForAllTenants(ZonedDateTime now, ScheduleContextInterface scheduleContextInterface) {
        JdbcSchedulerContext jdbcSchedulerContext = (JdbcSchedulerContext)scheduleContextInterface;
        return jdbcSchedulerContext.getContext().select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("next_execution_date").lessThan((Object)now.toOffsetDateTime()).or(AbstractJdbcTriggerRepository.field("next_execution_date").isNull())).orderBy((OrderField)AbstractJdbcTriggerRepository.field("next_execution_date").asc()).forUpdate().fetch().map(r -> this.jdbcRepository.deserialize(r.get("value").toString()));
    }

    public Trigger save(Trigger trigger, ScheduleContextInterface scheduleContextInterface) {
        JdbcSchedulerContext jdbcSchedulerContext = (JdbcSchedulerContext)scheduleContextInterface;
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, jdbcSchedulerContext.getContext(), fields);
        return trigger;
    }

    public Trigger save(Trigger trigger) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, fields);
        return trigger;
    }

    @Override
    public Trigger save(DSLContext dslContext, Trigger trigger) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, dslContext, fields);
        return trigger;
    }

    public Trigger create(Trigger trigger) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSL.using((Configuration)configuration).insertInto(this.jdbcRepository.getTable()).set(AbstractJdbcRepository.field("key"), (Object)this.jdbcRepository.key(trigger)).set(this.jdbcRepository.persistFields(trigger)).execute();
            return trigger;
        });
    }

    public void delete(Trigger trigger) {
        this.jdbcRepository.delete(trigger);
    }

    public Trigger update(Trigger trigger) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSL.using((Configuration)configuration).update(this.jdbcRepository.getTable()).set(this.jdbcRepository.persistFields(trigger)).where(AbstractJdbcTriggerRepository.field("key").eq((Object)trigger.uid())).execute();
            return trigger;
        });
    }

    public Trigger updateExecution(Trigger trigger) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Optional<Trigger> optionalTrigger = this.jdbcRepository.fetchOne(context.select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)trigger.uid())).forUpdate());
            if (optionalTrigger.isPresent()) {
                Trigger current = optionalTrigger.get();
                current = current.toBuilder().executionId(trigger.getExecutionId()).executionCurrentState(trigger.getExecutionCurrentState()).updatedDate(trigger.getUpdatedDate()).build();
                this.save(context, current);
                return current;
            }
            return null;
        });
    }

    public Trigger update(Flow flow, AbstractTrigger abstractTrigger, ConditionContext conditionContext) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            Optional<Trigger> lastTrigger = this.jdbcRepository.fetchOne(DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)Trigger.uid((Flow)flow, (AbstractTrigger)abstractTrigger))).forUpdate());
            Trigger updatedTrigger = Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger, (ConditionContext)conditionContext, lastTrigger);
            DSL.using((Configuration)configuration).update(this.jdbcRepository.getTable()).set(this.jdbcRepository.persistFields(updatedTrigger)).where(AbstractJdbcTriggerRepository.field("key").eq((Object)updatedTrigger.uid())).execute();
            return updatedTrigger;
        });
    }

    public Trigger lock(String triggerUid, Function<Trigger, Trigger> function) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Optional<Trigger> optionalTrigger = this.jdbcRepository.fetchOne(context.select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)triggerUid)).forUpdate());
            if (optionalTrigger.isPresent()) {
                Trigger trigger = (Trigger)function.apply(optionalTrigger.get());
                this.save(context, trigger);
                return trigger;
            }
            return null;
        });
    }

    public ArrayListTotal<Trigger> find(Pageable pageable, String query, String tenantId, String namespace) {
        return this.find(pageable, query, tenantId, namespace, null);
    }

    public ArrayListTotal<Trigger> find(Pageable pageable, String query, String tenantId, String namespace, String flowId) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcTriggerRepository.field("value")).hint(context.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.fullTextCondition(query)).and(this.defaultFilter(tenantId));
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcTriggerRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcTriggerRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            if (flowId != null) {
                select.and(AbstractJdbcTriggerRepository.field("flow_id").eq((Object)flowId));
            }
            select.and(this.defaultFilter());
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    protected Condition fullTextCondition(String query) {
        return query == null ? DSL.trueCondition() : this.jdbcRepository.fullTextCondition(List.of("fulltext"), query);
    }

    @Override
    protected Condition defaultFilter(String tenantId) {
        return this.buildTenantCondition(tenantId);
    }

    @Override
    protected Condition defaultFilter() {
        return DSL.trueCondition();
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("flowId", "flow_id", "triggerId", "trigger_id", "executionId", "execution_id");
        return s -> mapper.getOrDefault(s, (String)s);
    }
}

