/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.repositories.WorkerJobRunningRepositoryInterface;
import io.kestra.core.runners.WorkerJobRunning;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class AbstractJdbcWorkerJobRunningRepository
extends AbstractJdbcRepository
implements WorkerJobRunningRepositoryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcWorkerJobRunningRepository.class);
    protected io.kestra.jdbc.AbstractJdbcRepository<WorkerJobRunning> jdbcRepository;

    public AbstractJdbcWorkerJobRunningRepository(io.kestra.jdbc.AbstractJdbcRepository<WorkerJobRunning> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public WorkerJobRunning save(WorkerJobRunning workerJobRunning, DSLContext context) {
        this.jdbcRepository.persist(workerJobRunning, context, this.jdbcRepository.persistFields(workerJobRunning));
        return workerJobRunning;
    }

    public void deleteByKey(String uid) {
        Optional<WorkerJobRunning> workerJobRunning = this.findByKey(uid);
        workerJobRunning.ifPresent(jobRunning -> this.jdbcRepository.delete((WorkerJobRunning)jobRunning));
    }

    public Optional<WorkerJobRunning> findByKey(String uid) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcWorkerJobRunningRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcWorkerJobRunningRepository.field("key").eq((Object)uid));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public List<WorkerJobRunning> getWorkerJobWithWorkerDead(DSLContext context, List<String> workersToDelete) {
        return context.select(AbstractJdbcWorkerJobRunningRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcWorkerJobRunningRepository.field("worker_uuid").in(workersToDelete)).forUpdate().fetch().map(r -> this.jdbcRepository.deserialize(r.get("value").toString()));
    }
}

