/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.jdbc.AbstractJdbcRepository;
import io.kestra.jdbc.JdbcMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcSubflowExecutionStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository {
    private static final ObjectMapper MAPPER = JdbcMapper.of();
    protected AbstractJdbcRepository<SubflowExecution<?>> jdbcRepository;

    public AbstractJdbcSubflowExecutionStorage(AbstractJdbcRepository jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<SubflowExecution<?>> get(String executionId) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value")).from(this.jdbcRepository.getTable()).where(io.kestra.jdbc.repository.AbstractJdbcRepository.field("key").eq((Object)executionId));
            try {
                return this.jdbcRepository.fetchOne(select);
            }
            catch (DeserializationException deserializationException) {
                JsonNode jsonNode = MAPPER.readTree(deserializationException.getRecord());
                TaskRun taskRun = (TaskRun)MAPPER.treeToValue((TreeNode)jsonNode.get("parentTaskRun"), TaskRun.class);
                Execution execution = (Execution)MAPPER.treeToValue((TreeNode)jsonNode.get("execution"), Execution.class);
                return Optional.of(SubflowExecution.builder().parentTaskRun(taskRun).execution(execution).build());
            }
        });
    }

    public void save(List<SubflowExecution<?>> subflowExecutions) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            subflowExecutions.forEach(subflowExecution -> {
                Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields((SubflowExecution<?>)subflowExecution);
                this.jdbcRepository.persist((SubflowExecution<?>)subflowExecution, context, fields);
            });
        });
    }

    public void delete(SubflowExecution<?> subflowExecution) {
        this.jdbcRepository.delete(subflowExecution);
    }
}

