/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.queues.QueueException;
import io.kestra.jdbc.JdbcTableConfig;
import io.kestra.jdbc.JooqDSLContextWrapper;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.annotation.Scheduled;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@JdbcRunnerEnabled
@Requires(property="kestra.jdbc.cleaner")
public class JdbcCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcCleaner.class);
    private final JooqDSLContextWrapper dslContextWrapper;
    private final Configuration configuration;
    protected final Table<Record> queueTable;

    @Inject
    public JdbcCleaner(@Named(value="queues") JdbcTableConfig jdbcTableConfig, JooqDSLContextWrapper dslContextWrapper, Configuration configuration) {
        this.dslContextWrapper = dslContextWrapper;
        this.configuration = configuration;
        this.queueTable = DSL.table((String)jdbcTableConfig.table());
    }

    public void deleteQueue() throws QueueException {
        this.dslContextWrapper.transaction(configuration -> {
            int deleted = DSL.using((org.jooq.Configuration)configuration).delete(this.queueTable).where(AbstractJdbcRepository.field("updated").lessOrEqual((Object)ZonedDateTime.now().minus(this.configuration.getRetention()).toOffsetDateTime())).execute();
            log.info("Cleaned {} records from {}", (Object)deleted, (Object)this.queueTable.getName());
        });
    }

    @Scheduled(initialDelay="${kestra.jdbc.cleaner.initial-delay}", fixedDelay="${kestra.jdbc.cleaner.fixed-delay}")
    public void report() {
        this.deleteQueue();
    }

    @ConfigurationProperties(value="kestra.jdbc.cleaner")
    public static class Configuration {
        Duration retention;

        @Generated
        public Duration getRetention() {
            return this.retention;
        }
    }
}

