/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.schedulers.AbstractScheduler;
import io.kestra.core.schedulers.DefaultScheduler;
import io.kestra.core.schedulers.ScheduleContextInterface;
import io.kestra.core.schedulers.Scheduler;
import io.kestra.core.schedulers.SchedulerTriggerStateInterface;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.ListUtils;
import io.kestra.jdbc.JooqDSLContextWrapper;
import io.kestra.jdbc.repository.AbstractJdbcTriggerRepository;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import io.kestra.jdbc.runner.JdbcSchedulerContext;
import io.kestra.jdbc.runner.JdbcSchedulerTriggerState;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdbcRunnerEnabled
@Singleton
@Replaces(value=DefaultScheduler.class)
public class JdbcScheduler
extends AbstractScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcScheduler.class);
    private final QueueInterface<Execution> executionQueue;
    private final TriggerRepositoryInterface triggerRepository;
    private final ConditionService conditionService;
    private final FlowRepositoryInterface flowRepository;
    private final JooqDSLContextWrapper dslContextWrapper;

    @Inject
    public JdbcScheduler(ApplicationContext applicationContext, FlowListenersInterface flowListeners) {
        super(applicationContext, flowListeners);
        this.executionQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        this.triggerRepository = (TriggerRepositoryInterface)applicationContext.getBean(AbstractJdbcTriggerRepository.class);
        this.triggerState = (SchedulerTriggerStateInterface)applicationContext.getBean(SchedulerTriggerStateInterface.class);
        this.conditionService = (ConditionService)applicationContext.getBean(ConditionService.class);
        this.flowRepository = (FlowRepositoryInterface)applicationContext.getBean(FlowRepositoryInterface.class);
        this.dslContextWrapper = (JooqDSLContextWrapper)applicationContext.getBean(JooqDSLContextWrapper.class);
    }

    public void run() {
        super.run();
        this.executionQueue.receive(Scheduler.class, either -> {
            if (either.isRight()) {
                log.error("Unable to deserialize an execution: {}", (Object)((DeserializationException)either.getRight()).getMessage());
                return;
            }
            Execution execution = (Execution)either.getLeft();
            if (execution.getTrigger() != null) {
                Flow flow = this.flowRepository.findById(execution.getTenantId(), execution.getNamespace(), execution.getFlowId()).orElse(null);
                if (execution.isDeleted() || this.conditionService.isTerminatedWithListeners(flow, execution)) {
                    this.triggerRepository.findByExecution(execution).ifPresent(trigger -> this.triggerState.update(trigger.resetExecution(execution.getState().getCurrent())));
                } else {
                    this.triggerRepository.findByExecution(execution).filter(trigger -> execution.getState().getCurrent() != trigger.getExecutionCurrentState()).ifPresent(trigger -> ((JdbcSchedulerTriggerState)this.triggerState).updateExecution(Trigger.of((Execution)execution, (Trigger)trigger)));
                }
            }
        });
        this.flowListeners.listen((flow, previous) -> {
            if (flow.isDeleted()) {
                ListUtils.emptyOnNull((List)flow.getTriggers()).forEach(abstractTrigger -> this.triggerRepository.delete(Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger)));
            } else if (previous != null) {
                FlowService.findRemovedTrigger((Flow)flow, (Flow)previous).forEach(abstractTrigger -> this.triggerRepository.delete(Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger)));
            }
        });
    }

    public void handleNext(List<Flow> flows, ZonedDateTime now, BiConsumer<List<Trigger>, ScheduleContextInterface> consumer) {
        JdbcSchedulerContext schedulerContext = new JdbcSchedulerContext(this.dslContextWrapper);
        schedulerContext.startTransaction(scheduleContextInterface -> {
            List triggers = this.triggerState.findByNextExecutionDateReadyForAllTenants(now, scheduleContextInterface);
            consumer.accept(triggers, (ScheduleContextInterface)scheduleContextInterface);
        });
    }
}

