/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.server;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.repositories.ServiceInstanceRepositoryInterface;
import io.kestra.core.server.LocalServiceStateFactory;
import io.kestra.core.server.ServerConfig;
import io.kestra.core.server.ServerInstanceFactory;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceLivenessManager;
import io.kestra.core.server.ServiceRegistry;
import io.kestra.core.server.ServiceStateChangeEvent;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import io.micronaut.context.annotation.Context;
import io.micronaut.runtime.event.annotation.EventListener;
import jakarta.inject.Inject;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@JdbcRunnerEnabled
public final class JdbcServiceLivenessManager
extends ServiceLivenessManager {
    private static final Logger log = LoggerFactory.getLogger(JdbcServiceLivenessManager.class);

    @Inject
    public JdbcServiceLivenessManager(ServerConfig configuration, ServiceRegistry registry, LocalServiceStateFactory localServiceStateFactory, ServerInstanceFactory serverInstanceFactory, ServiceInstanceRepositoryInterface repository) {
        super(configuration, registry, localServiceStateFactory, serverInstanceFactory, repository, (ServiceLivenessManager.OnStateTransitionFailureCallback)new ServiceLivenessManager.DefaultStateTransitionFailureCallback());
    }

    @EventListener
    public void onServiceStateChangeEvent(ServiceStateChangeEvent event) {
        super.onServiceStateChangeEvent(event);
    }

    protected boolean beforeScheduledStateUpdate(Instant now, Service service, ServiceInstance instance) {
        if (this.isLivenessEnabled().booleanValue() && this.isWorkerServer() && this.isServerDisconnected(now)) {
            log.error("[Service id={}, type='{}', hostname='{}'] Failed to update state before reaching timeout ({}ms). Disconnecting.", new Object[]{instance.id(), instance.type(), instance.server().hostname(), this.getElapsedMilliSinceLastStateUpdate(now)});
            ServiceInstance updated = this.updateServiceInstanceState(now, service, Service.ServiceState.DISCONNECTED, ServiceLivenessManager.OnStateTransitionFailureCallback.NOOP);
            if (updated != null) {
                this.onStateTransitionFailureCallback.execute(now, service, updated, true);
            }
            return false;
        }
        return true;
    }

    private boolean isWorkerServer() {
        return KestraContext.getContext().getServerType().equals((Object)ServerType.WORKER);
    }

    private boolean isServerDisconnected(Instant now) {
        long timeoutMilli = this.serverConfig.liveness().timeout().toMillis();
        return this.getElapsedMilliSinceLastSchedule(now) < timeoutMilli && this.getElapsedMilliSinceLastStateUpdate(now) > timeoutMilli;
    }

    private long getElapsedMilliSinceLastStateUpdate(Instant now) {
        return now.toEpochMilli() - (this.lastSucceedStateUpdated() != null ? this.lastSucceedStateUpdated().toEpochMilli() : now.toEpochMilli());
    }
}

