/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.AbstractOracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.TruncateReceiver;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.logminer.LogMinerAdapter;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Attribute;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSchemaChangeEventEmitter
implements SchemaChangeEventEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSchemaChangeEventEmitter.class);
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final TableId tableId;
    private final OracleDatabaseSchema schema;
    private final Instant changeTime;
    private final String sourceDatabaseName;
    private final String objectOwner;
    private final String ddlText;
    private final Tables.TableFilter filters;
    private final AbstractOracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final TruncateReceiver truncateReceiver;
    private final OracleConnectorConfig connectorConfig;
    private final Long objectId;
    private final Long dataObjectId;

    public OracleSchemaChangeEventEmitter(OracleConnectorConfig connectorConfig, OraclePartition partition, OracleOffsetContext offsetContext, TableId tableId, String sourceDatabaseName, String objectOwner, String ddlText, OracleDatabaseSchema schema, Instant changeTime, AbstractOracleStreamingChangeEventSourceMetrics streamingMetrics, TruncateReceiver truncateReceiver) {
        this(connectorConfig, partition, offsetContext, tableId, sourceDatabaseName, objectOwner, null, null, ddlText, schema, changeTime, streamingMetrics, truncateReceiver);
    }

    public OracleSchemaChangeEventEmitter(OracleConnectorConfig connectorConfig, OraclePartition partition, OracleOffsetContext offsetContext, TableId tableId, String sourceDatabaseName, String objectOwner, Long objectId, Long dataObjectId, String ddlText, OracleDatabaseSchema schema, Instant changeTime, AbstractOracleStreamingChangeEventSourceMetrics streamingMetrics, TruncateReceiver truncateReceiver) {
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.tableId = tableId;
        this.sourceDatabaseName = sourceDatabaseName;
        this.objectOwner = objectOwner;
        this.ddlText = ddlText;
        this.schema = schema;
        this.changeTime = changeTime;
        this.streamingMetrics = streamingMetrics;
        this.filters = connectorConfig.getTableFilters().dataCollectionFilter();
        this.truncateReceiver = truncateReceiver;
        this.connectorConfig = connectorConfig;
        this.objectId = objectId;
        this.dataObjectId = dataObjectId;
    }

    @Override
    public void emitSchemaChangeEvent(SchemaChangeEventEmitter.Receiver receiver) throws InterruptedException {
        Table tableBefore = this.schema.tableFor(this.tableId);
        OracleDdlParser parser = this.schema.getDdlParser();
        DdlChanges ddlChanges = parser.getDdlChanges();
        try {
            ddlChanges.reset();
            parser.setCurrentDatabase(this.sourceDatabaseName);
            parser.setCurrentSchema(this.objectOwner);
            parser.parse(this.ddlText, this.schema.getTables());
        }
        catch (MultipleParsingExceptions | ParsingException e) {
            if (this.schema.skipUnparseableDdlStatements()) {
                LOGGER.warn("Ignoring unparsable DDL statement '{}':", (Object)this.ddlText, (Object)e);
                this.streamingMetrics.incrementWarningCount();
                this.streamingMetrics.incrementSchemaChangeParseErrorCount();
            }
            throw e;
        }
        if (!(ddlChanges.isEmpty() || !this.filters.isIncluded(this.tableId) && this.schema.storeOnlyCapturedTables())) {
            ArrayList changeEvents = new ArrayList();
            ddlChanges.getEventsByDatabase((dbName, events) -> events.forEach(event -> {
                switch (event.type()) {
                    case CREATE_TABLE: {
                        changeEvents.add(this.createTableEvent(this.partition, (DdlParserListener.TableCreatedEvent)event));
                        break;
                    }
                    case ALTER_TABLE: {
                        changeEvents.add(this.alterTableEvent(this.partition, (DdlParserListener.TableAlteredEvent)event));
                        break;
                    }
                    case DROP_TABLE: {
                        changeEvents.add(this.dropTableEvent(this.partition, tableBefore, (DdlParserListener.TableDroppedEvent)event));
                        break;
                    }
                    case TRUNCATE_TABLE: {
                        changeEvents.add(this.truncateTableEvent(this.partition, (DdlParserListener.TableTruncatedEvent)event));
                        break;
                    }
                    default: {
                        LOGGER.info("Skipped DDL event type {}: {}", (Object)event.type(), (Object)this.ddlText);
                    }
                }
            }));
            for (SchemaChangeEvent event : changeEvents) {
                if (this.schema.skipSchemaChangeEvent(event)) continue;
                if (SchemaChangeEvent.SchemaChangeEventType.TRUNCATE == event.getType()) {
                    this.truncateReceiver.processTruncateEvent();
                    continue;
                }
                receiver.schemaChangeEvent(event);
            }
        }
    }

    private SchemaChangeEvent createTableEvent(OraclePartition partition, DdlParserListener.TableCreatedEvent event) {
        this.applyTableObjectAttributes(this.tableId);
        this.offsetContext.tableEvent(this.tableId, this.changeTime);
        return SchemaChangeEvent.ofCreate(partition, this.offsetContext, this.tableId.catalog(), this.tableId.schema(), event.statement(), this.schema.tableFor(event.tableId()), false);
    }

    private SchemaChangeEvent alterTableEvent(OraclePartition partition, DdlParserListener.TableAlteredEvent event) {
        LinkedHashSet<TableId> tableIds = new LinkedHashSet<TableId>();
        tableIds.add(this.tableId);
        tableIds.add(event.tableId());
        this.applyTableObjectAttributes(event.tableId());
        this.offsetContext.tableEvent(tableIds, this.changeTime);
        if (this.tableId == null) {
            return SchemaChangeEvent.ofAlter(partition, this.offsetContext, this.tableId.catalog(), this.tableId.schema(), event.statement(), this.schema.tableFor(event.tableId()));
        }
        return SchemaChangeEvent.ofRename(partition, this.offsetContext, this.tableId.catalog(), this.tableId.schema(), event.statement(), this.schema.tableFor(event.tableId()), this.tableId);
    }

    private SchemaChangeEvent dropTableEvent(OraclePartition partition, Table tableSchemaBeforeDrop, DdlParserListener.TableDroppedEvent event) {
        this.offsetContext.tableEvent(this.tableId, this.changeTime);
        return SchemaChangeEvent.ofDrop(partition, this.offsetContext, this.tableId.catalog(), this.tableId.schema(), event.statement(), tableSchemaBeforeDrop);
    }

    private SchemaChangeEvent truncateTableEvent(OraclePartition partition, DdlParserListener.TableTruncatedEvent event) {
        this.applyTableObjectAttributes(event.tableId());
        this.offsetContext.tableEvent(this.tableId, this.changeTime);
        return SchemaChangeEvent.ofTruncate(partition, this.offsetContext, this.tableId.catalog(), this.tableId.schema(), event.statement(), this.schema.tableFor(event.tableId()));
    }

    void applyTableObjectAttributes(TableId tableId) {
        if (this.connectorConfig.getAdapter() instanceof LogMinerAdapter && OracleConnectorConfig.LogMiningStrategy.HYBRID.equals(this.connectorConfig.getLogMiningStrategy())) {
            Table table = this.schema.tableFor(tableId);
            if (table != null) {
                TableEditor editor = table.edit();
                editor.addAttribute(Attribute.editor().name("OBJECT_ID").value(this.objectId).create());
                editor.addAttribute(Attribute.editor().name("DATA_OBJECT_ID").value(this.dataObjectId).create());
                this.schema.getTables().overwriteTable(editor.create());
            } else {
                LOGGER.debug("Cannot apply table attributes to table '{}', schema is not yet registered.", (Object)tableId);
            }
        }
    }
}

