/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.antlr.listener.OracleDdlParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Tables;
import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleDdlParser
extends AntlrDdlParser<PlSqlLexer, PlSqlParser> {
    private final Tables.TableFilter tableFilter;
    private final OracleValueConverters converters;
    private String catalogName;
    private String schemaName;

    public OracleDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public OracleDdlParser(OracleValueConverters valueConverters) {
        this(true, valueConverters, Tables.TableFilter.includeAll());
    }

    public OracleDdlParser(OracleValueConverters valueConverters, Tables.TableFilter tableFilter) {
        this(true, valueConverters, tableFilter);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, OracleValueConverters converters, Tables.TableFilter tableFilter) {
        this(throwErrorsFromTreeWalk, false, false, converters, tableFilter);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, OracleValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    public void parse(String ddlContent, Tables databaseTables) {
        if (!((String)ddlContent).endsWith(";")) {
            ddlContent = (String)ddlContent + ";";
        }
        super.parse((String)ddlContent, databaseTables);
    }

    @Override
    public ParseTree parseTree(PlSqlParser parser) {
        return parser.sql_script();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new OracleDdlParserListener(this.catalogName, this.schemaName, this);
    }

    @Override
    protected PlSqlLexer createNewLexerInstance(CharStream charStreams) {
        return new PlSqlLexer(charStreams);
    }

    @Override
    protected PlSqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new PlSqlParser(commonTokenStream);
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(PlSqlParser.Native_datatype_elementContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2, 740), new DataTypeResolver.DataTypeEntry(2, 731), new DataTypeResolver.DataTypeEntry(2, 1631), new DataTypeResolver.DataTypeEntry(2, 1172), new DataTypeResolver.DataTypeEntry(2, 365), new DataTypeResolver.DataTypeEntry(2, 1171), new DataTypeResolver.DataTypeEntry(93, 345), new DataTypeResolver.DataTypeEntry(-102, 2028), new DataTypeResolver.DataTypeEntry(-101, 2028), new DataTypeResolver.DataTypeEntry(93, 2028), new DataTypeResolver.DataTypeEntry(12, 2174), new DataTypeResolver.DataTypeEntry(12, 2175), new DataTypeResolver.DataTypeEntry(-9, 1176), new DataTypeResolver.DataTypeEntry(1, 186), new DataTypeResolver.DataTypeEntry(-15, 952), new DataTypeResolver.DataTypeEntry(100, 120), new DataTypeResolver.DataTypeEntry(101, 117), new DataTypeResolver.DataTypeEntry(6, 579), new DataTypeResolver.DataTypeEntry(6, 1439), new DataTypeResolver.DataTypeEntry(2004, 134), new DataTypeResolver.DataTypeEntry(2005, 203)));
        return dataTypeResolverBuilder.build();
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return null;
    }

    @Override
    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    @Override
    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public OracleValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }
}

