/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.converters;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.function.Predicates;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import io.debezium.util.Strings;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Predicate;
import oracle.sql.RAW;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawToStringConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawToStringConverter.class);
    private static final String FALLBACK = "";
    public static final String SELECTOR_PROPERTY = "selector";
    private Predicate<RelationalColumn> selector = x -> true;

    @Override
    public void configure(Properties properties) {
        String selectorConfig = properties.getProperty(SELECTOR_PROPERTY);
        if (Strings.isNullOrEmpty(selectorConfig)) {
            return;
        }
        this.selector = Predicates.includes(selectorConfig.trim(), x -> x.dataCollection() + "." + x.name());
    }

    @Override
    public void converterFor(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        if (!"RAW".equalsIgnoreCase(field.typeName()) || !this.selector.test(field)) {
            return;
        }
        registration.register(SchemaBuilder.string(), x -> {
            if (x == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (!field.hasDefaultValue()) return FALLBACK;
                return field.defaultValue();
            }
            try {
                if (x instanceof String) {
                    String data = (String)x;
                    if ("EMPTY_BLOB()".equals(data)) {
                        if (!field.isOptional()) return FALLBACK;
                        return null;
                    }
                    if (!OracleValueConverters.isHexToRawFunctionCall(data)) return x;
                    x = RAW.hexString2Bytes(OracleValueConverters.getHexToRawHexString(data));
                    return new String((byte[])x, StandardCharsets.UTF_8);
                } else if (x instanceof RAW) {
                    x = ((RAW)x).getBytes();
                    return new String((byte[])x, StandardCharsets.UTF_8);
                } else {
                    if (x instanceof byte[]) return new String((byte[])x, StandardCharsets.UTF_8);
                    LOGGER.warn("Cannot convert '{}' to string", (Object)x.getClass());
                    return FALLBACK;
                }
            }
            catch (SQLException e) {
                throw new DebeziumException("Failed to convert value for column" + field.name(), e);
            }
        });
    }
}

