/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerDatabaseStateWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerDatabaseStateWriter.class);

    public static void write(OracleConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured redo logs are:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOGFILE");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain redo log table entries", e);
            }
            LOGGER.debug("Archive logs for last 48 hours:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$ARCHIVED_LOG WHERE FIRST_TIME >= SYSDATE - 2");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain archive log table entries", e);
            }
            LOGGER.debug("Available logs are:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOG");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log table entries", e);
            }
            LOGGER.debug("Log history last 24 hours:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOG_HISTORY WHERE FIRST_TIME >= SYSDATE - 1");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log history", e);
            }
        }
    }

    public static void writeLogMinerStartParameters(OracleConnection connection) {
        String query = "SELECT START_SCN, END_SCN, REQUIRED_START_SCN, OPTIONS, STATUS, INFO FROM V$LOGMNR_PARAMETERS";
        try {
            connection.query("SELECT START_SCN, END_SCN, REQUIRED_START_SCN, OPTIONS, STATUS, INFO FROM V$LOGMNR_PARAMETERS", rs -> {
                if (rs.next()) {
                    LOGGER.error("Failed to start a LogMiner mining session with parameters: ");
                    do {
                        LOGGER.error("\tSCN: [{}-{}], Required Start SCN: {}, Options: {}, Status: {} - {}", rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6) == null ? "N/A" : rs.getString(6));
                    } while (rs.next());
                }
            });
        }
        catch (SQLException e) {
            LOGGER.error("Failed to read contents of V$LOGMNR_PARAMETERS", e);
        }
    }

    public static void writeLogMinerLogFailures(OracleConnection connection) {
        String query = "SELECT FILENAME, THREAD_ID, THREAD_SQN, LOW_SCN, NEXT_SCN, DICTIONARY_BEGIN, DICTIONARY_END, TYPE, INFO FROM V$LOGMNR_LOGS WHERE STATUS = 4 ORDER BY THREAD_ID, THREAD_SQN";
        try {
            connection.query("SELECT FILENAME, THREAD_ID, THREAD_SQN, LOW_SCN, NEXT_SCN, DICTIONARY_BEGIN, DICTIONARY_END, TYPE, INFO FROM V$LOGMNR_LOGS WHERE STATUS = 4 ORDER BY THREAD_ID, THREAD_SQN", rs -> {
                if (rs.next()) {
                    String dictionaryStatus = "YES".equals(rs.getString(6)) ? ("YES".equals(rs.getString(7)) ? "BEGIN+END" : "BEGIN") : ("YES".equals(rs.getString(7)) ? "END" : "NONE");
                    LOGGER.error("The following logs triggered a LogMiner failure:");
                    do {
                        LOGGER.error("\t* File '{}', Thread {} (Seq {}), SCN [{} - {}], Type {}, Dictionary {}: {}", rs.getString(1), rs.getLong(2), rs.getLong(3), rs.getString(4), rs.getString(5), rs.getString(8), dictionaryStatus, rs.getString(9));
                    } while (rs.next());
                } else {
                    LOGGER.error("No logs were found with a status code of 4.");
                }
            });
        }
        catch (SQLException e) {
            LOGGER.error("Failed to read contents of V$LOGMNR_LOGS to determine log failures", e);
        }
    }

    private static void logQueryResults(OracleConnection connection, String query) throws SQLException {
        connection.query(query, rs -> {
            int columns = rs.getMetaData().getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int index = 1; index <= columns; ++index) {
                columnNames.add(rs.getMetaData().getColumnName(index));
            }
            LOGGER.debug("{}", (Object)columnNames);
            while (rs.next()) {
                ArrayList<Object> columnValues = new ArrayList<Object>();
                for (int index = 1; index <= columns; ++index) {
                    columnValues.add(rs.getObject(index));
                }
                LOGGER.debug("{}", (Object)columnValues);
            }
        });
    }
}

