/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.logwriter;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.util.Strings;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogWriterFlushStrategy
implements LogWriterFlushStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogWriterFlushStrategy.class);
    private static final String CREATE_FLUSH_TABLE = "CREATE TABLE %s (LAST_SCN NUMBER(19,0))";
    private static final String INSERT_FLUSH_TABLE = "INSERT INTO %s VALUES (0)";
    private static final String UPDATE_FLUSH_TABLE = "UPDATE %s SET LAST_SCN = ";
    private static final String DELETE_FLUSH_TABLE = "DELETE FROM %s";
    private final String flushTableName;
    private final String databasePdbName;
    private final OracleConnection connection;
    private final boolean closeConnectionOnClose;

    public CommitLogWriterFlushStrategy(OracleConnectorConfig connectorConfig, OracleConnection connection) {
        this.flushTableName = connectorConfig.getLogMiningFlushTableName();
        this.databasePdbName = connectorConfig.getPdbName();
        this.connection = connection;
        this.closeConnectionOnClose = false;
        this.createFlushTableIfNotExists();
    }

    public CommitLogWriterFlushStrategy(OracleConnectorConfig connectorConfig, JdbcConfiguration jdbcConfig) throws SQLException {
        this.flushTableName = connectorConfig.getLogMiningFlushTableName();
        this.databasePdbName = connectorConfig.getPdbName();
        this.connection = new OracleConnection(jdbcConfig);
        this.connection.setAutoCommit(false);
        this.closeConnectionOnClose = true;
        this.createFlushTableIfNotExists();
    }

    @Override
    public void close() {
        if (this.closeConnectionOnClose) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new DebeziumException("Failed to close connection to host '" + this.getHost() + "'", e);
            }
        }
    }

    @Override
    public String getHost() {
        return this.connection.config().getHostname();
    }

    @Override
    public void flush(Scn currentScn) {
        try {
            if (!Strings.isNullOrEmpty(this.databasePdbName)) {
                this.connection.setSessionToPdb(this.databasePdbName);
            }
            this.connection.execute(String.format(UPDATE_FLUSH_TABLE, this.flushTableName) + currentScn);
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to flush Oracle LogWriter (LGWR) buffers to disk", e);
        }
        finally {
            if (!Strings.isNullOrEmpty(this.databasePdbName)) {
                this.connection.resetSessionToCdb();
            }
        }
    }

    private void createFlushTableIfNotExists() {
        try {
            if (!Strings.isNullOrBlank(this.databasePdbName)) {
                this.connection.setSessionToPdb(this.databasePdbName);
            }
            if (!this.connection.isTableExists(this.flushTableName)) {
                this.connection.executeWithoutCommitting(String.format(CREATE_FLUSH_TABLE, this.flushTableName));
            }
            this.fixMultiRowDataBug();
            if (this.connection.isTableEmpty(this.flushTableName)) {
                this.connection.executeWithoutCommitting(String.format(INSERT_FLUSH_TABLE, this.flushTableName));
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to create flush table", e);
        }
        finally {
            if (!Strings.isNullOrEmpty(this.databasePdbName)) {
                this.connection.resetSessionToCdb();
            }
        }
    }

    private void fixMultiRowDataBug() throws SQLException {
        if (this.connection.getRowCount(this.flushTableName) > 1L) {
            LOGGER.warn("DBZ-4118: The flush table, {}, has multiple rows and has been corrected.", (Object)this.flushTableName);
            this.connection.executeWithoutCommitting(String.format(DELETE_FLUSH_TABLE, this.flushTableName));
            this.connection.executeWithoutCommitting(String.format(INSERT_FLUSH_TABLE, this.flushTableName));
            this.connection.commit();
        }
    }
}

