/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.olr;

import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.data.Envelope;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import java.sql.Connection;

public class OpenLogReplicatorChangeRecordEmitter
extends BaseChangeRecordEmitter<Object> {
    private static final String EPOCH_NANO = "TIMESTAMP'1970-01-01 00:00:00' + NUMTODSINTERVAL(%s/1000000000,'SECOND')";
    private static final String TO_DSINTERVAL = "TO_DSINTERVAL('%s')";
    private static final String TO_YMINTERVAL = "TO_YMINTERVAL('%s')";
    private final Envelope.Operation operation;

    public OpenLogReplicatorChangeRecordEmitter(OracleConnectorConfig connectorConfig, OraclePartition partition, OracleOffsetContext offsetContext, Envelope.Operation operation, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock) {
        super(connectorConfig, partition, offsetContext, schema, table, clock, oldValues, newValues);
        this.operation = operation;
    }

    @Override
    public Envelope.Operation getOperation() {
        return this.operation;
    }

    @Override
    protected Object convertReselectPrimaryKeyColumn(Connection connection, Column column, Object value) {
        switch (column.jdbcType()) {
            case 91: 
            case 93: {
                if (!(value instanceof Number)) break;
                value = this.convertValueViaQuery(connection, String.format(EPOCH_NANO, value));
                break;
            }
            case -104: {
                if (!(value instanceof String)) break;
                value = this.convertValueViaQuery(connection, String.format(TO_DSINTERVAL, ((String)value).replace(",", " ")));
                break;
            }
            case -103: {
                if (!(value instanceof String)) break;
                value = this.convertValueViaQuery(connection, String.format(TO_YMINTERVAL, value));
            }
        }
        return value;
    }
}

