/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.CloudEventsConverterConfig;
import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import io.debezium.converters.recordandmetadata.RecordAndMetadataBaseImpl;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;

public class RecordAndMetadataHeaderImpl
extends RecordAndMetadataBaseImpl
implements RecordAndMetadata {
    private final Headers headers;
    private final CloudEventsConverterConfig.MetadataSource metadataSource;
    private final JsonConverter jsonHeaderConverter;

    public RecordAndMetadataHeaderImpl(Struct record, Schema originalDataSchema, Headers headers, CloudEventsConverterConfig.MetadataSource metadataSource, JsonConverter jsonHeaderConverter) {
        super(record, originalDataSchema);
        this.headers = headers;
        this.metadataSource = metadataSource;
        this.jsonHeaderConverter = jsonHeaderConverter;
    }

    @Override
    public String id() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.id(), "id", false, null, () -> super.id());
    }

    @Override
    public String type() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.type(), "type", false, null, () -> super.type());
    }

    @Override
    public Struct source() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.global(), "source", false, null, () -> super.source());
    }

    @Override
    public String operation() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.global(), "op", false, null, () -> super.operation());
    }

    @Override
    public Struct transaction() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.global(), "transaction", true, null, () -> super.transaction());
    }

    @Override
    public SchemaAndValue timestamp() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.global(), null, null, () -> {
            String ts_ms = this.source().getInt64("ts_ms").toString();
            Schema ts_msSchema = this.source().schema().field("ts_ms").schema();
            return new SchemaAndValue(ts_msSchema, ts_ms);
        }, () -> super.timestamp());
    }

    @Override
    public String dataSchemaName() {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.dataSchemaName(), "dataSchemaName", false, null, () -> super.dataSchemaName());
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        return this.getValueFromHeaderOrByDefault(this.metadataSource.global(), null, null, () -> super.dataSchema(new String[0]), () -> super.dataSchema(dataFields));
    }

    private <T> T getValueFromHeaderOrByDefault(CloudEventsConverterConfig.MetadataSourceValue metadataSourceValue, String headerName, Boolean headerIsOptional, Supplier<T> headerCaseDefaultSupplier, Supplier<T> defaultSupplier) {
        if (metadataSourceValue == CloudEventsConverterConfig.MetadataSourceValue.HEADER) {
            if (headerName != null) {
                return (T)this.getHeaderSchemaAndValue(this.headers, headerName, headerIsOptional).value();
            }
            return headerCaseDefaultSupplier.get();
        }
        return defaultSupplier.get();
    }

    private SchemaAndValue getHeaderSchemaAndValue(Headers headers, String headerName, boolean isOptional) {
        Header header = headers.lastHeader(headerName);
        if (header == null && !isOptional) {
            throw new RuntimeException("Header `" + headerName + "` was not provided");
        }
        return this.jsonHeaderConverter.toConnectData(null, header.value());
    }
}

