/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.async.AbstractRecordProcessor;
import io.debezium.embedded.async.ProcessingCallables;
import io.debezium.engine.DebeziumEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSmtAndConvertConsumerProcessor<R>
extends AbstractRecordProcessor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelSmtAndConvertConsumerProcessor.class);
    final DebeziumEngine.RecordCommitter committer;
    final Consumer<R> consumer;
    final Function<SourceRecord, R> convertor;

    ParallelSmtAndConvertConsumerProcessor(DebeziumEngine.RecordCommitter committer, Consumer<R> consumer, Function<SourceRecord, R> convertor) {
        this.committer = committer;
        this.consumer = consumer;
        this.convertor = convertor;
    }

    @Override
    public void processRecords(List<SourceRecord> records) throws Exception {
        LOGGER.debug("Thread {} is submitting {} records for processing.", (Object)Thread.currentThread().getName(), (Object)records.size());
        ArrayList recordFutures = new ArrayList(records.size());
        records.stream().forEachOrdered(r -> recordFutures.add(this.recordService.submit(new ProcessingCallables.TransformAndConvertRecord<R>((SourceRecord)r, this.transformations, this.convertor))));
        LOGGER.trace("Calling user consumer.");
        for (int i = 0; i < records.size(); ++i) {
            this.consumer.accept(((Future)recordFutures.get(i)).get());
            this.committer.markProcessed(records.get(i));
        }
        LOGGER.trace("Marking batch as finished.");
        this.committer.markBatchFinished();
    }
}

