/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.snapshot.spi.SnapshotLock;
import io.debezium.snapshot.spi.SnapshotQuery;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SnapshotterServiceProvider
implements ServiceProvider<SnapshotterService> {
    @Override
    public SnapshotterService createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        BeanRegistry beanRegistry = serviceRegistry.tryGetService(BeanRegistry.class);
        CommonConnectorConfig commonConnectorConfig = beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class);
        String configuredSnapshotMode = this.snapshotMode(commonConnectorConfig);
        String snapshotModeCustomName = commonConnectorConfig.getSnapshotModeCustomName();
        String snapshotMode = "custom".equals(configuredSnapshotMode) && !snapshotModeCustomName.isEmpty() ? snapshotModeCustomName : configuredSnapshotMode;
        List snapshotters = StreamSupport.stream(ServiceLoader.load(Snapshotter.class).spliterator(), false).filter(s2 -> s2.name().equalsIgnoreCase(snapshotMode)).collect(Collectors.toList());
        if (snapshotters.isEmpty()) {
            throw new DebeziumException(String.format("Unable to find %s snapshotter. Please check your configuration.", snapshotMode));
        }
        if (snapshotters.size() > 1) {
            throw new DebeziumException("Found multiple implementation for {} snapshotter. Please verify your configuration.");
        }
        SnapshotQuery snapshotQueryService = serviceRegistry.tryGetService(SnapshotQuery.class);
        SnapshotLock snapshotLockService = serviceRegistry.tryGetService(SnapshotLock.class);
        Snapshotter snapshotter = (Snapshotter)snapshotters.get(0);
        return SnapshotterServiceProvider.getSnapshotterService(configuration, snapshotter, beanRegistry, snapshotQueryService, snapshotLockService);
    }

    private static SnapshotterService getSnapshotterService(Configuration configuration, Snapshotter snapshotter, BeanRegistry beanRegistry, SnapshotQuery snapshotQueryService, SnapshotLock snapshotLockService) {
        if (snapshotter instanceof BeanRegistryAware) {
            ((BeanRegistryAware)((Object)snapshotter)).injectBeanRegistry(beanRegistry);
        }
        snapshotter.configure(configuration.asMap());
        return new SnapshotterService(snapshotter, snapshotQueryService, snapshotLockService);
    }

    @Override
    public Class<SnapshotterService> getServiceClass() {
        return SnapshotterService.class;
    }

    public String snapshotMode(CommonConnectorConfig configuration) {
        return configuration.getSnapshotMode().getValue();
    }
}

