/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.ThreadSafe;
import io.debezium.util.VariableLatch;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.LongSummaryStatistics;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

@ThreadSafe
public abstract class Stopwatch {
    public abstract Stopwatch start();

    public abstract Stopwatch stop();

    public abstract Durations durations();

    private static Statistics createStatistics(final LongSummaryStatistics stats) {
        final boolean some = stats.getCount() > 0L;
        return new Statistics(){

            @Override
            public long getCount() {
                return stats.getCount();
            }

            @Override
            public Duration getMaximum() {
                return some ? Duration.ofNanos(stats.getMax()) : Duration.ZERO;
            }

            @Override
            public Duration getMinimum() {
                return some ? Duration.ofNanos(stats.getMin()) : Duration.ZERO;
            }

            @Override
            public Duration getTotal() {
                return some ? Duration.ofNanos(stats.getSum()) : Duration.ZERO;
            }

            @Override
            public Duration getAverage() {
                return some ? Duration.ofNanos((long)stats.getAverage()) : Duration.ZERO;
            }

            private String fixedLengthSeconds(Duration duration) {
                double seconds = (double)duration.toNanos() * 1.0E-9;
                String result = new DecimalFormat("##0.00000").format(seconds) + "s";
                if (result.length() == 8) {
                    return "  " + result;
                }
                if (result.length() == 9) {
                    return " " + result;
                }
                return result;
            }

            private String fixedLength(long count) {
                String result = new DecimalFormat("###0").format(count);
                if (result.length() == 1) {
                    return "   " + result;
                }
                if (result.length() == 2) {
                    return "  " + result;
                }
                if (result.length() == 3) {
                    return " " + result;
                }
                return result;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.fixedLengthSeconds(this.getTotal()) + " total;");
                sb.append(this.fixedLength(this.getCount()) + " samples;");
                sb.append(this.fixedLengthSeconds(this.getAverage()) + " avg;");
                sb.append(this.fixedLengthSeconds(this.getMinimum()) + " min;");
                sb.append(this.fixedLengthSeconds(this.getMaximum()) + " max");
                return sb.toString();
            }
        };
    }

    public static Stopwatch reusable() {
        return Stopwatch.createWith(new SingleDuration(), null, null);
    }

    public static Stopwatch accumulating() {
        return Stopwatch.createWith(new MultipleDurations(), null, null);
    }

    public static StopwatchSet multiple() {
        final MultipleDurations durations = new MultipleDurations();
        final VariableLatch latch = new VariableLatch(0);
        return new StopwatchSet(){

            @Override
            public Statistics statistics() {
                return durations.statistics();
            }

            @Override
            public Stopwatch create() {
                return Stopwatch.createWith(durations, latch::countUp, latch::countDown);
            }

            @Override
            public void await() throws InterruptedException {
                latch.await();
            }

            @Override
            public void await(long timeout, TimeUnit unit) throws InterruptedException {
                latch.await(timeout, unit);
            }

            public String toString() {
                return this.statistics().toString();
            }
        };
    }

    protected static Stopwatch createWith(final BaseDurations duration, final Runnable uponStart, final Runnable uponStop) {
        return new Stopwatch(){
            private final AtomicLong started = new AtomicLong(0L);

            @Override
            public Stopwatch start() {
                this.started.getAndUpdate(existing -> {
                    if (existing == 0L) {
                        existing = System.nanoTime();
                        if (uponStart != null) {
                            uponStart.run();
                        }
                    }
                    return existing;
                });
                return this;
            }

            @Override
            public Stopwatch stop() {
                this.started.getAndUpdate(existing -> {
                    if (existing != 0L) {
                        duration.add(Duration.ofNanos(System.nanoTime() - existing));
                        if (uponStop != null) {
                            uponStop.run();
                        }
                        return 0L;
                    }
                    return existing;
                });
                return this;
            }

            @Override
            public Durations durations() {
                return duration;
            }

            public String toString() {
                return this.durations().toString();
            }
        };
    }

    protected static String asString(Duration duration) {
        return duration.toString().substring(2);
    }

    @ThreadSafe
    private static final class SingleDuration
    extends BaseDurations {
        private final AtomicReference<Statistics> stats = new AtomicReference();

        SingleDuration() {
            LongSummaryStatistics stats = new LongSummaryStatistics();
            this.stats.set(Stopwatch.createStatistics(stats));
        }

        @Override
        public Statistics statistics() {
            return this.stats.get();
        }

        @Override
        public void add(Duration duration) {
            LongSummaryStatistics stats = new LongSummaryStatistics();
            if (duration != null) {
                stats.accept(duration.toNanos());
            }
            this.stats.set(Stopwatch.createStatistics(stats));
        }
    }

    @ThreadSafe
    protected static abstract class BaseDurations
    implements Durations {
        protected BaseDurations() {
        }

        public abstract void add(Duration var1);

        public String toString() {
            return this.statistics().toString();
        }
    }

    @ThreadSafe
    private static final class MultipleDurations
    extends BaseDurations {
        private final ConcurrentLinkedQueue<Duration> durations = new ConcurrentLinkedQueue();

        private MultipleDurations() {
        }

        @Override
        public Statistics statistics() {
            return Stopwatch.createStatistics(this.durations.stream().mapToLong(Duration::toNanos).summaryStatistics());
        }

        @Override
        public void add(Duration duration) {
            this.durations.add(duration);
        }
    }

    @ThreadSafe
    public static interface StopwatchSet
    extends Durations {
        public Stopwatch create();

        default public void time(Runnable runnable) {
            this.time(1, runnable);
        }

        default public <T> T time(Callable<T> runnable) {
            Stopwatch sw = this.create().start();
            try {
                T t2 = runnable.call();
                return t2;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                sw.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public void time(int repeat, Runnable runnable) {
            for (int i = 0; i != repeat; ++i) {
                Stopwatch sw = this.create().start();
                try {
                    runnable.run();
                    continue;
                }
                finally {
                    sw.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public <T> void time(int repeat, Callable<T> runnable, Consumer<T> cleanup) throws Exception {
            for (int i = 0; i != repeat; ++i) {
                Object result = null;
                Stopwatch sw = this.create().start();
                try {
                    result = runnable.call();
                    continue;
                }
                finally {
                    sw.stop();
                    if (cleanup != null) {
                        cleanup.accept(result);
                    }
                }
            }
        }

        public void await() throws InterruptedException;

        public void await(long var1, TimeUnit var3) throws InterruptedException;
    }

    public static interface Statistics {
        public long getCount();

        public Duration getTotal();

        public Duration getMinimum();

        public Duration getMaximum();

        public Duration getAverage();

        default public String getTotalAsString() {
            return Stopwatch.asString(this.getTotal());
        }

        default public String getMinimumAsString() {
            return Stopwatch.asString(this.getMinimum());
        }

        default public String getMaximumAsString() {
            return Stopwatch.asString(this.getMaximum());
        }

        default public String getAverageAsString() {
            return Stopwatch.asString(this.getAverage());
        }
    }

    @ThreadSafe
    public static interface Durations {
        public Statistics statistics();
    }
}

