/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractDebeziumTrigger
extends AbstractTrigger
implements PollingTriggerInterface,
TriggerOutput<AbstractDebeziumTask.Output> {
    protected final Duration interval;
    protected AbstractDebeziumTask.Format format;
    protected AbstractDebeziumTask.Deleted deleted;
    protected String deletedFieldName;
    protected AbstractDebeziumTask.Key key;
    protected AbstractDebeziumTask.Metadata metadata;
    protected String metadataFieldName;
    protected AbstractDebeziumTask.SplitTable splitTable;
    protected Boolean ignoreDdl;
    protected String hostname;
    protected String port;
    protected String username;
    protected String password;
    protected Object includedDatabases;
    protected Object excludedDatabases;
    protected Object includedTables;
    protected Object excludedTables;
    protected Object includedColumns;
    protected Object excludedColumns;
    protected Map<String, String> properties;
    protected String stateName;
    @Schema(title="The maximum number of rows to fetch before stopping.", description="It's not an hard limit and is evaluated every second.")
    @PluginProperty
    protected Integer maxRecords;
    @Schema(title="The maximum duration waiting for new rows.", description="It's not an hard limit and is evaluated every second.\n It is taken into account after the snapshot if any.")
    @PluginProperty
    protected Duration maxDuration;
    @Schema(title="The maximum total processing duration.", description="It's not an hard limit and is evaluated every second.\n It is taken into account after the snapshot if any.")
    @PluginProperty
    protected Duration maxWait;
    @Schema(title="The maximum duration waiting for the snapshot to ends.", description="It's not an hard limit and is evaluated every second.\n The properties 'maxRecord', 'maxDuration' and 'maxWait' are evaluated only after the snapshot is done.")
    @PluginProperty
    protected Duration maxSnapshotDuration;

    @Generated
    private static Duration $default$interval() {
        return Duration.ofSeconds(60L);
    }

    @Generated
    private static AbstractDebeziumTask.Format $default$format() {
        return AbstractDebeziumTask.Format.INLINE;
    }

    @Generated
    private static AbstractDebeziumTask.Deleted $default$deleted() {
        return AbstractDebeziumTask.Deleted.ADD_FIELD;
    }

    @Generated
    private static String $default$deletedFieldName() {
        return "deleted";
    }

    @Generated
    private static AbstractDebeziumTask.Key $default$key() {
        return AbstractDebeziumTask.Key.ADD_FIELD;
    }

    @Generated
    private static AbstractDebeziumTask.Metadata $default$metadata() {
        return AbstractDebeziumTask.Metadata.ADD_FIELD;
    }

    @Generated
    private static String $default$metadataFieldName() {
        return "metadata";
    }

    @Generated
    private static AbstractDebeziumTask.SplitTable $default$splitTable() {
        return AbstractDebeziumTask.SplitTable.TABLE;
    }

    @Generated
    private static Boolean $default$ignoreDdl() {
        return true;
    }

    @Generated
    private static String $default$stateName() {
        return "debezium-state";
    }

    @Generated
    private static Duration $default$maxWait() {
        return Duration.ofSeconds(10L);
    }

    @Generated
    private static Duration $default$maxSnapshotDuration() {
        return Duration.ofHours(1L);
    }

    @Generated
    protected AbstractDebeziumTrigger(AbstractDebeziumTriggerBuilder<?, ?> b) {
        super(b);
        this.interval = b.interval$set ? b.interval$value : AbstractDebeziumTrigger.$default$interval();
        this.format = b.format$set ? b.format$value : AbstractDebeziumTrigger.$default$format();
        this.deleted = b.deleted$set ? b.deleted$value : AbstractDebeziumTrigger.$default$deleted();
        this.deletedFieldName = b.deletedFieldName$set ? b.deletedFieldName$value : AbstractDebeziumTrigger.$default$deletedFieldName();
        this.key = b.key$set ? b.key$value : AbstractDebeziumTrigger.$default$key();
        this.metadata = b.metadata$set ? b.metadata$value : AbstractDebeziumTrigger.$default$metadata();
        this.metadataFieldName = b.metadataFieldName$set ? b.metadataFieldName$value : AbstractDebeziumTrigger.$default$metadataFieldName();
        this.splitTable = b.splitTable$set ? b.splitTable$value : AbstractDebeziumTrigger.$default$splitTable();
        this.ignoreDdl = b.ignoreDdl$set ? b.ignoreDdl$value : AbstractDebeziumTrigger.$default$ignoreDdl();
        this.hostname = b.hostname;
        this.port = b.port;
        this.username = b.username;
        this.password = b.password;
        this.includedDatabases = b.includedDatabases;
        this.excludedDatabases = b.excludedDatabases;
        this.includedTables = b.includedTables;
        this.excludedTables = b.excludedTables;
        this.includedColumns = b.includedColumns;
        this.excludedColumns = b.excludedColumns;
        this.properties = b.properties;
        this.stateName = b.stateName$set ? b.stateName$value : AbstractDebeziumTrigger.$default$stateName();
        this.maxRecords = b.maxRecords;
        this.maxDuration = b.maxDuration;
        this.maxWait = b.maxWait$set ? b.maxWait$value : AbstractDebeziumTrigger.$default$maxWait();
        this.maxSnapshotDuration = b.maxSnapshotDuration$set ? b.maxSnapshotDuration$value : AbstractDebeziumTrigger.$default$maxSnapshotDuration();
    }

    @Generated
    public String toString() {
        return "AbstractDebeziumTrigger(super=" + super.toString() + ", interval=" + String.valueOf(this.getInterval()) + ", format=" + String.valueOf((Object)this.getFormat()) + ", deleted=" + String.valueOf((Object)this.getDeleted()) + ", deletedFieldName=" + this.getDeletedFieldName() + ", key=" + String.valueOf((Object)this.getKey()) + ", metadata=" + String.valueOf((Object)this.getMetadata()) + ", metadataFieldName=" + this.getMetadataFieldName() + ", splitTable=" + String.valueOf((Object)this.getSplitTable()) + ", ignoreDdl=" + this.getIgnoreDdl() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", includedDatabases=" + String.valueOf(this.getIncludedDatabases()) + ", excludedDatabases=" + String.valueOf(this.getExcludedDatabases()) + ", includedTables=" + String.valueOf(this.getIncludedTables()) + ", excludedTables=" + String.valueOf(this.getExcludedTables()) + ", includedColumns=" + String.valueOf(this.getIncludedColumns()) + ", excludedColumns=" + String.valueOf(this.getExcludedColumns()) + ", properties=" + String.valueOf(this.getProperties()) + ", stateName=" + this.getStateName() + ", maxRecords=" + this.getMaxRecords() + ", maxDuration=" + String.valueOf(this.getMaxDuration()) + ", maxWait=" + String.valueOf(this.getMaxWait()) + ", maxSnapshotDuration=" + String.valueOf(this.getMaxSnapshotDuration()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDebeziumTrigger)) {
            return false;
        }
        AbstractDebeziumTrigger other = (AbstractDebeziumTrigger)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDdl = this.getIgnoreDdl();
        Boolean other$ignoreDdl = other.getIgnoreDdl();
        if (this$ignoreDdl == null ? other$ignoreDdl != null : !((Object)this$ignoreDdl).equals(other$ignoreDdl)) {
            return false;
        }
        Integer this$maxRecords = this.getMaxRecords();
        Integer other$maxRecords = other.getMaxRecords();
        if (this$maxRecords == null ? other$maxRecords != null : !((Object)this$maxRecords).equals(other$maxRecords)) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        AbstractDebeziumTask.Format this$format = this.getFormat();
        AbstractDebeziumTask.Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        AbstractDebeziumTask.Deleted this$deleted = this.getDeleted();
        AbstractDebeziumTask.Deleted other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)((Object)this$deleted)).equals((Object)other$deleted)) {
            return false;
        }
        String this$deletedFieldName = this.getDeletedFieldName();
        String other$deletedFieldName = other.getDeletedFieldName();
        if (this$deletedFieldName == null ? other$deletedFieldName != null : !this$deletedFieldName.equals(other$deletedFieldName)) {
            return false;
        }
        AbstractDebeziumTask.Key this$key = this.getKey();
        AbstractDebeziumTask.Key other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)((Object)this$key)).equals((Object)other$key)) {
            return false;
        }
        AbstractDebeziumTask.Metadata this$metadata = this.getMetadata();
        AbstractDebeziumTask.Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)((Object)this$metadata)).equals((Object)other$metadata)) {
            return false;
        }
        String this$metadataFieldName = this.getMetadataFieldName();
        String other$metadataFieldName = other.getMetadataFieldName();
        if (this$metadataFieldName == null ? other$metadataFieldName != null : !this$metadataFieldName.equals(other$metadataFieldName)) {
            return false;
        }
        AbstractDebeziumTask.SplitTable this$splitTable = this.getSplitTable();
        AbstractDebeziumTask.SplitTable other$splitTable = other.getSplitTable();
        if (this$splitTable == null ? other$splitTable != null : !((Object)((Object)this$splitTable)).equals((Object)other$splitTable)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Object this$includedDatabases = this.getIncludedDatabases();
        Object other$includedDatabases = other.getIncludedDatabases();
        if (this$includedDatabases == null ? other$includedDatabases != null : !this$includedDatabases.equals(other$includedDatabases)) {
            return false;
        }
        Object this$excludedDatabases = this.getExcludedDatabases();
        Object other$excludedDatabases = other.getExcludedDatabases();
        if (this$excludedDatabases == null ? other$excludedDatabases != null : !this$excludedDatabases.equals(other$excludedDatabases)) {
            return false;
        }
        Object this$includedTables = this.getIncludedTables();
        Object other$includedTables = other.getIncludedTables();
        if (this$includedTables == null ? other$includedTables != null : !this$includedTables.equals(other$includedTables)) {
            return false;
        }
        Object this$excludedTables = this.getExcludedTables();
        Object other$excludedTables = other.getExcludedTables();
        if (this$excludedTables == null ? other$excludedTables != null : !this$excludedTables.equals(other$excludedTables)) {
            return false;
        }
        Object this$includedColumns = this.getIncludedColumns();
        Object other$includedColumns = other.getIncludedColumns();
        if (this$includedColumns == null ? other$includedColumns != null : !this$includedColumns.equals(other$includedColumns)) {
            return false;
        }
        Object this$excludedColumns = this.getExcludedColumns();
        Object other$excludedColumns = other.getExcludedColumns();
        if (this$excludedColumns == null ? other$excludedColumns != null : !this$excludedColumns.equals(other$excludedColumns)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$stateName = this.getStateName();
        String other$stateName = other.getStateName();
        if (this$stateName == null ? other$stateName != null : !this$stateName.equals(other$stateName)) {
            return false;
        }
        Duration this$maxDuration = this.getMaxDuration();
        Duration other$maxDuration = other.getMaxDuration();
        if (this$maxDuration == null ? other$maxDuration != null : !((Object)this$maxDuration).equals(other$maxDuration)) {
            return false;
        }
        Duration this$maxWait = this.getMaxWait();
        Duration other$maxWait = other.getMaxWait();
        if (this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait)) {
            return false;
        }
        Duration this$maxSnapshotDuration = this.getMaxSnapshotDuration();
        Duration other$maxSnapshotDuration = other.getMaxSnapshotDuration();
        return !(this$maxSnapshotDuration == null ? other$maxSnapshotDuration != null : !((Object)this$maxSnapshotDuration).equals(other$maxSnapshotDuration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractDebeziumTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDdl = this.getIgnoreDdl();
        result = result * 59 + ($ignoreDdl == null ? 43 : ((Object)$ignoreDdl).hashCode());
        Integer $maxRecords = this.getMaxRecords();
        result = result * 59 + ($maxRecords == null ? 43 : ((Object)$maxRecords).hashCode());
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        AbstractDebeziumTask.Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        AbstractDebeziumTask.Deleted $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)((Object)$deleted)).hashCode());
        String $deletedFieldName = this.getDeletedFieldName();
        result = result * 59 + ($deletedFieldName == null ? 43 : $deletedFieldName.hashCode());
        AbstractDebeziumTask.Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)((Object)$key)).hashCode());
        AbstractDebeziumTask.Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)((Object)$metadata)).hashCode());
        String $metadataFieldName = this.getMetadataFieldName();
        result = result * 59 + ($metadataFieldName == null ? 43 : $metadataFieldName.hashCode());
        AbstractDebeziumTask.SplitTable $splitTable = this.getSplitTable();
        result = result * 59 + ($splitTable == null ? 43 : ((Object)((Object)$splitTable)).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Object $includedDatabases = this.getIncludedDatabases();
        result = result * 59 + ($includedDatabases == null ? 43 : $includedDatabases.hashCode());
        Object $excludedDatabases = this.getExcludedDatabases();
        result = result * 59 + ($excludedDatabases == null ? 43 : $excludedDatabases.hashCode());
        Object $includedTables = this.getIncludedTables();
        result = result * 59 + ($includedTables == null ? 43 : $includedTables.hashCode());
        Object $excludedTables = this.getExcludedTables();
        result = result * 59 + ($excludedTables == null ? 43 : $excludedTables.hashCode());
        Object $includedColumns = this.getIncludedColumns();
        result = result * 59 + ($includedColumns == null ? 43 : $includedColumns.hashCode());
        Object $excludedColumns = this.getExcludedColumns();
        result = result * 59 + ($excludedColumns == null ? 43 : $excludedColumns.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $stateName = this.getStateName();
        result = result * 59 + ($stateName == null ? 43 : $stateName.hashCode());
        Duration $maxDuration = this.getMaxDuration();
        result = result * 59 + ($maxDuration == null ? 43 : ((Object)$maxDuration).hashCode());
        Duration $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        Duration $maxSnapshotDuration = this.getMaxSnapshotDuration();
        result = result * 59 + ($maxSnapshotDuration == null ? 43 : ((Object)$maxSnapshotDuration).hashCode());
        return result;
    }

    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Generated
    public AbstractDebeziumTask.Format getFormat() {
        return this.format;
    }

    @Generated
    public AbstractDebeziumTask.Deleted getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDeletedFieldName() {
        return this.deletedFieldName;
    }

    @Generated
    public AbstractDebeziumTask.Key getKey() {
        return this.key;
    }

    @Generated
    public AbstractDebeziumTask.Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getMetadataFieldName() {
        return this.metadataFieldName;
    }

    @Generated
    public AbstractDebeziumTask.SplitTable getSplitTable() {
        return this.splitTable;
    }

    @Generated
    public Boolean getIgnoreDdl() {
        return this.ignoreDdl;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Object getIncludedDatabases() {
        return this.includedDatabases;
    }

    @Generated
    public Object getExcludedDatabases() {
        return this.excludedDatabases;
    }

    @Generated
    public Object getIncludedTables() {
        return this.includedTables;
    }

    @Generated
    public Object getExcludedTables() {
        return this.excludedTables;
    }

    @Generated
    public Object getIncludedColumns() {
        return this.includedColumns;
    }

    @Generated
    public Object getExcludedColumns() {
        return this.excludedColumns;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public String getStateName() {
        return this.stateName;
    }

    @Generated
    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    @Generated
    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Generated
    public Duration getMaxWait() {
        return this.maxWait;
    }

    @Generated
    public Duration getMaxSnapshotDuration() {
        return this.maxSnapshotDuration;
    }

    @Generated
    public AbstractDebeziumTrigger() {
        this.interval = AbstractDebeziumTrigger.$default$interval();
        this.format = AbstractDebeziumTrigger.$default$format();
        this.deleted = AbstractDebeziumTrigger.$default$deleted();
        this.deletedFieldName = AbstractDebeziumTrigger.$default$deletedFieldName();
        this.key = AbstractDebeziumTrigger.$default$key();
        this.metadata = AbstractDebeziumTrigger.$default$metadata();
        this.metadataFieldName = AbstractDebeziumTrigger.$default$metadataFieldName();
        this.splitTable = AbstractDebeziumTrigger.$default$splitTable();
        this.ignoreDdl = AbstractDebeziumTrigger.$default$ignoreDdl();
        this.stateName = AbstractDebeziumTrigger.$default$stateName();
        this.maxWait = AbstractDebeziumTrigger.$default$maxWait();
        this.maxSnapshotDuration = AbstractDebeziumTrigger.$default$maxSnapshotDuration();
    }

    @Generated
    public static abstract class AbstractDebeziumTriggerBuilder<C extends AbstractDebeziumTrigger, B extends AbstractDebeziumTriggerBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private boolean format$set;
        @Generated
        private AbstractDebeziumTask.Format format$value;
        @Generated
        private boolean deleted$set;
        @Generated
        private AbstractDebeziumTask.Deleted deleted$value;
        @Generated
        private boolean deletedFieldName$set;
        @Generated
        private String deletedFieldName$value;
        @Generated
        private boolean key$set;
        @Generated
        private AbstractDebeziumTask.Key key$value;
        @Generated
        private boolean metadata$set;
        @Generated
        private AbstractDebeziumTask.Metadata metadata$value;
        @Generated
        private boolean metadataFieldName$set;
        @Generated
        private String metadataFieldName$value;
        @Generated
        private boolean splitTable$set;
        @Generated
        private AbstractDebeziumTask.SplitTable splitTable$value;
        @Generated
        private boolean ignoreDdl$set;
        @Generated
        private Boolean ignoreDdl$value;
        @Generated
        private String hostname;
        @Generated
        private String port;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private Object includedDatabases;
        @Generated
        private Object excludedDatabases;
        @Generated
        private Object includedTables;
        @Generated
        private Object excludedTables;
        @Generated
        private Object includedColumns;
        @Generated
        private Object excludedColumns;
        @Generated
        private Map<String, String> properties;
        @Generated
        private boolean stateName$set;
        @Generated
        private String stateName$value;
        @Generated
        private Integer maxRecords;
        @Generated
        private Duration maxDuration;
        @Generated
        private boolean maxWait$set;
        @Generated
        private Duration maxWait$value;
        @Generated
        private boolean maxSnapshotDuration$set;
        @Generated
        private Duration maxSnapshotDuration$value;

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Generated
        public B format(AbstractDebeziumTask.Format format) {
            this.format$value = format;
            this.format$set = true;
            return (B)this.self();
        }

        @Generated
        public B deleted(AbstractDebeziumTask.Deleted deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return (B)this.self();
        }

        @Generated
        public B deletedFieldName(String deletedFieldName) {
            this.deletedFieldName$value = deletedFieldName;
            this.deletedFieldName$set = true;
            return (B)this.self();
        }

        @Generated
        public B key(AbstractDebeziumTask.Key key) {
            this.key$value = key;
            this.key$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadata(AbstractDebeziumTask.Metadata metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadataFieldName(String metadataFieldName) {
            this.metadataFieldName$value = metadataFieldName;
            this.metadataFieldName$set = true;
            return (B)this.self();
        }

        @Generated
        public B splitTable(AbstractDebeziumTask.SplitTable splitTable) {
            this.splitTable$value = splitTable;
            this.splitTable$set = true;
            return (B)this.self();
        }

        @Generated
        public B ignoreDdl(Boolean ignoreDdl) {
            this.ignoreDdl$value = ignoreDdl;
            this.ignoreDdl$set = true;
            return (B)this.self();
        }

        @Generated
        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        @Generated
        public B port(String port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B includedDatabases(Object includedDatabases) {
            this.includedDatabases = includedDatabases;
            return (B)this.self();
        }

        @Generated
        public B excludedDatabases(Object excludedDatabases) {
            this.excludedDatabases = excludedDatabases;
            return (B)this.self();
        }

        @Generated
        public B includedTables(Object includedTables) {
            this.includedTables = includedTables;
            return (B)this.self();
        }

        @Generated
        public B excludedTables(Object excludedTables) {
            this.excludedTables = excludedTables;
            return (B)this.self();
        }

        @Generated
        public B includedColumns(Object includedColumns) {
            this.includedColumns = includedColumns;
            return (B)this.self();
        }

        @Generated
        public B excludedColumns(Object excludedColumns) {
            this.excludedColumns = excludedColumns;
            return (B)this.self();
        }

        @Generated
        public B properties(Map<String, String> properties) {
            this.properties = properties;
            return (B)this.self();
        }

        @Generated
        public B stateName(String stateName) {
            this.stateName$value = stateName;
            this.stateName$set = true;
            return (B)this.self();
        }

        @Generated
        public B maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return (B)this.self();
        }

        @Generated
        public B maxDuration(Duration maxDuration) {
            this.maxDuration = maxDuration;
            return (B)this.self();
        }

        @Generated
        public B maxWait(Duration maxWait) {
            this.maxWait$value = maxWait;
            this.maxWait$set = true;
            return (B)this.self();
        }

        @Generated
        public B maxSnapshotDuration(Duration maxSnapshotDuration) {
            this.maxSnapshotDuration$value = maxSnapshotDuration;
            this.maxSnapshotDuration$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractDebeziumTrigger.AbstractDebeziumTriggerBuilder(super=" + super.toString() + ", interval$value=" + String.valueOf(this.interval$value) + ", format$value=" + String.valueOf((Object)this.format$value) + ", deleted$value=" + String.valueOf((Object)this.deleted$value) + ", deletedFieldName$value=" + this.deletedFieldName$value + ", key$value=" + String.valueOf((Object)this.key$value) + ", metadata$value=" + String.valueOf((Object)this.metadata$value) + ", metadataFieldName$value=" + this.metadataFieldName$value + ", splitTable$value=" + String.valueOf((Object)this.splitTable$value) + ", ignoreDdl$value=" + this.ignoreDdl$value + ", hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", includedDatabases=" + String.valueOf(this.includedDatabases) + ", excludedDatabases=" + String.valueOf(this.excludedDatabases) + ", includedTables=" + String.valueOf(this.includedTables) + ", excludedTables=" + String.valueOf(this.excludedTables) + ", includedColumns=" + String.valueOf(this.includedColumns) + ", excludedColumns=" + String.valueOf(this.excludedColumns) + ", properties=" + String.valueOf(this.properties) + ", stateName$value=" + this.stateName$value + ", maxRecords=" + this.maxRecords + ", maxDuration=" + String.valueOf(this.maxDuration) + ", maxWait$value=" + String.valueOf(this.maxWait$value) + ", maxSnapshotDuration$value=" + String.valueOf(this.maxSnapshotDuration$value) + ")";
        }
    }
}

