/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;

public class Message {
    Source source;
    Map<String, Object> properties;

    @JsonAnyGetter
    public Map<String, Object> getProperties() {
        return this.properties != null ? this.properties : new HashMap<String, Object>();
    }

    @JsonAnySetter
    public void addProperties(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(property, value);
    }

    @Generated
    public Source getSource() {
        return this.source;
    }

    @Generated
    public void setSource(Source source) {
        this.source = source;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Message(source=" + String.valueOf(this.getSource()) + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    @ConstructorProperties(value={"source", "properties"})
    @Generated
    public Message(Source source, Map<String, Object> properties) {
        this.source = source;
        this.properties = properties;
    }

    @Generated
    public Message() {
    }

    public static class Source
    extends Message {
        String version;
        String connector;
        String name;
        @Nullable
        Instant timestamp;
        String snapshot;
        String db;
        String table;
        Integer row;

        @JsonSetter(value="ts_ms")
        public void setTsMs(Long value) {
            this.timestamp = Instant.ofEpochMilli(value);
        }

        @JsonSetter(value="collection")
        public void setCollection(String value) {
            this.table = value;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getConnector() {
            return this.connector;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getSnapshot() {
            return this.snapshot;
        }

        @Generated
        public String getDb() {
            return this.db;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public Integer getRow() {
            return this.row;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setConnector(String connector) {
            this.connector = connector;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setTimestamp(@Nullable Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @Generated
        public void setDb(String db) {
            this.db = db;
        }

        @Generated
        public void setTable(String table) {
            this.table = table;
        }

        @Generated
        public void setRow(Integer row) {
            this.row = row;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            Source other = (Source)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$row = this.getRow();
            Integer other$row = other.getRow();
            if (this$row == null ? other$row != null : !((Object)this$row).equals(other$row)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$connector = this.getConnector();
            String other$connector = other.getConnector();
            if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Instant this$timestamp = this.getTimestamp();
            Instant other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$snapshot = this.getSnapshot();
            String other$snapshot = other.getSnapshot();
            if (this$snapshot == null ? other$snapshot != null : !this$snapshot.equals(other$snapshot)) {
                return false;
            }
            String this$db = this.getDb();
            String other$db = other.getDb();
            if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            return !(this$table == null ? other$table != null : !this$table.equals(other$table));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Source;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $row = this.getRow();
            result = result * 59 + ($row == null ? 43 : ((Object)$row).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $connector = this.getConnector();
            result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Instant $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $snapshot = this.getSnapshot();
            result = result * 59 + ($snapshot == null ? 43 : $snapshot.hashCode());
            String $db = this.getDb();
            result = result * 59 + ($db == null ? 43 : $db.hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "Message.Source(super=" + super.toString() + ", version=" + this.getVersion() + ", connector=" + this.getConnector() + ", name=" + this.getName() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", snapshot=" + this.getSnapshot() + ", db=" + this.getDb() + ", table=" + this.getTable() + ", row=" + this.getRow() + ")";
        }

        @ConstructorProperties(value={"version", "connector", "name", "timestamp", "snapshot", "db", "table", "row"})
        @Generated
        public Source(String version, String connector, String name, @Nullable Instant timestamp, String snapshot, String db, String table, Integer row) {
            this.version = version;
            this.connector = connector;
            this.name = name;
            this.timestamp = timestamp;
            this.snapshot = snapshot;
            this.db = db;
            this.table = table;
            this.row = row;
        }
    }
}

