/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.oracle;

import io.debezium.connector.oracle.OracleConnector;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.oracle.OracleInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import lombok.Generated;

@Schema(title="Wait for change data capture event on Oracle server.")
@Plugin(examples={@Example(title="Non-container database (non-CDB)", code={"snapshotMode: INITIAL", "hostname: 127.0.0.1", "port: \"1521\"", "username: c##dbzuser", "password: dbz", "sid: ORCLCDB", "maxRecords: 100"}), @Example(title="Container database (CDB)", code={"snapshotMode: INITIAL", "hostname: 127.0.0.1", "port: \"1521\"", "username: c##dbzuser", "password: dbz", "sid: ORCLCDB", "pluggableDatabase: ORCLPDB1", "maxRecords: 100"})})
public class Capture
extends AbstractDebeziumTask
implements OracleInterface {
    private OracleInterface.SnapshotMode snapshotMode;
    private String sid;
    private String pluggableDatabase;

    @Override
    protected boolean needDatabaseHistory() {
        return true;
    }

    @Override
    protected Properties properties(RunContext runContext, Path offsetFile, Path historyFile) throws Exception {
        Properties props = super.properties(runContext, offsetFile, historyFile);
        props.setProperty("connector.class", OracleConnector.class.getName());
        props.setProperty("database.dbname", runContext.render(this.sid.toUpperCase(Locale.ROOT)));
        if (this.pluggableDatabase != null) {
            props.setProperty("database.pdb.name", runContext.render(this.pluggableDatabase.toUpperCase(Locale.ROOT)));
        }
        props.setProperty("include.schema.changes", "false");
        props.setProperty("schema.history.internal.store.only.captured.tables.ddl", "false");
        if (this.snapshotMode != null) {
            props.setProperty("snapshot.mode", this.snapshotMode.name().toLowerCase(Locale.ROOT));
        }
        return props;
    }

    @Generated
    private static OracleInterface.SnapshotMode $default$snapshotMode() {
        return OracleInterface.SnapshotMode.INITIAL;
    }

    @Generated
    protected Capture(CaptureBuilder<?, ?> b) {
        super(b);
        this.snapshotMode = b.snapshotMode$set ? b.snapshotMode$value : Capture.$default$snapshotMode();
        this.sid = b.sid;
        this.pluggableDatabase = b.pluggableDatabase;
    }

    @Generated
    public static CaptureBuilder<?, ?> builder() {
        return new CaptureBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Capture(super=" + super.toString() + ", snapshotMode=" + String.valueOf((Object)this.getSnapshotMode()) + ", sid=" + this.getSid() + ", pluggableDatabase=" + this.getPluggableDatabase() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capture)) {
            return false;
        }
        Capture other = (Capture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OracleInterface.SnapshotMode this$snapshotMode = this.getSnapshotMode();
        OracleInterface.SnapshotMode other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !((Object)((Object)this$snapshotMode)).equals((Object)other$snapshotMode)) {
            return false;
        }
        String this$sid = this.getSid();
        String other$sid = other.getSid();
        if (this$sid == null ? other$sid != null : !this$sid.equals(other$sid)) {
            return false;
        }
        String this$pluggableDatabase = this.getPluggableDatabase();
        String other$pluggableDatabase = other.getPluggableDatabase();
        return !(this$pluggableDatabase == null ? other$pluggableDatabase != null : !this$pluggableDatabase.equals(other$pluggableDatabase));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Capture;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OracleInterface.SnapshotMode $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : ((Object)((Object)$snapshotMode)).hashCode());
        String $sid = this.getSid();
        result = result * 59 + ($sid == null ? 43 : $sid.hashCode());
        String $pluggableDatabase = this.getPluggableDatabase();
        result = result * 59 + ($pluggableDatabase == null ? 43 : $pluggableDatabase.hashCode());
        return result;
    }

    @Override
    @Generated
    public OracleInterface.SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    @Override
    @Generated
    public String getSid() {
        return this.sid;
    }

    @Override
    @Generated
    public String getPluggableDatabase() {
        return this.pluggableDatabase;
    }

    @Generated
    public Capture() {
        this.snapshotMode = Capture.$default$snapshotMode();
    }

    @Generated
    public static abstract class CaptureBuilder<C extends Capture, B extends CaptureBuilder<C, B>>
    extends AbstractDebeziumTask.AbstractDebeziumTaskBuilder<C, B> {
        @Generated
        private boolean snapshotMode$set;
        @Generated
        private OracleInterface.SnapshotMode snapshotMode$value;
        @Generated
        private String sid;
        @Generated
        private String pluggableDatabase;

        @Generated
        public B snapshotMode(OracleInterface.SnapshotMode snapshotMode) {
            this.snapshotMode$value = snapshotMode;
            this.snapshotMode$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B sid(String sid) {
            this.sid = sid;
            return (B)((Object)this.self());
        }

        @Generated
        public B pluggableDatabase(String pluggableDatabase) {
            this.pluggableDatabase = pluggableDatabase;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Capture.CaptureBuilder(super=" + super.toString() + ", snapshotMode$value=" + String.valueOf((Object)this.snapshotMode$value) + ", sid=" + this.sid + ", pluggableDatabase=" + this.pluggableDatabase + ")";
        }
    }

    @Generated
    private static final class CaptureBuilderImpl
    extends CaptureBuilder<Capture, CaptureBuilderImpl> {
        @Generated
        private CaptureBuilderImpl() {
        }

        @Override
        @Generated
        protected CaptureBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Capture build() {
            return new Capture(this);
        }
    }
}

