/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.oracle;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.plugin.debezium.AbstractDebeziumInterface;
import io.kestra.plugin.debezium.AbstractDebeziumRealtimeTrigger;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.oracle.Capture;
import io.kestra.plugin.debezium.oracle.OracleInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Schema(title="Consume a message in real-time from a Oracle database via change data capture and create one execution per row.", description="If you would like to consume multiple messages processed within a given time frame and process them in batch, you can use the [io.kestra.plugin.debezium.oracle.Trigger](https://kestra.io/plugins/plugin-debezium/triggers/io.kestra.plugin.debezium.oracle.trigger) instead.")
@Plugin(examples={@Example(title="Consume a message from a Oracle database via change data capture in real-time.", full=true, code={"id: debezium-oracle\nnamespace: company.team\n\ntasks:\n  - id: send_data\n    type: io.kestra.plugin.core.log.Log\n    message: \"{{ trigger.data }}\"\n\ntriggers:\n  - id: realtime\n    type: io.kestra.plugin.debezium.oracle.RealtimeTrigger\n    hostname: 127.0.0.1\n    port: 1521\n    username: c##dbzuser\n    password: dbz\n    sid: ORCLCDB\n"})})
public class RealtimeTrigger
extends AbstractDebeziumRealtimeTrigger
implements OracleInterface,
AbstractDebeziumInterface {
    private OracleInterface.SnapshotMode snapshotMode;
    private String sid;
    private String pluggableDatabase;

    public Publisher<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        AbstractDebeziumTask task = ((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((AbstractDebeziumTask.AbstractDebeziumTaskBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Capture.CaptureBuilder)Capture.builder().id(this.id)).type(Capture.class.getName())).format(this.format))).deleted(this.deleted))).deletedFieldName(this.deletedFieldName))).key(this.key))).metadata(this.metadata))).metadataFieldName(this.metadataFieldName))).splitTable(this.splitTable))).ignoreDdl(this.ignoreDdl))).hostname(this.hostname))).port(this.port))).username(this.username))).password(this.password))).sid(this.sid))).pluggableDatabase(this.pluggableDatabase))).includedDatabases(this.includedDatabases))).excludedDatabases(this.excludedDatabases))).includedTables(this.includedTables))).excludedTables(this.excludedTables))).includedColumns(this.includedColumns))).excludedColumns(this.excludedColumns))).properties(this.properties))).stateName(this.stateName))).snapshotMode(this.snapshotMode))).build();
        return Flux.from(this.publisher(task, conditionContext.getRunContext())).map(output -> TriggerService.generateRealtimeExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, (Output)output));
    }

    @Generated
    private static OracleInterface.SnapshotMode $default$snapshotMode() {
        return OracleInterface.SnapshotMode.INITIAL;
    }

    @Generated
    protected RealtimeTrigger(RealtimeTriggerBuilder<?, ?> b) {
        super(b);
        this.snapshotMode = b.snapshotMode$set ? b.snapshotMode$value : RealtimeTrigger.$default$snapshotMode();
        this.sid = b.sid;
        this.pluggableDatabase = b.pluggableDatabase;
    }

    @Generated
    public static RealtimeTriggerBuilder<?, ?> builder() {
        return new RealtimeTriggerBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "RealtimeTrigger(super=" + super.toString() + ", snapshotMode=" + String.valueOf((Object)this.getSnapshotMode()) + ", sid=" + this.getSid() + ", pluggableDatabase=" + this.getPluggableDatabase() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealtimeTrigger)) {
            return false;
        }
        RealtimeTrigger other = (RealtimeTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OracleInterface.SnapshotMode this$snapshotMode = this.getSnapshotMode();
        OracleInterface.SnapshotMode other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !((Object)((Object)this$snapshotMode)).equals((Object)other$snapshotMode)) {
            return false;
        }
        String this$sid = this.getSid();
        String other$sid = other.getSid();
        if (this$sid == null ? other$sid != null : !this$sid.equals(other$sid)) {
            return false;
        }
        String this$pluggableDatabase = this.getPluggableDatabase();
        String other$pluggableDatabase = other.getPluggableDatabase();
        return !(this$pluggableDatabase == null ? other$pluggableDatabase != null : !this$pluggableDatabase.equals(other$pluggableDatabase));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RealtimeTrigger;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OracleInterface.SnapshotMode $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : ((Object)((Object)$snapshotMode)).hashCode());
        String $sid = this.getSid();
        result = result * 59 + ($sid == null ? 43 : $sid.hashCode());
        String $pluggableDatabase = this.getPluggableDatabase();
        result = result * 59 + ($pluggableDatabase == null ? 43 : $pluggableDatabase.hashCode());
        return result;
    }

    @Override
    @Generated
    public OracleInterface.SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    @Override
    @Generated
    public String getSid() {
        return this.sid;
    }

    @Override
    @Generated
    public String getPluggableDatabase() {
        return this.pluggableDatabase;
    }

    @Generated
    public RealtimeTrigger() {
        this.snapshotMode = RealtimeTrigger.$default$snapshotMode();
    }

    @Generated
    public static abstract class RealtimeTriggerBuilder<C extends RealtimeTrigger, B extends RealtimeTriggerBuilder<C, B>>
    extends AbstractDebeziumRealtimeTrigger.AbstractDebeziumRealtimeTriggerBuilder<C, B> {
        @Generated
        private boolean snapshotMode$set;
        @Generated
        private OracleInterface.SnapshotMode snapshotMode$value;
        @Generated
        private String sid;
        @Generated
        private String pluggableDatabase;

        @Generated
        public B snapshotMode(OracleInterface.SnapshotMode snapshotMode) {
            this.snapshotMode$value = snapshotMode;
            this.snapshotMode$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B sid(String sid) {
            this.sid = sid;
            return (B)((Object)this.self());
        }

        @Generated
        public B pluggableDatabase(String pluggableDatabase) {
            this.pluggableDatabase = pluggableDatabase;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RealtimeTrigger.RealtimeTriggerBuilder(super=" + super.toString() + ", snapshotMode$value=" + String.valueOf((Object)this.snapshotMode$value) + ", sid=" + this.sid + ", pluggableDatabase=" + this.pluggableDatabase + ")";
        }
    }

    @Generated
    private static final class RealtimeTriggerBuilderImpl
    extends RealtimeTriggerBuilder<RealtimeTrigger, RealtimeTriggerBuilderImpl> {
        @Generated
        private RealtimeTriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected RealtimeTriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RealtimeTrigger build() {
            return new RealtimeTrigger(this);
        }
    }
}

