/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.oracle;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.debezium.AbstractDebeziumInterface;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.AbstractDebeziumTrigger;
import io.kestra.plugin.debezium.oracle.Capture;
import io.kestra.plugin.debezium.oracle.OracleInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Consume messages periodically from a Oracle database via change data capture and create one execution per batch.", description="If you would like to consume each message from change data capture in real-time and create one execution per message, you can use the [io.kestra.plugin.debezium.oracle.RealtimeTrigger](https://kestra.io/plugins/plugin-debezium/triggers/io.kestra.plugin.debezium.oracle.realtimetrigger) instead.")
@Plugin(examples={@Example(code={"snapshotMode: INITIAL_ONLY", "hostname: 127.0.0.1", "port: \"1521\"", "username: c##dbzuser", "password: dbz", "sid: ORCLCDB", "maxRecords: 100"})})
public class Trigger
extends AbstractDebeziumTrigger
implements OracleInterface,
AbstractDebeziumInterface {
    private OracleInterface.SnapshotMode snapshotMode;
    private String sid;
    private String pluggableDatabase;

    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        RunContext runContext = conditionContext.getRunContext();
        Logger logger2 = runContext.logger();
        AbstractDebeziumTask task = ((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((AbstractDebeziumTask.AbstractDebeziumTaskBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Capture.CaptureBuilder)Capture.builder().id(this.id)).type(Capture.class.getName())).format(this.format))).deleted(this.deleted))).deletedFieldName(this.deletedFieldName))).key(this.key))).metadata(this.metadata))).metadataFieldName(this.metadataFieldName))).splitTable(this.splitTable))).ignoreDdl(this.ignoreDdl))).hostname(this.hostname))).port(this.port))).username(this.username))).password(this.password))).sid(this.sid))).pluggableDatabase(this.pluggableDatabase))).includedDatabases(this.includedDatabases))).excludedDatabases(this.excludedDatabases))).includedTables(this.includedTables))).excludedTables(this.excludedTables))).includedColumns(this.includedColumns))).excludedColumns(this.excludedColumns))).properties(this.properties))).stateName(this.stateName))).maxRecords(this.maxRecords))).maxDuration(this.maxDuration))).maxWait(this.maxWait))).maxSnapshotDuration(this.maxSnapshotDuration))).snapshotMode(this.snapshotMode))).build();
        AbstractDebeziumTask.Output run = task.run(runContext);
        if (logger2.isDebugEnabled()) {
            logger2.debug("Found '{}' messages", (Object)run.getSize());
        }
        if (run.getSize() == 0) {
            return Optional.empty();
        }
        Execution execution = TriggerService.generateExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, (Output)run);
        return Optional.of(execution);
    }

    @Generated
    private static OracleInterface.SnapshotMode $default$snapshotMode() {
        return OracleInterface.SnapshotMode.INITIAL;
    }

    @Generated
    protected Trigger(TriggerBuilder<?, ?> b) {
        super(b);
        this.snapshotMode = b.snapshotMode$set ? b.snapshotMode$value : Trigger.$default$snapshotMode();
        this.sid = b.sid;
        this.pluggableDatabase = b.pluggableDatabase;
    }

    @Generated
    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ", snapshotMode=" + String.valueOf((Object)this.getSnapshotMode()) + ", sid=" + this.getSid() + ", pluggableDatabase=" + this.getPluggableDatabase() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OracleInterface.SnapshotMode this$snapshotMode = this.getSnapshotMode();
        OracleInterface.SnapshotMode other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !((Object)((Object)this$snapshotMode)).equals((Object)other$snapshotMode)) {
            return false;
        }
        String this$sid = this.getSid();
        String other$sid = other.getSid();
        if (this$sid == null ? other$sid != null : !this$sid.equals(other$sid)) {
            return false;
        }
        String this$pluggableDatabase = this.getPluggableDatabase();
        String other$pluggableDatabase = other.getPluggableDatabase();
        return !(this$pluggableDatabase == null ? other$pluggableDatabase != null : !this$pluggableDatabase.equals(other$pluggableDatabase));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OracleInterface.SnapshotMode $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : ((Object)((Object)$snapshotMode)).hashCode());
        String $sid = this.getSid();
        result = result * 59 + ($sid == null ? 43 : $sid.hashCode());
        String $pluggableDatabase = this.getPluggableDatabase();
        result = result * 59 + ($pluggableDatabase == null ? 43 : $pluggableDatabase.hashCode());
        return result;
    }

    @Override
    @Generated
    public OracleInterface.SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    @Override
    @Generated
    public String getSid() {
        return this.sid;
    }

    @Override
    @Generated
    public String getPluggableDatabase() {
        return this.pluggableDatabase;
    }

    @Generated
    public Trigger() {
        this.snapshotMode = Trigger.$default$snapshotMode();
    }

    @Generated
    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends AbstractDebeziumTrigger.AbstractDebeziumTriggerBuilder<C, B> {
        @Generated
        private boolean snapshotMode$set;
        @Generated
        private OracleInterface.SnapshotMode snapshotMode$value;
        @Generated
        private String sid;
        @Generated
        private String pluggableDatabase;

        @Generated
        public B snapshotMode(OracleInterface.SnapshotMode snapshotMode) {
            this.snapshotMode$value = snapshotMode;
            this.snapshotMode$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B sid(String sid) {
            this.sid = sid;
            return (B)((Object)this.self());
        }

        @Generated
        public B pluggableDatabase(String pluggableDatabase) {
            this.pluggableDatabase = pluggableDatabase;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ", snapshotMode$value=" + String.valueOf((Object)this.snapshotMode$value) + ", sid=" + this.sid + ", pluggableDatabase=" + this.pluggableDatabase + ")";
        }
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

