/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletionStageConsumer<T>
extends CompletableFuture<T>
implements MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver {
    final AtomicReference<Disposable> upstream;
    final boolean hasDefault;
    final T defaultItem;

    public CompletionStageConsumer(boolean hasDefault, T defaultItem) {
        this.hasDefault = hasDefault;
        this.defaultItem = defaultItem;
        this.upstream = new AtomicReference();
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {
        DisposableHelper.setOnce(this.upstream, d);
    }

    @Override
    public void onSuccess(@NonNull T t2) {
        this.clear();
        this.complete(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.clear();
        if (!this.completeExceptionally(t2)) {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.hasDefault) {
            this.complete(this.defaultItem);
        } else {
            this.completeExceptionally(new NoSuchElementException("The source was empty"));
        }
    }

    void cancelUpstream() {
        DisposableHelper.dispose(this.upstream);
    }

    void clear() {
        this.upstream.lazySet(DisposableHelper.DISPOSED);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelUpstream();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean complete(T value) {
        this.cancelUpstream();
        return super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.cancelUpstream();
        return super.completeExceptionally(ex);
    }
}

