/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;

public final class MaybeFlattenStreamAsFlowable<T, R>
extends Flowable<R> {
    final Maybe<T> source;
    final Function<? super T, ? extends Stream<? extends R>> mapper;

    public MaybeFlattenStreamAsFlowable(Maybe<T> source, Function<? super T, ? extends Stream<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super R> s2) {
        this.source.subscribe(new FlattenStreamMultiObserver<T, R>(s2, this.mapper));
    }

    static final class FlattenStreamMultiObserver<T, R>
    extends BasicIntQueueSubscription<R>
    implements MaybeObserver<T>,
    SingleObserver<T> {
        private static final long serialVersionUID = 7363336003027148283L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Stream<? extends R>> mapper;
        final AtomicLong requested;
        Disposable upstream;
        volatile Iterator<? extends R> iterator;
        AutoCloseable close;
        boolean once;
        volatile boolean cancelled;
        boolean outputFused;
        long emitted;

        FlattenStreamMultiObserver(Subscriber<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@NonNull T t2) {
            try {
                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Stream");
                Iterator iterator = stream.iterator();
                Stream<R> c = stream;
                if (!iterator.hasNext()) {
                    this.downstream.onComplete();
                    this.close(c);
                    return;
                }
                this.iterator = iterator;
                this.close = stream;
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            this.drain();
        }

        @Override
        public void onError(@NonNull Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.dispose();
            if (!this.outputFused) {
                this.drain();
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public R poll() throws Throwable {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (this.once) {
                    if (!it.hasNext()) {
                        this.clear();
                        return null;
                    }
                } else {
                    this.once = true;
                }
                return it.next();
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (!this.once) {
                    return false;
                }
                if (it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable close = this.close;
            this.close = null;
            this.close(close);
        }

        void close(AutoCloseable c) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> downstream = this.downstream;
            long emitted = this.emitted;
            long requested = this.requested.get();
            Iterator<R> it = this.iterator;
            while (true) {
                if (this.cancelled) {
                    this.clear();
                } else if (this.outputFused) {
                    if (it != null) {
                        downstream.onNext(null);
                        downstream.onComplete();
                    }
                } else if (it != null && emitted != requested) {
                    boolean has;
                    R item;
                    try {
                        item = it.next();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    if (this.cancelled) continue;
                    downstream.onNext(item);
                    ++emitted;
                    if (this.cancelled) continue;
                    try {
                        has = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    if (this.cancelled || has) continue;
                    downstream.onComplete();
                    this.cancelled = true;
                    continue;
                }
                this.emitted = emitted;
                missed = this.addAndGet(-missed);
                if (missed == 0) {
                    return;
                }
                requested = this.requested.get();
                if (it != null) continue;
                it = this.iterator;
            }
        }
    }
}

