/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCount<T>
extends AbstractFlowableWithUpstream<T, Long> {
    public FlowableCount(Flowable<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super Long> s2) {
        this.source.subscribe(new CountSubscriber(s2));
    }

    static final class CountSubscriber
    extends DeferredScalarSubscription<Long>
    implements FlowableSubscriber<Object> {
        private static final long serialVersionUID = 4973004223787171406L;
        Subscription upstream;
        long count;

        CountSubscriber(Subscriber<? super Long> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(Object t2) {
            ++this.count;
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            this.complete(this.count);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

