/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;

public final class FlowableDoOnEach<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;

    public FlowableDoOnEach(Flowable<T> source, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        super(source);
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoOnEachConditionalSubscriber<T>((ConditionalSubscriber)s2, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        } else {
            this.source.subscribe(new DoOnEachSubscriber<T>(s2, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        }
    }

    static final class DoOnEachConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t2);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.downstream.onNext(t2);
        }

        @Override
        public boolean tryOnNext(T t2) {
            if (this.done) {
                return false;
            }
            try {
                this.onNext.accept(t2);
            }
            catch (Throwable e) {
                this.fail(e);
                return false;
            }
            return this.downstream.tryOnNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept(t2);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t2, e));
                relay = false;
            }
            if (relay) {
                this.downstream.onError(t2);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.downstream.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            block13: {
                try {
                    v = this.qs.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    try {
                        this.onError.accept(ex);
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        throw new CompositeException(ex, exc);
                    }
                    throw ExceptionHelper.throwIfThrowable(ex);
                }
                if (v != null) {
                    try {
                        try {
                            this.onNext.accept(v);
                            break block13;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            try {
                                this.onError.accept(ex);
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                throw new CompositeException(ex, exc);
                            }
                            throw ExceptionHelper.throwIfThrowable(ex);
                        }
                    }
                    finally {
                        this.onAfterTerminate.run();
                    }
                }
                if (this.sourceMode == 1) {
                    this.onComplete.run();
                    this.onAfterTerminate.run();
                }
            }
            return v;
        }
    }

    static final class DoOnEachSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachSubscriber(Subscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t2);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept(t2);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t2, e));
                relay = false;
            }
            if (relay) {
                this.downstream.onError(t2);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.downstream.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            block13: {
                try {
                    v = this.qs.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    try {
                        this.onError.accept(ex);
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        throw new CompositeException(ex, exc);
                    }
                    throw ExceptionHelper.throwIfThrowable(ex);
                }
                if (v != null) {
                    try {
                        try {
                            this.onNext.accept(v);
                            break block13;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            try {
                                this.onError.accept(ex);
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                throw new CompositeException(ex, exc);
                            }
                            throw ExceptionHelper.throwIfThrowable(ex);
                        }
                    }
                    finally {
                        this.onAfterTerminate.run();
                    }
                }
                if (this.sourceMode == 1) {
                    this.onComplete.run();
                    this.onAfterTerminate.run();
                }
            }
            return v;
        }
    }
}

