/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends Publisher<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public FlowableFlatMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s2) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s2, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableFlatMap.subscribe(s2, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    public static <T, U> FlowableSubscriber<T> subscribe(Subscriber<? super U> s2, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        return new MergeSubscriber<T, U>(s2, mapper, delayErrors, maxConcurrency, bufferSize);
    }

    static final class InnerSubscriber<T, U>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<U>,
    Disposable {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeSubscriber<T, U> parent;
        final int limit;
        final int bufferSize;
        volatile boolean done;
        volatile SimpleQueue<U> queue;
        long produced;
        int fusionMode;

        InnerSubscriber(MergeSubscriber<T, U> parent, int bufferSize, long id) {
            this.id = id;
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.limit = bufferSize >> 2;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.setOnce(this, s2)) {
                if (s2 instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s2;
                    int m4 = qs.requestFusion(7);
                    if (m4 == 1) {
                        this.fusionMode = m4;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m4 == 2) {
                        this.fusionMode = m4;
                        this.queue = qs;
                    }
                }
                s2.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(U t2) {
            if (this.fusionMode != 2) {
                this.parent.tryEmit(t2, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            this.parent.innerError(this, t2);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        void requestMore(long n) {
            if (this.fusionMode != 1) {
                long p = this.produced + n;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class MergeSubscriber<T, U>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -2117620485640801370L;
        final Subscriber<? super U> downstream;
        final Function<? super T, ? extends Publisher<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimplePlainQueue<U> queue;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        volatile boolean cancelled;
        final AtomicReference<InnerSubscriber<?, ?>[]> subscribers = new AtomicReference();
        static final InnerSubscriber<?, ?>[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber<?, ?>[] CANCELLED = new InnerSubscriber[0];
        final AtomicLong requested = new AtomicLong();
        Subscription upstream;
        long uniqueId;
        long lastId;
        int lastIndex;
        int scalarEmitted;
        final int scalarLimit;

        MergeSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            this.scalarLimit = Math.max(1, maxConcurrency >> 1);
            this.subscribers.lazySet(EMPTY);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) {
                        s2.request(Long.MAX_VALUE);
                    } else {
                        s2.request(this.maxConcurrency);
                    }
                }
            }
        }

        @Override
        public void onNext(T t2) {
            InnerSubscriber inner;
            Publisher<U> p;
            if (this.done) {
                return;
            }
            try {
                p = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.upstream.cancel();
                this.onError(e);
                return;
            }
            if (p instanceof Supplier) {
                Object u;
                try {
                    u = ((Supplier)((Object)p)).get();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.errors.tryAddThrowableOrReport(ex);
                    this.drain();
                    return;
                }
                if (u != null) {
                    this.tryEmitScalar(u);
                } else if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                    this.scalarEmitted = 0;
                    this.upstream.request(this.scalarLimit);
                }
            } else if (this.addInner(inner = new InnerSubscriber(this, this.bufferSize, this.uniqueId++))) {
                p.subscribe(inner);
            }
        }

        boolean addInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                if ((a = this.subscribers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n = a.length;
                b = new InnerSubscriber[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void removeInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber<?, ?>[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                int n;
                if ((n = (a = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new InnerSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        SimpleQueue<U> getMainQueue() {
            SimplePlainQueue<U> q = this.queue;
            if (q == null) {
                q = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q;
            }
            return q;
        }

        void tryEmitScalar(U value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested.get();
                SimpleQueue<U> q = this.queue;
                if (r != 0L && (q == null || q.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                        this.scalarEmitted = 0;
                        this.upstream.request(this.scalarLimit);
                    }
                } else {
                    if (q == null) {
                        q = this.getMainQueue();
                    }
                    if (!q.offer(value)) {
                        this.onError(new QueueOverflowException());
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue<U> q = this.getMainQueue();
                if (!q.offer(value)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void tryEmit(U value, InnerSubscriber<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested.get();
                SimpleQueue q = inner.queue;
                if (r != 0L && (q == null || q.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.requestMore(1L);
                } else {
                    if (q == null) {
                        q = new SpscArrayQueue(this.bufferSize);
                        inner.queue = q;
                    }
                    if (!q.offer(value)) {
                        this.onError(new QueueOverflowException());
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue q = inner.queue;
                if (q == null) {
                    q = new SpscArrayQueue(this.bufferSize);
                    inner.queue = q;
                }
                if (!q.offer(value)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                if (!this.delayErrors) {
                    for (InnerSubscriber<?, ?> a : this.subscribers.getAndSet(CANCELLED)) {
                        a.dispose();
                    }
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                SimplePlainQueue<U> q;
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeAll();
                if (this.getAndIncrement() == 0 && (q = this.queue) != null) {
                    q.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            boolean innerCompleted;
            Subscriber<U> child = this.downstream;
            int missed = 1;
            do {
                if (this.checkTerminate()) {
                    return;
                }
                SimplePlainQueue<U> svq = this.queue;
                long r = this.requested.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long replenishMain = 0L;
                if (svq != null) {
                    long scalarEmission = 0L;
                    Object o = null;
                    while (r != 0L) {
                        o = svq.poll();
                        if (this.checkTerminate()) {
                            return;
                        }
                        if (o == null) break;
                        child.onNext(o);
                        ++replenishMain;
                        ++scalarEmission;
                        --r;
                    }
                    if (scalarEmission != 0L) {
                        r = unbounded ? Long.MAX_VALUE : this.requested.addAndGet(-scalarEmission);
                    }
                }
                boolean d = this.done;
                svq = this.queue;
                InnerSubscriber<?, ?>[] inner = this.subscribers.get();
                int n = inner.length;
                if (d && (svq == null || svq.isEmpty()) && n == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                innerCompleted = false;
                if (n != 0) {
                    int i;
                    int j;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n <= index || inner[index].id != startId) {
                        if (n <= index) {
                            index = 0;
                        }
                        j = index;
                        for (i = 0; i < n && inner[j].id != startId; ++i) {
                            if (++j != n) continue;
                            j = 0;
                        }
                        index = j;
                        this.lastIndex = j;
                        this.lastId = inner[j].id;
                    }
                    j = index;
                    block5: for (i = 0; i < n; ++i) {
                        SimpleQueue q;
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerSubscriber<?, ?> is = inner[j];
                        Object o = null;
                        while ((q = is.queue) != null) {
                            long produced = 0L;
                            while (r != 0L) {
                                if (this.checkTerminate()) {
                                    return;
                                }
                                try {
                                    o = q.poll();
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal(ex);
                                    is.dispose();
                                    this.errors.tryAddThrowableOrReport(ex);
                                    if (!this.delayErrors) {
                                        this.upstream.cancel();
                                    }
                                    if (this.checkTerminate()) {
                                        return;
                                    }
                                    this.removeInner(is);
                                    innerCompleted = true;
                                    ++i;
                                    continue block5;
                                }
                                if (o == null) break;
                                child.onNext(o);
                                --r;
                                ++produced;
                            }
                            if (produced != 0L) {
                                r = !unbounded ? this.requested.addAndGet(-produced) : Long.MAX_VALUE;
                                is.requestMore(produced);
                            }
                            if (r != 0L && o != null) continue;
                            break;
                        }
                        boolean innerDone = is.done;
                        SimpleQueue innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            if (this.checkTerminate()) {
                                return;
                            }
                            ++replenishMain;
                            innerCompleted = true;
                        }
                        if (r == 0L) break;
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                    this.lastId = inner[j].id;
                }
                if (replenishMain == 0L || this.cancelled) continue;
                this.upstream.request(replenishMain);
            } while (innerCompleted || (missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminate() {
            if (this.cancelled) {
                this.clearScalarQueue();
                return true;
            }
            if (!this.delayErrors && this.errors.get() != null) {
                this.clearScalarQueue();
                this.errors.tryTerminateConsumer(this.downstream);
                return true;
            }
            return false;
        }

        void clearScalarQueue() {
            SimplePlainQueue<U> q = this.queue;
            if (q != null) {
                q.clear();
            }
        }

        void disposeAll() {
            InnerSubscriber<?, ?>[] a = this.subscribers.getAndSet(CANCELLED);
            if (a != CANCELLED) {
                for (InnerSubscriber<?, ?> inner : a) {
                    inner.dispose();
                }
                this.errors.tryTerminateAndReport();
            }
        }

        void innerError(InnerSubscriber<T, U> inner, Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                inner.done = true;
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    for (InnerSubscriber<?, ?> a : this.subscribers.getAndSet(CANCELLED)) {
                        a.dispose();
                    }
                }
                this.drain();
            }
        }
    }
}

