/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBuffer<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int bufferSize;
    final boolean unbounded;
    final boolean delayError;
    final Action onOverflow;
    final Consumer<? super T> onDropped;

    public FlowableOnBackpressureBuffer(Flowable<T> source, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow, Consumer<? super T> onDropped) {
        super(source);
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.delayError = delayError;
        this.onOverflow = onOverflow;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new BackpressureBufferSubscriber<T>(s2, this.bufferSize, this.unbounded, this.delayError, this.onOverflow, this.onDropped));
    }

    static final class BackpressureBufferSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -2514538129242366402L;
        final Subscriber<? super T> downstream;
        final SimplePlainQueue<T> queue;
        final boolean delayError;
        final Action onOverflow;
        final Consumer<? super T> onDropped;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        boolean outputFused;

        BackpressureBufferSubscriber(Subscriber<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.onOverflow = onOverflow;
            this.delayError = delayError;
            this.onDropped = onDropped;
            SimplePlainQueue<Object> q = unbounded ? new SpscLinkedArrayQueue(bufferSize) : new SpscArrayQueue(bufferSize);
            this.queue = q;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.queue.offer(t2)) {
                this.upstream.cancel();
                MissingBackpressureException ex = new MissingBackpressureException("Buffer is full");
                try {
                    this.onOverflow.run();
                    this.onDropped.accept(t2);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    ex.initCause(e);
                }
                this.onError(ex);
                return;
            }
            if (this.outputFused) {
                this.downstream.onNext(null);
            } else {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            if (this.outputFused) {
                this.downstream.onError(t2);
            } else {
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.outputFused) {
                this.downstream.onComplete();
            } else {
                this.drain();
            }
        }

        @Override
        public void request(long n) {
            if (!this.outputFused && SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (!this.outputFused && this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            block5: {
                if (this.getAndIncrement() != 0) break block5;
                int missed = 1;
                SimplePlainQueue<T> q = this.queue;
                Subscriber<T> a = this.downstream;
                do {
                    boolean empty;
                    boolean d;
                    long e;
                    if (this.checkTerminated(this.done, q.isEmpty(), a)) {
                        return;
                    }
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty2;
                        d = this.done;
                        T v = q.poll();
                        boolean bl = empty2 = v == null;
                        if (this.checkTerminated(d, empty2, a)) {
                            return;
                        }
                        if (empty2) break;
                        a.onNext(v);
                    }
                    if (e == r && this.checkTerminated(d = this.done, empty = q.isEmpty(), a)) {
                        return;
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-e);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            return this.queue.poll();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

