/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractBackpressureThrottlingSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import org.reactivestreams.Subscriber;

public final class FlowableOnBackpressureLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onDropped;

    public FlowableOnBackpressureLatest(Flowable<T> source, Consumer<? super T> onDropped) {
        super(source);
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new BackpressureLatestSubscriber<T>(s2, this.onDropped));
    }

    static final class BackpressureLatestSubscriber<T>
    extends AbstractBackpressureThrottlingSubscriber<T, T> {
        private static final long serialVersionUID = 163080509307634843L;
        final Consumer<? super T> onDropped;

        BackpressureLatestSubscriber(Subscriber<? super T> downstream, Consumer<? super T> onDropped) {
            super(downstream);
            this.onDropped = onDropped;
        }

        @Override
        public void onNext(T t2) {
            T oldValue = this.current.getAndSet(t2);
            if (this.onDropped != null && oldValue != null) {
                try {
                    this.onDropped.accept(oldValue);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    this.downstream.onError(ex);
                }
            }
            this.drain();
        }
    }
}

