/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSingle<T>
extends AbstractFlowableWithUpstream<T, T> {
    final T defaultValue;
    final boolean failOnEmpty;

    public FlowableSingle(Flowable<T> source, T defaultValue, boolean failOnEmpty) {
        super(source);
        this.defaultValue = defaultValue;
        this.failOnEmpty = failOnEmpty;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new SingleElementSubscriber<T>(s2, this.defaultValue, this.failOnEmpty));
    }

    static final class SingleElementSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -5526049321428043809L;
        final T defaultValue;
        final boolean failOnEmpty;
        Subscription upstream;
        boolean done;

        SingleElementSubscriber(Subscriber<? super T> actual, T defaultValue, boolean failOnEmpty) {
            super(actual);
            this.defaultValue = defaultValue;
            this.failOnEmpty = failOnEmpty;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.upstream.cancel();
                this.downstream.onError(new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t2;
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object v = this.value;
            this.value = null;
            if (v == null) {
                v = this.defaultValue;
            }
            if (v == null) {
                if (this.failOnEmpty) {
                    this.downstream.onError(new NoSuchElementException());
                } else {
                    this.downstream.onComplete();
                }
            } else {
                this.complete(v);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

