/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSkipLastTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public FlowableSkipLastTimed(Flowable<T> source, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new SkipLastTimedSubscriber<T>(s2, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class SkipLastTimedSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5677354903406201275L;
        final Subscriber<? super T> downstream;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Subscription upstream;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        SkipLastTimedSubscriber(Subscriber<? super T> actual, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            long now = this.scheduler.now(this.unit);
            this.queue.offer(now, t2);
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Object> a = this.downstream;
            SpscLinkedArrayQueue<Object> q = this.queue;
            boolean delayError = this.delayError;
            TimeUnit unit = this.unit;
            Scheduler scheduler = this.scheduler;
            long time = this.time;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean d = this.done;
                    Long ts = (Long)q.peek();
                    boolean empty = ts == null;
                    long now = scheduler.now(unit);
                    if (!empty && ts > now - time) {
                        empty = true;
                    }
                    if (this.checkTerminated(d, empty, a, delayError)) {
                        return;
                    }
                    if (empty) break;
                    q.poll();
                    Object v = q.poll();
                    a.onNext(v);
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(this.requested, e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, boolean delayError) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

