/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainSubscriber;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.SimpleQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapMaybe<T, R>
extends Flowable<R> {
    final Flowable<T> source;
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public FlowableConcatMapMaybe(Flowable<T> source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        this.source.subscribe(new ConcatMapMaybeSubscriber<T, R>(s2, this.mapper, this.prefetch, this.errorMode));
    }

    static final class ConcatMapMaybeSubscriber<T, R>
    extends ConcatMapXMainSubscriber<T>
    implements Subscription {
        private static final long serialVersionUID = -9140123220065488293L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final AtomicLong requested;
        final ConcatMapMaybeObserver<R> inner;
        long emitted;
        int consumed;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapMaybeSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends MaybeSource<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.requested = new AtomicLong();
            this.inner = new ConcatMapMaybeObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void request(long n) {
            BackpressureHelper.add(this.requested, n);
            this.drain();
        }

        @Override
        public void cancel() {
            this.stop();
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerComplete() {
            this.state = 0;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.state = 0;
                this.drain();
            }
        }

        @Override
        void clearValue() {
            this.item = null;
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            SimpleQueue queue = this.queue;
            AtomicThrowable errors = this.errors;
            AtomicLong requested = this.requested;
            int limit = this.prefetch - (this.prefetch >> 1);
            boolean syncFused = this.syncFused;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.item = null;
                } else {
                    long e;
                    int s2 = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s2 == 0)) {
                        queue.clear();
                        this.item = null;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (s2 == 0) {
                        boolean empty;
                        Object v;
                        boolean d = this.done;
                        try {
                            v = queue.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.upstream.cancel();
                            errors.tryAddThrowableOrReport(ex);
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (!empty) {
                            MaybeSource<R> ms;
                            if (!syncFused) {
                                int c = this.consumed + 1;
                                if (c == limit) {
                                    this.consumed = 0;
                                    this.upstream.request(limit);
                                } else {
                                    this.consumed = c;
                                }
                            }
                            try {
                                ms = Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null MaybeSource");
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.upstream.cancel();
                                queue.clear();
                                errors.tryAddThrowableOrReport(ex);
                                errors.tryTerminateConsumer(downstream);
                                return;
                            }
                            this.state = 1;
                            ms.subscribe(this.inner);
                        }
                    } else if (s2 == 2 && (e = this.emitted) != requested.get()) {
                        R w = this.item;
                        this.item = null;
                        downstream.onNext(w);
                        this.emitted = e + 1L;
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapMaybeObserver<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapMaybeSubscriber<?, R> parent;

            ConcatMapMaybeObserver(ConcatMapMaybeSubscriber<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onSuccess(R t2) {
                this.parent.innerSuccess(t2);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

