/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableDebounceTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Consumer<? super T> onDropped;

    public ObservableDebounceTimed(ObservableSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.onDropped = onDropped;
    }

    @Override
    public void subscribeActual(Observer<? super T> t2) {
        this.source.subscribe(new DebounceTimedObserver<T>(new SerializedObserver<T>(t2), this.timeout, this.unit, this.scheduler.createWorker(), this.onDropped));
    }

    static final class DebounceEmitter<T>
    extends AtomicReference<Disposable>
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 6812032969491025141L;
        final T value;
        final long idx;
        final DebounceTimedObserver<T> parent;
        final AtomicBoolean once = new AtomicBoolean();

        DebounceEmitter(T value, long idx, DebounceTimedObserver<T> parent) {
            this.value = value;
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.once.compareAndSet(false, true)) {
                this.parent.emit(this.idx, this.value, this);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }

        public void setResource(Disposable d) {
            DisposableHelper.replace(this, d);
        }
    }

    static final class DebounceTimedObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Consumer<? super T> onDropped;
        Disposable upstream;
        DebounceEmitter<T> timer;
        volatile long index;
        boolean done;

        DebounceTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            DebounceEmitter<T> currentEmitter = this.timer;
            if (currentEmitter != null) {
                currentEmitter.dispose();
            }
            if (this.onDropped != null && currentEmitter != null) {
                try {
                    this.onDropped.accept(this.timer.value);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.dispose();
                    this.downstream.onError(ex);
                    this.done = true;
                }
            }
            DebounceEmitter<T> newEmitter = new DebounceEmitter<T>(t2, idx, this);
            this.timer = newEmitter;
            newEmitter.setResource(this.worker.schedule(newEmitter, this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            DebounceEmitter<T> d = this.timer;
            if (d != null) {
                d.dispose();
            }
            this.done = true;
            this.downstream.onError(t2);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DebounceEmitter<T> d = this.timer;
            if (d != null) {
                d.dispose();
            }
            if (d != null) {
                d.run();
            }
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        void emit(long idx, T t2, DebounceEmitter<T> emitter) {
            if (idx == this.index) {
                this.downstream.onNext(t2);
                emitter.dispose();
            }
        }
    }
}

